/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.editors.theme.ThemeEditorProvider;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorNotificationProvider
extends EditorNotifications.Provider<InfoPanel> {
    private static final Key<InfoPanel> KEY = Key.create((String)"android.editors.theme");
    private boolean myDismissed = false;

    @NotNull
    public Key<InfoPanel> getKey() {
        Key<InfoPanel> key = KEY;
        if (key == null) {
            ThemeEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    public InfoPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, final @NotNull Project project) {
        if (file == null) {
            ThemeEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ThemeEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ThemeEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue()) {
            return null;
        }
        if (this.myDismissed) {
            return null;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        if (!ThemeEditorProvider.isAndroidTheme(psiFile)) {
            return null;
        }
        if (!ThemeEditorUtils.findAndroidModules(project).findAny().isPresent()) {
            return null;
        }
        final InfoPanel panel2 = new InfoPanel();
        panel2.setText("Edit all themes in the project in the theme editor.");
        panel2.createActionLabel("Open editor", new Runnable(){

            @Override
            public void run() {
                ThemeEditorUtils.openThemeEditor(project);
            }
        });
        panel2.createActionLabel("Hide notification", new Runnable(){

            @Override
            public void run() {
                panel2.setVisible(false);
                ThemeEditorNotificationProvider.this.myDismissed = true;
            }
        });
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }
}

