/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.AttributesPanel;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorTable;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.AttributesGrouper;
import com.android.tools.idea.editors.theme.attributes.AttributesModelColorPaletteModel;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.attributes.editors.ParentRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListPaletteCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.preview.ThemePreviewComponent;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.intellij.find.FindManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.ui.JBColor;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorComponent
extends Splitter
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ThemeEditorComponent.class);
    private static final DefaultTableModel EMPTY_TABLE_MODEL = new DefaultTableModel();
    public static final JBColor PREVIEW_BACKGROUND = new JBColor(new Color(0xFFFFFF), new Color(3422009));
    public static final JBColor ALT_PREVIEW_BACKGROUND = new JBColor(new Color(0xFAFAFA), new Color(0x282828));
    private static final ImmutableMap<String, Integer> SORTING_MAP = ImmutableMap.builder().put((Object)"colorPrimary", (Object)1).put((Object)"colorPrimaryDark", (Object)2).put((Object)"colorAccent", (Object)3).build();
    public static final Comparator SIMPLE_MODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ConfiguredThemeEditorStyle) {
                return -1;
            }
            if (o2 instanceof ConfiguredThemeEditorStyle) {
                return 1;
            }
            if (o1 instanceof EditedStyleItem && o2 instanceof EditedStyleItem) {
                Integer pos1 = (Integer)SORTING_MAP.get((Object)((EditedStyleItem)o1).getAttrName());
                Integer pos2 = (Integer)SORTING_MAP.get((Object)((EditedStyleItem)o2).getAttrName());
                if (pos1 != null && pos2 != null) {
                    return pos1 - pos2;
                }
                if (pos1 != null) {
                    return -1;
                }
                if (pos2 != null) {
                    return 1;
                }
                return ((EditedStyleItem)o1).compareTo((EditedStyleItem)o2);
            }
            return Ordering.usingToString().compare(o1, o2);
        }
    };
    public static final int REGULAR_CELL_PADDING = 4;
    public static final int LARGE_CELL_PADDING = 10;
    public static final float COLOR_DISTANCE_THRESHOLD = 8.5f;
    private final Project myProject;
    private EditedStyleItem mySubStyleSourceAttribute;
    @Nullable
    private String myThemeName;
    @Nullable
    private String mySubStyleName;
    private final ThemeEditorContext myThemeEditorContext;
    private final ThemePreviewComponent myPreviewComponent;
    private final StyleAttributesFilter myAttributesFilter;
    private TableRowSorter<AttributesTableModel> myAttributesSorter;
    private final SimpleModeFilter mySimpleModeFilter;
    private final AttributesPanel myPanel;
    private final ThemeEditorTable myAttributesTable;
    private final ResourceNotificationManager.ResourceChangeListener myResourceChangeListener;
    private Disposable myResourceNotificationUnsubscriber;
    private final ThemeSelectionPanel.ThemeChangedListener myThemeChangedListener;
    private MutableCollectionComboBoxModel<Module> myModuleComboModel;
    private String myPreviewThemeName;
    private AttributesTableModel myModel;
    private SwingWorker<Boolean, Object> mySwingWorker;

    public ThemeEditorComponent(@NotNull Project project) {
        if (project == null) {
            ThemeEditorComponent.$$$reportNull$$$0(0);
        }
        this.myThemeChangedListener = new ThemeSelectionPanel.ThemeChangedListener(){

            @Override
            public void themeChanged(@NotNull String name) {
                if (name == null) {
                    2.$$$reportNull$$$0(0);
                }
                ThemeEditorComponent.this.refreshPreviewPanel(name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ThemeEditorComponent$2", "themeChanged"));
            }
        };
        this.myProject = project;
        this.myPanel = new AttributesPanel();
        this.initializeModulesCombo(null);
        this.myPanel.addModuleChangedActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myThemeName, ThemeEditorComponent.this.mySubStyleName, ThemeEditorComponent.this.getSelectedModule().getName());
            }
        });
        Module selectedModule = (Module)this.myModuleComboModel.getSelected();
        assert (selectedModule != null && !selectedModule.isDisposed());
        Configuration configuration = ThemeEditorUtils.getConfigurationForModule(selectedModule);
        this.myThemeEditorContext = new ThemeEditorContext(configuration);
        Disposer.register((Disposable)this, (Disposable)this.myThemeEditorContext);
        this.myThemeEditorContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 0xF6) != 0) {
                    ThemeEditorComponent.this.loadStyleAttributes();
                    ThemeEditorComponent.this.myThemeEditorContext.getConfiguration().save();
                }
                return true;
            }
        });
        this.myPreviewComponent = new ThemePreviewComponent(this.myThemeEditorContext);
        Disposer.register((Disposable)this, (Disposable)this.myPreviewComponent);
        GoToListener goToListener = new GoToListener(){

            @Override
            public void goTo(@NotNull EditedStyleItem value2) {
                if (value2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                ResourceResolver resolver = ThemeEditorComponent.this.myThemeEditorContext.getResourceResolver();
                if (value2.isAttr() && ThemeEditorComponent.this.getUsedStyle() != null && resolver != null) {
                    StyleItemResourceValue resourceValue2 = (StyleItemResourceValue)resolver.findResValue(value2.getValue(), false);
                    if (resourceValue2 == null) {
                        LOG.error("Unable to resolve " + value2.getValue());
                        return;
                    }
                    ThemeEditorComponent.this.mySubStyleName = ResolutionUtils.getQualifiedValue(resourceValue2);
                } else {
                    ThemeEditorComponent.this.mySubStyleName = value2.getValue();
                }
                ThemeEditorComponent.this.mySubStyleSourceAttribute = value2;
                ThemeEditorComponent.this.loadStyleAttributes();
            }

            @Override
            public void goToParent() {
                ThemeEditorComponent.this.goToParent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ThemeEditorComponent$5", "goTo"));
            }
        };
        this.myAttributesTable = this.myPanel.getAttributesTable();
        ParentRendererEditor.ThemeParentChangedListener themeParentChangedListener = new ParentRendererEditor.ThemeParentChangedListener(){
            private final List<StyleItemResourceValue> myOriginalItems = Lists.newArrayList();
            private String myModifiedParent;

            private void restoreOriginalTheme(@NotNull ConfiguredThemeEditorStyle modifiedTheme, @NotNull List<StyleItemResourceValue> originalItems) {
                if (modifiedTheme == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (originalItems == null) {
                    6.$$$reportNull$$$0(1);
                }
                StyleResourceValueImpl modifiedResourceValue = modifiedTheme.getStyleResourceValue();
                StyleResourceValueImpl restoredResourceValue = new StyleResourceValueImpl(modifiedResourceValue.asReference(), modifiedResourceValue.getParentStyleName(), modifiedResourceValue.getLibraryName());
                for (StyleItemResourceValue item : originalItems) {
                    restoredResourceValue.addItem(item);
                }
                modifiedResourceValue.replaceWith((ResourceValue)restoredResourceValue);
            }

            @Override
            public void themeChanged(@NotNull String name) {
                if (name == null) {
                    6.$$$reportNull$$$0(2);
                }
                ThemeResolver themeResolver = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver();
                if (this.myModifiedParent != null) {
                    ConfiguredThemeEditorStyle modifiedTheme = themeResolver.getTheme(this.myModifiedParent);
                    assert (modifiedTheme != null);
                    this.restoreOriginalTheme(modifiedTheme, this.myOriginalItems);
                }
                this.myModifiedParent = name;
                ConfiguredThemeEditorStyle newParent = themeResolver.getTheme(name);
                assert (newParent != null);
                StyleResourceValueImpl newParentStyleResourceValue = newParent.getStyleResourceValue();
                this.myOriginalItems.clear();
                this.myOriginalItems.addAll(newParentStyleResourceValue.getDefinedItems());
                assert (ThemeEditorComponent.this.myThemeName != null);
                ConfiguredThemeEditorStyle myCurrentTheme = themeResolver.getTheme(ThemeEditorComponent.this.myThemeName);
                assert (myCurrentTheme != null);
                for (StyleItemResourceValue item : myCurrentTheme.getStyleResourceValue().getDefinedItems()) {
                    newParentStyleResourceValue.addItem(item);
                }
                ThemeEditorComponent.this.myPreviewThemeName = null;
                ThemeEditorComponent.this.refreshPreviewPanel(name);
            }

            @Override
            public void reset() {
                ThemeResolver themeResolver = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver();
                if (this.myModifiedParent != null) {
                    ConfiguredThemeEditorStyle modifiedTheme = themeResolver.getTheme(this.myModifiedParent);
                    assert (modifiedTheme != null);
                    this.restoreOriginalTheme(modifiedTheme, this.myOriginalItems);
                }
                this.myModifiedParent = null;
                this.myOriginalItems.clear();
                if (ThemeEditorComponent.this.myThemeName != null) {
                    ThemeEditorComponent.this.refreshPreviewPanel(ThemeEditorComponent.this.myThemeName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modifiedTheme";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "originalItems";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorComponent$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "restoreOriginalTheme";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "themeChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myAttributesTable.customizeTable(this.myThemeEditorContext, this.myPreviewComponent.getPreviewPanel(), themeParentChangedListener);
        this.myAttributesTable.setGoToListener(goToListener);
        this.updateUiParameters();
        this.myAttributesFilter = new StyleAttributesFilter();
        this.mySimpleModeFilter = new SimpleModeFilter();
        this.myPanel.getBackButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.mySubStyleName = null;
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        this.myPanel.getAdvancedFilterCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ThemeEditorComponent.this.myAttributesTable.clearSelection();
                ThemeEditorComponent.this.myPanel.getPalette().clearSelection();
                ThemeEditorComponent.this.configureFilter();
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myAttributesTable.updateRowHeights();
            }
        });
        this.myPanel.getThemeCombo().setRenderer(new StyleListPaletteCellRenderer(this.myThemeEditorContext, this.myThemeChangedListener, this.myPanel.getThemeCombo()));
        this.myPanel.getThemeCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)ThemeEditorComponent.this.myPanel.getThemeCombo().getSelectedItem();
                if (!ThemesListModel.isSpecialOption(selectedItem)) {
                    ThemeEditorComponent.this.myThemeName = selectedItem;
                    ThemeEditorComponent.this.myPreviewThemeName = null;
                    ThemeEditorComponent.this.mySubStyleName = null;
                    ThemeEditorComponent.this.mySubStyleSourceAttribute = null;
                    ThemeEditorComponent.this.loadStyleAttributes();
                } else {
                    ThemeEditorComponent.this.myPanel.setSelectedTheme(ThemeEditorComponent.this.myThemeName);
                    if ("Create New Theme".equals(selectedItem)) {
                        ThemeEditorComponent.this.createNewTheme();
                    } else if ("Show all themes".equals(selectedItem)) {
                        ThemeEditorComponent.this.selectNewTheme();
                    } else {
                        ThemeEditorComponent.this.renameTheme();
                    }
                }
            }
        });
        this.myPanel.getThemeCombo().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (ThemeEditorComponent.this.myThemeName != null) {
                    ThemeEditorComponent.this.refreshPreviewPanel(ThemeEditorComponent.this.myThemeName);
                }
            }
        });
        this.myPanel.getAttrGroupCombo().setModel(new DefaultComboBoxModel<AttributesGrouper.GroupBy>(AttributesGrouper.GroupBy.values()));
        this.myPanel.getAttrGroupCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        this.setFirstComponent(this.myPreviewComponent);
        this.setSecondComponent(this.myPanel.getRightPanel());
        this.setShowDividerControls(false);
        this.setProportion(0.67f);
        this.myResourceChangeListener = new ResourceNotificationManager.ResourceChangeListener(){

            @Override
            public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
                if (reason == null) {
                    12.$$$reportNull$$$0(0);
                }
                ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myThemeName, ThemeEditorComponent.this.mySubStyleName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/editors/theme/ThemeEditorComponent$12", "resourcesChanged"));
            }
        };
        JPopupMenu themeNamePopupMenu = new JPopupMenu();
        themeNamePopupMenu.add(new JMenuItem(new AbstractAction("Find Usages"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguredThemeEditorStyle style = ThemeEditorComponent.this.getUsedStyle();
                assert (style != null);
                if (style.isProjectStyle()) {
                    PsiElement name = style.getNamePsiElement();
                    assert (name != null);
                    FindManager.getInstance((Project)ThemeEditorComponent.this.myProject).findUsages(name);
                }
            }
        }));
        this.myPanel.setThemeNamePopupMenu(themeNamePopupMenu);
        this.myPanel.setSelectActivityForTheme(e -> {
            ConfiguredThemeEditorStyle theme = this.getSelectedTheme();
            assert (theme != null);
            String themeUrl = ResolutionUtils.getStyleResourceUrl(theme.getQualifiedName());
            ThemeEditorUtils.quickfixThemeToActivity(this.myThemeEditorContext.getCurrentContextModule(), themeUrl);
        });
        this.reload(null);
    }

    @NotNull
    public Module getSelectedModule() {
        Module module = (Module)this.myModuleComboModel.getSelected();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            ThemeEditorComponent.$$$reportNull$$$0(1);
        }
        return module2;
    }

    private void initializeModulesCombo(@Nullable String defaultModuleName) {
        ImmutableList modules = (ImmutableList)ThemeEditorUtils.findAndroidModules(this.myProject).collect(ImmutableList.toImmutableList());
        assert (!modules.isEmpty()) : "Theme Editor shouldn't be launched in a project with no Android modules";
        Module defaultModule = null;
        for (Module module : modules) {
            assert (!module.isDisposed());
            if (!module.getName().equals(defaultModuleName)) continue;
            defaultModule = module;
            break;
        }
        this.myModuleComboModel = defaultModule == null ? new MutableCollectionComboBoxModel((List)modules) : new MutableCollectionComboBoxModel((List)modules, defaultModule);
        this.myPanel.setModuleModel((ComboBoxModel)this.myModuleComboModel);
    }

    private void unsubscribeResourceNotification(@NotNull ResourceNotificationManager manager, @NotNull AndroidFacet facet) {
        if (manager == null) {
            ThemeEditorComponent.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            ThemeEditorComponent.$$$reportNull$$$0(3);
        }
        if (this.myResourceNotificationUnsubscriber != null) {
            manager.removeListener(this.myResourceChangeListener, facet, null, null);
            Disposable unsubscriber = this.myResourceNotificationUnsubscriber;
            this.myResourceNotificationUnsubscriber = null;
            Disposer.dispose((Disposable)unsubscriber);
        }
    }

    private void unsubscribeResourceNotification() {
        if (this.myThemeEditorContext.getCurrentContextModule().isDisposed()) {
            return;
        }
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myThemeEditorContext.getProject());
        AndroidFacet facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentContextModule());
        assert (facet != null) : this.myThemeEditorContext.getCurrentContextModule().getName() + " module doesn't have an AndroidFacet";
        this.unsubscribeResourceNotification(manager, facet);
    }

    private void subscribeResourceNotification() {
        if (this.myResourceNotificationUnsubscriber != null) {
            return;
        }
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myThemeEditorContext.getProject());
        AndroidFacet facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentContextModule());
        assert (facet != null) : this.myThemeEditorContext.getCurrentContextModule().getName() + " module doesn't have an AndroidFacet";
        manager.addListener(this.myResourceChangeListener, facet, null, null);
        this.myResourceNotificationUnsubscriber = () -> this.unsubscribeResourceNotification(manager, facet);
        Disposer.register((Disposable)facet, (Disposable)this.myResourceNotificationUnsubscriber);
    }

    public void selectNotify() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myThemeEditorContext.getCurrentContextModule().isDisposed()) {
                this.reload(this.myThemeName, this.mySubStyleName);
            }
        });
    }

    public void deselectNotify() {
        this.unsubscribeResourceNotification();
    }

    private void configureFilter() {
        if (this.myPanel.isAdvancedMode()) {
            this.myAttributesFilter.setFilterEnabled(false);
            this.myAttributesSorter.setRowFilter(this.myAttributesFilter);
            this.myAttributesSorter.setSortKeys(null);
        } else {
            this.mySimpleModeFilter.configure((Set<String>)this.myModel.getDefinedAttributes(), ThemeEditorUtils.isSelectedAppCompatTheme(this.myThemeEditorContext));
            this.myAttributesSorter.setRowFilter(this.mySimpleModeFilter);
            this.myAttributesSorter.setSortKeys((List<RowSorter.SortKey>)ImmutableList.of((Object)new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        }
    }

    private void createNewTheme() {
        String newThemeName = ThemeEditorUtils.showCreateNewStyleDialog(this.getSelectedTheme(), this.myThemeEditorContext, !this.isSubStyleSelected(), true, null, this.myThemeChangedListener);
        if (newThemeName != null) {
            this.myThemeName = newThemeName;
            this.mySubStyleName = null;
        } else if (this.myThemeName != null) {
            this.refreshPreviewPanel(this.myThemeName);
        }
    }

    private void selectNewTheme() {
        String newThemeName;
        ThemeSelectionDialog dialog = new ThemeSelectionDialog(this.myThemeEditorContext.getConfiguration());
        dialog.setThemeChangedListener(this.myThemeChangedListener);
        boolean themeSelected = dialog.showAndGet();
        if (themeSelected && (newThemeName = dialog.getTheme()) != null) {
            this.reload(newThemeName);
        }
        if (this.myThemeName != null) {
            this.refreshPreviewPanel(this.myThemeName);
        }
    }

    private void renameTheme() {
        ConfiguredThemeEditorStyle selectedTheme = this.getSelectedTheme();
        assert (selectedTheme != null);
        assert (selectedTheme.isProjectStyle());
        final PsiElement namePsiElement = selectedTheme.getNamePsiElement();
        if (namePsiElement == null) {
            return;
        }
        RenameDialog renameDialog = new RenameDialog(this.myThemeEditorContext.getProject(), namePsiElement, null, null){

            protected RenameProcessor createRenameProcessor(String newName2) {
                return new RenameProcessor(ThemeEditorComponent.this.myThemeEditorContext.getProject(), namePsiElement, newName2, this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    @NotNull
                    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LinkedHashMap map2 = new LinkedHashMap();
                        this.getElements().stream().filter(element -> !(element instanceof PsiField)).forEach(element -> map2.put(element, this.getNewName((PsiElement)element)));
                        RenameViewDescriptor renameViewDescriptor = new RenameViewDescriptor(map2);
                        if (renameViewDescriptor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return renameViewDescriptor;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "usages";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorComponent$14$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorComponent$14$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createUsageViewDescriptor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createUsageViewDescriptor";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
        };
        renameDialog.show();
        if (renameDialog.isOK()) {
            String newName2 = renameDialog.getNewName();
            this.myThemeName = selectedTheme.getQualifiedName().replace(selectedTheme.getName(), newName2);
            this.mySubStyleName = null;
        }
    }

    public void goToParent() {
        ConfiguredThemeEditorStyle selectedStyle = this.getUsedStyle();
        if (selectedStyle == null) {
            LOG.error("No style selected.");
            return;
        }
        ConfiguredThemeEditorStyle parent = this.getUsedStyle().getParent(this.myThemeEditorContext.getThemeResolver());
        assert (parent != null);
        if (this.isSubStyleSelected()) {
            this.mySubStyleName = parent.getQualifiedName();
            this.loadStyleAttributes();
        } else {
            this.myPanel.setSelectedTheme(parent.getQualifiedName());
        }
    }

    @Nullable
    ConfiguredThemeEditorStyle getPreviewTheme() {
        if (this.myPreviewThemeName != null) {
            return this.myThemeEditorContext.getThemeResolver().getTheme(this.myPreviewThemeName);
        }
        return null;
    }

    @Nullable
    ConfiguredThemeEditorStyle getSelectedTheme() {
        if (this.myThemeName != null) {
            return this.myThemeEditorContext.getThemeResolver().getTheme(this.myThemeName);
        }
        return null;
    }

    @Nullable
    private ConfiguredThemeEditorStyle getUsedStyle() {
        if (this.mySubStyleName != null) {
            return this.getCurrentSubStyle();
        }
        return this.getSelectedTheme();
    }

    @Nullable
    ConfiguredThemeEditorStyle getCurrentSubStyle() {
        if (this.mySubStyleName == null) {
            return null;
        }
        return this.myThemeEditorContext.getThemeResolver().getTheme(this.mySubStyleName);
    }

    private boolean isSubStyleSelected() {
        return this.mySubStyleName != null;
    }

    @NotNull
    private AttributesGrouper.GroupBy getSelectedAttrGroup() {
        AttributesGrouper.GroupBy groupBy = (AttributesGrouper.GroupBy)((Object)this.myPanel.getAttrGroupCombo().getSelectedItem());
        if (groupBy == null) {
            ThemeEditorComponent.$$$reportNull$$$0(4);
        }
        return groupBy;
    }

    private void createNewThemeWithAttributeValue(final @NotNull EditedStyleItem rv, final @NotNull String strValue) {
        String sourcePropertyName;
        if (rv == null) {
            ThemeEditorComponent.$$$reportNull$$$0(5);
        }
        if (strValue == null) {
            ThemeEditorComponent.$$$reportNull$$$0(6);
        }
        if (strValue.equals(rv.getValue())) {
            return;
        }
        ConfiguredThemeEditorStyle selectedStyle = this.getUsedStyle();
        if (selectedStyle == null) {
            LOG.error("No style/theme selected.");
            return;
        }
        boolean isSubStyleSelected = this.isSubStyleSelected();
        String message = String.format("<html>The %1$s '<code>%2$s</code>' is Read-Only.<br/>A new %1$s will be created to modify '<code>%3$s</code>'.<br/></html>", isSubStyleSelected ? "style" : "theme", selectedStyle.getQualifiedName(), rv.getAttrName());
        final StyleItemResourceValue originalValue = rv.getSelectedValue();
        ParentRendererEditor.ThemeParentChangedListener themeListener = new ParentRendererEditor.ThemeParentChangedListener(){
            private ConfiguredThemeEditorStyle myModifiedTheme;

            @Override
            public void themeChanged(@NotNull String name) {
                if (name == null) {
                    15.$$$reportNull$$$0(0);
                }
                if (this.myModifiedTheme != null) {
                    this.myModifiedTheme.getStyleResourceValue().addItem(originalValue);
                }
                this.myModifiedTheme = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver().getTheme(name);
                assert (this.myModifiedTheme != null);
                StyleItemResourceValueImpl newSelectedValue = new StyleItemResourceValueImpl(originalValue.getNamespace(), originalValue.getAttrName(), strValue, null);
                this.myModifiedTheme.getStyleResourceValue().addItem((StyleItemResourceValue)newSelectedValue);
                ThemeEditorComponent.this.myPreviewThemeName = null;
                ThemeEditorComponent.this.refreshPreviewPanel(name);
            }

            @Override
            public void reset() {
                this.myModifiedTheme.getStyleResourceValue().addItem(originalValue);
                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myThemeName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ThemeEditorComponent$15", "themeChanged"));
            }
        };
        final String newStyleName = ThemeEditorUtils.showCreateNewStyleDialog(selectedStyle, this.myThemeEditorContext, !isSubStyleSelected, false, message, isSubStyleSelected ? null : themeListener);
        if (!isSubStyleSelected) {
            themeListener.reset();
        }
        if (newStyleName == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                ConfiguredThemeEditorStyle newStyle = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver().getTheme(newStyleName);
                assert (newStyle != null);
                newStyle.setValue(rv.getQualifiedName(), strValue);
            }
        });
        if (!isSubStyleSelected) {
            this.myThemeName = newStyleName;
            this.mySubStyleName = null;
            return;
        }
        ConfiguredThemeEditorStyle selectedTheme = this.getSelectedTheme();
        if (selectedTheme == null) {
            LOG.error("No theme selected.");
            return;
        }
        String string = sourcePropertyName = this.mySubStyleSourceAttribute.isAttr() ? this.mySubStyleSourceAttribute.getAttrPropertyName() : this.mySubStyleSourceAttribute.getQualifiedName();
        if (selectedTheme.isReadOnly()) {
            message = String.format("<html>The style '%1$s' which references to '%2$s' is also Read-Only.<br/>A new theme will be created to point to the modified style '%3$s'.<br/></html>", selectedTheme.getQualifiedName(), rv.getAttrName(), newStyleName);
            final String newThemeName = ThemeEditorUtils.showCreateNewStyleDialog(selectedTheme, this.myThemeEditorContext, true, false, message, themeListener);
            themeListener.reset();
            if (newThemeName != null) {
                this.myThemeName = newThemeName;
                this.mySubStyleName = newStyleName;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorComponent.this.myThemeEditorContext.updateThemeResolver();
                        ConfiguredThemeEditorStyle newTheme = ThemeEditorComponent.this.myThemeEditorContext.getThemeResolver().getTheme(newThemeName);
                        assert (newTheme != null);
                        newTheme.setValue(sourcePropertyName, newStyleName);
                    }
                });
            }
        } else {
            selectedTheme.setValue(sourcePropertyName, newStyleName);
            this.mySubStyleName = newStyleName;
        }
    }

    public void reload(@Nullable String defaultThemeName) {
        this.reload(defaultThemeName, null);
    }

    public void reload(@Nullable String defaultThemeName, @Nullable String defaultSubStyleName) {
        this.reload(defaultThemeName, defaultSubStyleName, this.getSelectedModule().getName());
    }

    public void reload(@Nullable String defaultThemeName, @Nullable String defaultSubStyleName, @Nullable String defaultModuleName) {
        this.unsubscribeResourceNotification();
        if (!ThemeEditorUtils.isThemeEditorSelected(this.myProject)) {
            return;
        }
        this.myPreviewThemeName = null;
        this.initializeModulesCombo(defaultModuleName);
        this.myThemeEditorContext.setCurrentContextModule(this.getSelectedModule());
        this.subscribeResourceNotification();
        this.mySubStyleSourceAttribute = null;
        ThemeResolver themeResolver = this.myThemeEditorContext.getThemeResolver();
        this.myPanel.getThemeCombo().setModel(new ThemesListModel(this.myThemeEditorContext, (List<String>)ThemeEditorUtils.getDefaultThemeNames(themeResolver), defaultThemeName));
        this.myThemeName = (String)this.myPanel.getThemeCombo().getSelectedItem();
        this.mySubStyleName = StringUtil.equals((CharSequence)this.myThemeName, (CharSequence)defaultThemeName) ? defaultSubStyleName : null;
        this.loadStyleAttributes();
    }

    private void loadStyleAttributes() {
        ConfiguredThemeEditorStyle selectedTheme = this.getPreviewTheme();
        ConfiguredThemeEditorStyle selectedStyle = null;
        if (selectedTheme == null) {
            selectedTheme = this.getSelectedTheme();
            selectedStyle = this.getCurrentSubStyle();
        }
        this.myAttributesTable.setRowSorter(null);
        this.myPanel.setSubstyleName(this.mySubStyleName);
        this.myPanel.getBackButton().setVisible(this.mySubStyleName != null);
        AndroidThemePreviewPanel previewPanel = this.myPreviewComponent.getPreviewPanel();
        if (selectedTheme == null) {
            if (this.myThemeName != null) {
                previewPanel.setErrorMessage("The theme " + this.myThemeName + " cannot be rendered in the current configuration");
            } else {
                previewPanel.setErrorMessage("No theme selected");
            }
            this.myAttributesTable.setModel(EMPTY_TABLE_MODEL);
            return;
        }
        previewPanel.setErrorMessage(null);
        this.myPanel.setShowThemeNotUsedWarning(false);
        if (selectedTheme.isProjectStyle()) {
            PsiElement name = selectedTheme.getNamePsiElement();
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
                assert (name != null);
                this.myPanel.setShowThemeNotUsedWarning(ReferencesSearch.search((PsiElement)name).findFirst() == null);
            });
        }
        this.myThemeEditorContext.setCurrentTheme(selectedTheme);
        Configuration configuration = this.myThemeEditorContext.getConfiguration();
        configuration.setTheme(selectedTheme.getStyleResourceUrl());
        this.myModel = new AttributesTableModel(selectedStyle != null ? selectedStyle : selectedTheme, this.getSelectedAttrGroup(), this.myThemeEditorContext);
        this.myModel.addThemePropertyChangedListener(new AttributesTableModel.ThemePropertyChangedListener(){

            @Override
            public void attributeChangedOnReadOnlyTheme(EditedStyleItem attribute, String newValue) {
                ThemeEditorComponent.this.createNewThemeWithAttributeValue(attribute, newValue);
            }
        });
        this.myAttributesSorter = new TableRowSorter<AttributesTableModel>(this.myModel);
        this.myAttributesSorter.setComparator(0, SIMPLE_MODE_COMPARATOR);
        this.configureFilter();
        int row = this.myAttributesTable.getEditingRow();
        int column = this.myAttributesTable.getEditingColumn();
        this.myAttributesTable.removeEditor();
        this.myAttributesTable.setModel(this.myModel);
        this.myAttributesTable.setRowSorter(this.myAttributesSorter);
        this.myAttributesTable.updateRowHeights();
        this.myAttributesTable.editCellAt(row, column);
        this.myPanel.getPalette().setModel(new AttributesModelColorPaletteModel(configuration, this.myModel));
        this.myPanel.getPalette().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AttributesModelColorPaletteModel model = (AttributesModelColorPaletteModel)ThemeEditorComponent.this.myPanel.getPalette().getModel();
                    List<EditedStyleItem> references = model.getReferences((Color)e.getItem());
                    if (references.isEmpty()) {
                        return;
                    }
                    HashSet<String> attributeNames = new HashSet<String>(references.size());
                    for (EditedStyleItem item : references) {
                        attributeNames.add(item.getQualifiedName());
                    }
                    ThemeEditorComponent.this.myAttributesFilter.setAttributesFilter(attributeNames);
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(true);
                } else {
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(false);
                }
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myPanel.getAdvancedFilterCheckBox().getModel().setSelected(!((ThemeEditorComponent)ThemeEditorComponent.this).myAttributesFilter.myIsFilterEnabled);
            }
        });
        this.myAttributesTable.updateRowHeights();
        ResourceResolver resourceResolver = this.myThemeEditorContext.getResourceResolver();
        assert (resourceResolver != null);
        this.myPreviewComponent.setPreviewBackground((Color)ThemeEditorUtils.getGoodContrastPreviewBackground(selectedTheme, resourceResolver));
        this.myPreviewComponent.reloadPreviewContents();
        this.myAttributesTable.repaint();
        this.myPanel.getThemeCombo().repaint();
    }

    private void refreshPreviewPanel(@NotNull String previewThemeName) {
        if (previewThemeName == null) {
            ThemeEditorComponent.$$$reportNull$$$0(7);
        }
        if (!previewThemeName.equals(this.myPreviewThemeName)) {
            this.myPreviewThemeName = previewThemeName;
            ConfiguredThemeEditorStyle previewTheme = this.getPreviewTheme();
            if (previewTheme == null) {
                return;
            }
            this.myThemeEditorContext.setCurrentTheme(previewTheme);
            Configuration configuration = this.myThemeEditorContext.getConfiguration();
            configuration.setTheme(previewTheme.getStyleResourceUrl());
            ResourceResolver resourceResolver = this.myThemeEditorContext.getResourceResolver();
            assert (resourceResolver != null);
            this.myPreviewComponent.setPreviewBackground((Color)ThemeEditorUtils.getGoodContrastPreviewBackground(previewTheme, resourceResolver));
            this.myPreviewComponent.reloadPreviewContents();
        }
    }

    public void dispose() {
        this.myAttributesTable.removeEditor();
        if (this.mySwingWorker != null) {
            this.mySwingWorker.cancel(true);
        }
        if (this.myResourceNotificationUnsubscriber != null) {
            Disposer.dispose((Disposable)this.myResourceNotificationUnsubscriber);
        }
        super.dispose();
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        this.updateUiParameters();
    }

    private void updateUiParameters() {
        if (this.myAttributesTable == null) {
            return;
        }
        Font regularFont = UIUtil.getLabelFont();
        int regularFontSize = this.getFontMetrics(regularFont).getHeight();
        Font headerFont = regularFont.deriveFont((float)regularFontSize * 1.3f);
        int headerFontSize = this.getFontMetrics(headerFont).getHeight();
        ResourceComponent sampleComponent = new ResourceComponent(this.myProject, false);
        int bigCellSize = sampleComponent.getPreferredSize().height;
        this.myAttributesTable.setClassHeights((Map<Class<?>, Integer>)ImmutableMap.of(Object.class, (Object)(regularFontSize + 4), Color.class, (Object)bigCellSize, DrawableDomElement.class, (Object)bigCellSize, TableLabel.class, (Object)(headerFontSize + 10), AttributesTableModel.ParentAttribute.class, (Object)bigCellSize));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rv";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewThemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAttrGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unsubscribeResourceNotification";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewThemeWithAttributeValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshPreviewPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class StyleAttributesFilter
    extends AttributesFilter {
        StyleAttributesFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = Collections.emptySet();
        }

        public void setFilterEnabled(boolean enabled) {
            this.myIsFilterEnabled = enabled;
        }

        public void setAttributesFilter(@NotNull Set<String> attributeNames) {
            if (attributeNames == null) {
                StyleAttributesFilter.$$$reportNull$$$0(0);
            }
            this.filterAttributes = ImmutableSet.copyOf(attributeNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeNames", "com/android/tools/idea/editors/theme/ThemeEditorComponent$StyleAttributesFilter", "setAttributesFilter"));
        }
    }

    abstract class AttributesFilter
    extends RowFilter<AttributesTableModel, Integer> {
        boolean myIsFilterEnabled;
        Set<String> filterAttributes;

        AttributesFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends AttributesTableModel, ? extends Integer> entry) {
            if (!this.myIsFilterEnabled) {
                return true;
            }
            int row = entry.getIdentifier();
            if (entry.getModel().isThemeParentRow(row)) {
                return true;
            }
            Object value2 = entry.getModel().getValueAt(row, 1);
            if (value2 instanceof TableLabel) {
                return false;
            }
            String attributeName = value2 instanceof EditedStyleItem ? ((EditedStyleItem)value2).getQualifiedName() : value2.toString();
            ConfiguredThemeEditorStyle selectedTheme = ThemeEditorComponent.this.getUsedStyle();
            if (selectedTheme == null) {
                LOG.error("No theme selected.");
                return false;
            }
            return this.filterAttributes.contains(attributeName);
        }
    }

    class SimpleModeFilter
    extends AttributesFilter {
        public final Set<String> ATTRIBUTES_DEFAULT_FILTER = ImmutableSet.of((Object)"colorPrimary", (Object)"colorPrimaryDark", (Object)"colorAccent", (Object)"colorForeground", (Object)"textColorPrimary", (Object)"textColorSecondary", (Object[])new String[]{"textColorPrimaryInverse", "textColorSecondaryInverse", "colorBackground", "windowBackground", "navigationBarColor", "statusBarColor"});

        SimpleModeFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = new HashSet();
        }

        public void configure(Set<String> availableAttributes, boolean appCompat) {
            this.filterAttributes.clear();
            for (String candidate : this.ATTRIBUTES_DEFAULT_FILTER) {
                if (appCompat && availableAttributes.contains(candidate)) {
                    this.filterAttributes.add(candidate);
                    continue;
                }
                this.filterAttributes.add("android:" + candidate);
            }
        }
    }

    public static interface GoToListener {
        public void goTo(@NotNull EditedStyleItem var1);

        public void goToParent();
    }
}

