/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.SubTable;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenColumnTable {
    private TableModel myModel;
    private final int myFrozenColumnCount;
    private final Collection<FrozenColumnTableListener> myListeners;
    private SubTable myFrozenTable;
    private SubTable myScrollableTable;
    private JScrollPane myScrollPane;
    private int rowHeight;
    private int mySelectedRow;
    private int mySelectedColumn;

    FrozenColumnTable(@NotNull TableModel model, int frozenColumnCount) {
        if (model == null) {
            FrozenColumnTable.$$$reportNull$$$0(0);
        }
        this.myModel = model;
        this.myFrozenColumnCount = frozenColumnCount;
        this.myListeners = new ArrayList<FrozenColumnTableListener>();
        this.initFrozenTable();
        this.initScrollableTable();
        this.initScrollPane();
        this.mySelectedRow = -1;
        this.mySelectedColumn = -1;
    }

    private void initFrozenTable() {
        this.myFrozenTable = new SubTable(new SubTableModel(this.myModel, () -> 0, () -> this.myFrozenColumnCount), this);
        this.myFrozenTable.setName("frozenTable");
        IntUnaryOperator converter = IntUnaryOperator.identity();
        this.myFrozenTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myFrozenTable.getSelectionModel().addListSelectionListener(event -> {
            this.myScrollableTable.setSelectedRow(this.myFrozenTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myFrozenTable.getSelectedColumn() == -1) {
                return;
            }
            this.myScrollableTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JViewport header = FrozenColumnTable.this.myScrollPane.getRowHeader();
                Dimension size = ((Component)header).getPreferredSize();
                size.width = FrozenColumnTable.this.myFrozenTable.getWidth();
                ((Component)header).setPreferredSize(size);
                FrozenColumnTable.this.myScrollPane.revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/table/FrozenColumnTable$1", "componentResized"));
            }
        });
        this.myFrozenTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void initScrollableTable() {
        this.myScrollableTable = new SubTable(new SubTableModel(this.myModel, () -> this.myFrozenColumnCount, this.myModel::getColumnCount), this);
        this.myScrollableTable.setName("scrollableTable");
        IntUnaryOperator converter = viewColumnIndex -> this.myFrozenTable.getColumnCount() + viewColumnIndex;
        this.myScrollableTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myScrollableTable.getSelectionModel().addListSelectionListener(event -> {
            this.myFrozenTable.setSelectedRow(this.myScrollableTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myScrollableTable.getSelectedColumn() == -1) {
                return;
            }
            this.myFrozenTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void fireSelectedCellChanged() {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (this.mySelectedRow == selectedRow && this.mySelectedColumn == selectedColumn) {
            return;
        }
        this.mySelectedRow = selectedRow;
        this.mySelectedColumn = selectedColumn;
        this.myListeners.forEach(listener2 -> listener2.selectedCellChanged());
    }

    private void initScrollPane() {
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myScrollableTable));
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myFrozenTable.getTableHeader());
        this.myScrollPane.setRowHeaderView((Component)((Object)this.myFrozenTable));
    }

    boolean includeColumn(int modelColumnIndex) {
        return true;
    }

    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        TableColumn tableColumn = new TableColumn(modelColumnIndex);
        if (tableColumn == null) {
            FrozenColumnTable.$$$reportNull$$$0(1);
        }
        return tableColumn;
    }

    public final void selectCellAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            this.myFrozenTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
            this.myFrozenTable.setColumnSelectionInterval(viewColumnIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
        this.myScrollableTable.setColumnSelectionInterval(viewColumnIndex -= count, viewColumnIndex);
    }

    public final int getSelectedModelRowIndex() {
        int index = this.myFrozenTable.convertRowIndexToModel(this.myFrozenTable.getSelectedRow());
        assert (index == this.myScrollableTable.convertRowIndexToModel(this.myScrollableTable.getSelectedRow()));
        return index;
    }

    public final int getSelectedModelColumnIndex() {
        SubTable table2;
        int index = this.getSelectedColumn();
        if (index == -1) {
            return -1;
        }
        int count = this.myFrozenTable.getColumnCount();
        if (index < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            index -= count;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).getColumnModel().getColumn(index).getModelIndex());
    }

    public final int[] getSelectedModelRowIndices() {
        int[] indices = this.myFrozenTable.getSelectedModelRowIndices();
        assert (Arrays.equals(indices, this.myScrollableTable.getSelectedModelRowIndices()));
        return indices;
    }

    public final int[] getSelectedModelColumnIndices() {
        int[] frozenIndices = this.myFrozenTable.getSelectedModelColumnIndices();
        int[] scrollableIndices = this.myScrollableTable.getSelectedModelColumnIndices();
        int[] indices = new int[frozenIndices.length + scrollableIndices.length];
        System.arraycopy(frozenIndices, 0, indices, 0, frozenIndices.length);
        System.arraycopy(scrollableIndices, 0, indices, frozenIndices.length, scrollableIndices.length);
        return indices;
    }

    public final int getFrozenColumnCount() {
        return this.myFrozenTable.getColumnCount();
    }

    @NotNull
    public final TableColumn getColumn(int viewColumnIndex) {
        if (viewColumnIndex < this.myFrozenTable.getColumnCount()) {
            TableColumn tableColumn = this.myFrozenTable.getColumnModel().getColumn(viewColumnIndex);
            if (tableColumn == null) {
                FrozenColumnTable.$$$reportNull$$$0(2);
            }
            return tableColumn;
        }
        TableColumn tableColumn = this.myScrollableTable.getColumnModel().getColumn(viewColumnIndex - this.myFrozenTable.getColumnCount());
        if (tableColumn == null) {
            FrozenColumnTable.$$$reportNull$$$0(3);
        }
        return tableColumn;
    }

    final int convertRowIndexToModel(int viewRowIndex) {
        int modelRowIndex = this.myFrozenTable.convertRowIndexToModel(viewRowIndex);
        assert (modelRowIndex == this.myScrollableTable.convertRowIndexToModel(viewRowIndex));
        return modelRowIndex;
    }

    final int convertColumnIndexToModel(int viewColumnIndex) {
        SubTable table2;
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).convertColumnIndexToModel(viewColumnIndex));
    }

    @NotNull
    final TableCellRenderer getDefaultTableHeaderRenderer() {
        TableCellRenderer tableCellRenderer = this.myFrozenTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer == null) {
            FrozenColumnTable.$$$reportNull$$$0(4);
        }
        return tableCellRenderer;
    }

    @NotNull
    final TableCellRenderer getCellRenderer(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            TableCellRenderer tableCellRenderer = this.myFrozenTable.getCellRenderer(viewRowIndex, viewColumnIndex);
            if (tableCellRenderer == null) {
                FrozenColumnTable.$$$reportNull$$$0(5);
            }
            return tableCellRenderer;
        }
        TableCellRenderer tableCellRenderer = this.myScrollableTable.getCellRenderer(viewRowIndex, viewColumnIndex - count);
        if (tableCellRenderer == null) {
            FrozenColumnTable.$$$reportNull$$$0(6);
        }
        return tableCellRenderer;
    }

    final int getPreferredWidth(@NotNull TableCellRenderer renderer, @NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        SubTable table2;
        int count;
        if (renderer == null) {
            FrozenColumnTable.$$$reportNull$$$0(7);
        }
        if (value2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(8);
        }
        if (viewColumnIndex < (count = this.myFrozenTable.getColumnCount())) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return renderer.getTableCellRendererComponent((JTable)((Object)table2), (Object)value2, (boolean)false, (boolean)false, (int)viewRowIndex, (int)viewColumnIndex).getPreferredSize().width + 2;
    }

    @NotNull
    public final JTable getFrozenTable() {
        SubTable subTable = this.myFrozenTable;
        if (subTable == null) {
            FrozenColumnTable.$$$reportNull$$$0(9);
        }
        return subTable;
    }

    @NotNull
    public final JTable getScrollableTable() {
        SubTable subTable = this.myScrollableTable;
        if (subTable == null) {
            FrozenColumnTable.$$$reportNull$$$0(10);
        }
        return subTable;
    }

    @NotNull
    public final Component getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            FrozenColumnTable.$$$reportNull$$$0(11);
        }
        return jScrollPane;
    }

    final int getRowHeight() {
        return this.rowHeight;
    }

    final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    final void putInInputMap(@NotNull KeyStroke keyStroke, @NotNull Object actionMapKey) {
        if (keyStroke == null) {
            FrozenColumnTable.$$$reportNull$$$0(12);
        }
        if (actionMapKey == null) {
            FrozenColumnTable.$$$reportNull$$$0(13);
        }
        this.myFrozenTable.getInputMap().put(keyStroke, actionMapKey);
        this.myScrollableTable.getInputMap().put(keyStroke, actionMapKey);
    }

    public final void putInActionMap(@NotNull Object key, @NotNull Action action2) {
        if (key == null) {
            FrozenColumnTable.$$$reportNull$$$0(14);
        }
        if (action2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(15);
        }
        this.myFrozenTable.getActionMap().put(key, action2);
        this.myScrollableTable.getActionMap().put(key, action2);
    }

    public final void addFrozenColumnTableListener(@NotNull FrozenColumnTableListener listener2) {
        if (listener2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener2);
    }

    @NotNull
    final Iterable<FrozenColumnTableListener> getListeners() {
        Collection<FrozenColumnTableListener> collection = this.myListeners;
        if (collection == null) {
            FrozenColumnTable.$$$reportNull$$$0(17);
        }
        return collection;
    }

    boolean isPastePossible() {
        return false;
    }

    final void paste(@NotNull Transferable transferable) {
        if (transferable == null) {
            FrozenColumnTable.$$$reportNull$$$0(18);
        }
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = this.getSelectedRow();
        int rowCount = this.getRowCount();
        int selectedColumn = this.getSelectedColumn();
        int columnCount = this.getColumnCount();
        for (String values2 : FrozenColumnTable.getTransferDataAsString(transferable).split("\n")) {
            if (row >= rowCount) break;
            int column = selectedColumn;
            for (String value2 : values2.split("\t")) {
                if (column >= columnCount) break;
                this.setValueAt(value2, row, column++);
            }
            ++row;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        String string;
        if (transferable == null) {
            FrozenColumnTable.$$$reportNull$$$0(19);
        }
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(FrozenColumnTable.class).warn((Throwable)exception);
            if ("" == null) {
                FrozenColumnTable.$$$reportNull$$$0(21);
            }
            return "";
        }
        if (string == null) {
            FrozenColumnTable.$$$reportNull$$$0(20);
        }
        return string;
    }

    final void createDefaultColumnsFromModel() {
        this.myFrozenTable.createDefaultColumnsFromModel();
        this.myScrollableTable.createDefaultColumnsFromModel();
    }

    final void setDefaultRenderer(@NotNull Class<?> c, @NotNull TableCellRenderer renderer) {
        if (c == null) {
            FrozenColumnTable.$$$reportNull$$$0(22);
        }
        if (renderer == null) {
            FrozenColumnTable.$$$reportNull$$$0(23);
        }
        this.myFrozenTable.setDefaultRenderer(c, renderer);
        this.myScrollableTable.setDefaultRenderer(c, renderer);
    }

    @Nullable
    public final TableCellEditor getDefaultEditor(@NotNull Class<?> c) {
        if (c == null) {
            FrozenColumnTable.$$$reportNull$$$0(24);
        }
        TableCellEditor editor2 = this.myFrozenTable.getDefaultEditor(c);
        assert (editor2 == this.myScrollableTable.getDefaultEditor(c));
        return editor2;
    }

    final void setDefaultEditor(@NotNull Class<?> c, @NotNull TableCellEditor editor2) {
        if (c == null) {
            FrozenColumnTable.$$$reportNull$$$0(25);
        }
        if (editor2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(26);
        }
        this.myFrozenTable.setDefaultEditor(c, editor2);
        this.myScrollableTable.setDefaultEditor(c, editor2);
    }

    @NotNull
    RowSorter<? extends TableModel> getRowSorter() {
        RowSorter sorter = this.myFrozenTable.getRowSorter();
        assert (sorter == this.myScrollableTable.getRowSorter());
        RowSorter rowSorter = sorter;
        if (rowSorter == null) {
            FrozenColumnTable.$$$reportNull$$$0(27);
        }
        return rowSorter;
    }

    final void setRowSorter(@NotNull RowSorter<? extends TableModel> sorter) {
        if (sorter == null) {
            FrozenColumnTable.$$$reportNull$$$0(28);
        }
        this.myFrozenTable.setRowSorter(sorter);
        this.myScrollableTable.setRowSorter(sorter);
    }

    public final void setRowSelectionInterval(int viewRowIndex1, int viewRowIndex2) {
        this.myFrozenTable.setRowSelectionInterval(viewRowIndex1, viewRowIndex2);
        assert (Arrays.equals(this.myFrozenTable.getSelectedRows(), this.myScrollableTable.getSelectedRows()));
    }

    public final void setColumnSelectionInterval(int viewColumnIndex1, int viewColumnIndex2) {
        assert (viewColumnIndex1 <= viewColumnIndex2);
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex2 < count) {
            this.myFrozenTable.setColumnSelectionInterval(viewColumnIndex1, viewColumnIndex2);
            return;
        }
        if (viewColumnIndex1 >= count) {
            this.myScrollableTable.setColumnSelectionInterval(viewColumnIndex1 - count, viewColumnIndex2 - count);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public final int getSelectedRow() {
        int row = this.myFrozenTable.getSelectedRow();
        assert (row == this.myScrollableTable.getSelectedRow());
        return row;
    }

    public final int getSelectedColumn() {
        int column = this.myFrozenTable.getSelectedColumn();
        if (column != -1) {
            return column;
        }
        column = this.myScrollableTable.getSelectedColumn();
        if (column != -1) {
            return this.myFrozenTable.getColumnCount() + column;
        }
        return -1;
    }

    public final int getSelectedRowCount() {
        int count = this.myFrozenTable.getSelectedRowCount();
        assert (count == this.myScrollableTable.getSelectedRowCount());
        return count;
    }

    public final int getSelectedColumnCount() {
        return this.myFrozenTable.getSelectedColumnCount() + this.myScrollableTable.getSelectedColumnCount();
    }

    public final int getRowCount() {
        int count = this.myFrozenTable.getRowCount();
        assert (count == this.myScrollableTable.getRowCount());
        return count;
    }

    public final int getColumnCount() {
        return this.myFrozenTable.getColumnCount() + this.myScrollableTable.getColumnCount();
    }

    @NotNull
    public final String getColumnName(int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            String string = this.myFrozenTable.getColumnName(viewColumnIndex);
            if (string == null) {
                FrozenColumnTable.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = this.myScrollableTable.getColumnName(viewColumnIndex - count);
        if (string == null) {
            FrozenColumnTable.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public final Object getValueAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            Object object = this.myFrozenTable.getValueAt(viewRowIndex, viewColumnIndex);
            if (object == null) {
                FrozenColumnTable.$$$reportNull$$$0(31);
            }
            return object;
        }
        Object object = this.myScrollableTable.getValueAt(viewRowIndex, viewColumnIndex - count);
        if (object == null) {
            FrozenColumnTable.$$$reportNull$$$0(32);
        }
        return object;
    }

    private void setValueAt(@NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        int count;
        if (value2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(33);
        }
        if (viewColumnIndex < (count = this.myFrozenTable.getColumnCount())) {
            this.myFrozenTable.setValueAt(value2, viewRowIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setValueAt(value2, viewRowIndex, viewColumnIndex - count);
    }

    public final boolean editCellAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.editCellAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.editCellAt(viewRowIndex, viewColumnIndex - count);
    }

    @NotNull
    public TableModel getModel() {
        TableModel tableModel = this.myModel;
        if (tableModel == null) {
            FrozenColumnTable.$$$reportNull$$$0(34);
        }
        return tableModel;
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            FrozenColumnTable.$$$reportNull$$$0(35);
        }
        this.myModel = model;
        this.myFrozenTable.setModel(new SubTableModel(model, () -> 0, () -> this.myFrozenColumnCount));
        this.myScrollableTable.setModel(new SubTableModel(model, () -> this.myFrozenColumnCount, model::getColumnCount));
    }

    @Nullable
    public final TableCellEditor getCellEditor() {
        if (this.myFrozenTable.isEditing()) {
            return this.myFrozenTable.getCellEditor();
        }
        return this.myScrollableTable.getCellEditor();
    }

    @NotNull
    final Font getFont() {
        Font font = this.myFrozenTable.getFont();
        assert (font.equals(this.myScrollableTable.getFont()));
        Font font2 = font;
        if (font2 == null) {
            FrozenColumnTable.$$$reportNull$$$0(36);
        }
        return font2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/FrozenColumnTable";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionMapKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/FrozenColumnTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTableHeaderRenderer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellRenderer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrozenTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollableTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferDataAsString";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowSorter";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredWidth";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putInInputMap";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putInActionMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFrozenColumnTableListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "paste";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTransferDataAsString";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultRenderer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEditor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultEditor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setRowSorter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CellPopupTriggerListener
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private CellPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            if (converter == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(0);
            }
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(1);
            }
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(2);
            }
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(3);
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            SubTable subTable = (SubTable)((Object)event.getSource());
            Point point = event.getPoint();
            FrozenColumnTable source = subTable.getFrozenColumnTable();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = this.myConverter.applyAsInt(subTable.columnAtPoint(point));
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, viewRowIndex, viewColumnIndex, point, (Component)((Object)subTable));
            source.getListeners().forEach(listener2 -> listener2.cellPopupTriggered(frozenColumnTableEvent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/table/FrozenColumnTable$CellPopupTriggerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressedOrReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class HeaderPopupTriggerListener
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private HeaderPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            if (converter == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(0);
            }
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(1);
            }
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(2);
            }
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            Point point;
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(3);
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)event.getSource();
            int subTableIndex = header.columnAtPoint(point = event.getPoint());
            if (subTableIndex == -1) {
                return;
            }
            FrozenColumnTable source = ((SubTable)((Object)header.getTable())).getFrozenColumnTable();
            int frozenColumnTableIndex = this.myConverter.applyAsInt(subTableIndex);
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, -1, frozenColumnTableIndex, point, header);
            source.getListeners().forEach(listener2 -> listener2.headerPopupTriggered(frozenColumnTableEvent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/table/FrozenColumnTable$HeaderPopupTriggerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressedOrReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

