/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsWriteUtils {
    public static void removeLocale(@NotNull Locale locale, final @NotNull AndroidFacet facet, final @NotNull Object requestor) {
        if (locale == null) {
            StringsWriteUtils.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            StringsWriteUtils.$$$reportNull$$$0(1);
        }
        if (requestor == null) {
            StringsWriteUtils.$$$reportNull$$$0(2);
        }
        FolderConfiguration configuration = new FolderConfiguration();
        configuration.setLocaleQualifier(locale.qualifier);
        final Project project = facet.getModule().getProject();
        final String name = configuration.getFolderName(ResourceFolderType.VALUES);
        new WriteCommandAction.Simple(project, "Remove Locale " + locale, new PsiFile[0]){

            protected void run() throws Throwable {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                ResourceFolderManager.getInstance(facet).getFolders().stream().map(directory -> directory.findChild(name)).filter(Objects::nonNull).forEach(directory -> StringsWriteUtils.delete(directory, requestor));
            }
        }.execute();
    }

    private static void delete(@NotNull VirtualFile file, @NotNull Object requestor) {
        if (file == null) {
            StringsWriteUtils.$$$reportNull$$$0(3);
        }
        if (requestor == null) {
            StringsWriteUtils.$$$reportNull$$$0(4);
        }
        try {
            file.delete(requestor);
        }
        catch (IOException exception) {
            Logger.getInstance(StringsWriteUtils.class).warn((Throwable)exception);
        }
    }

    public static boolean setAttributeForItems(final @NotNull Project project, final @NotNull String attribute, final @Nullable String value2, @NotNull List<ResourceItem> items2) {
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(5);
        }
        if (attribute == null) {
            StringsWriteUtils.$$$reportNull$$$0(6);
        }
        if (items2 == null) {
            StringsWriteUtils.$$$reportNull$$$0(7);
        }
        if (items2.isEmpty()) {
            return false;
        }
        final ArrayList tags2 = Lists.newArrayListWithExpectedSize((int)items2.size());
        HashSet files2 = Sets.newHashSetWithExpectedSize((int)items2.size());
        for (ResourceItem item : items2) {
            XmlTag tag = LocalResourceRepository.getItemTag(project, item);
            if (tag == null) {
                return false;
            }
            tags2.add(tag);
            files2.add(tag.getContainingFile());
        }
        final boolean deleteTag = attribute.equals("name") && (value2 == null || value2.isEmpty());
        new WriteCommandAction.Simple(project, "Setting attribute " + attribute, files2.toArray(PsiFile.EMPTY_ARRAY)){

            public void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                for (XmlTag tag : tags2) {
                    if (deleteTag) {
                        tag.delete();
                        continue;
                    }
                    tag.setAttribute(attribute, value2);
                }
            }
        }.execute();
        return true;
    }

    public static boolean setItemText(final @NotNull Project project, @NotNull ResourceItem item, final @NotNull String value2) {
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(8);
        }
        if (item == null) {
            StringsWriteUtils.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            StringsWriteUtils.$$$reportNull$$$0(10);
        }
        if (value2.isEmpty()) {
            return StringsWriteUtils.setAttributeForItems(project, "name", null, Collections.singletonList(item));
        }
        final XmlTag tag = LocalResourceRepository.getItemTag(project, item);
        if (tag != null) {
            new WriteCommandAction.Simple(project, "Setting value of " + item.getName(), new PsiFile[]{tag.getContainingFile()}){

                public void run() {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        child.delete();
                    }
                    XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
                    XmlTag text = factory.createTagFromText((CharSequence)("<string>" + StringsWriteUtils.escapeResourceStringAsXml(value2) + "</string>"));
                    for (XmlTagChild psiElement : text.getValue().getChildren()) {
                        tag.add((PsiElement)psiElement);
                    }
                }
            }.execute();
            return true;
        }
        return false;
    }

    @Nullable
    public static ResourceItem createItem(@NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, @Nullable Locale locale, final @NotNull String name, final @NotNull String value2, final boolean translatable) {
        Project project;
        XmlFile resourceFile;
        if (facet == null) {
            StringsWriteUtils.$$$reportNull$$$0(11);
        }
        if (resFolder == null) {
            StringsWriteUtils.$$$reportNull$$$0(12);
        }
        if (name == null) {
            StringsWriteUtils.$$$reportNull$$$0(13);
        }
        if (value2 == null) {
            StringsWriteUtils.$$$reportNull$$$0(14);
        }
        if ((resourceFile = StringsWriteUtils.getStringResourceFile(project = facet.getModule().getProject(), resFolder, locale)) == null) {
            return null;
        }
        final XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        new WriteCommandAction.Simple(project, "Creating string " + name, new PsiFile[]{resourceFile}){

            public void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), StringsWriteUtils.escapeResourceStringAsXml(value2), false);
                child.setAttribute("name", name);
                child.setAttribute("translatable", translatable ? null : "false");
                root.addSubTag(child, false);
            }
        }.execute();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringsWriteUtils.getStringResourceItem(facet, name, locale);
        }
        return (ResourceItem)ApplicationManager.getApplication().runReadAction(() -> StringsWriteUtils.getStringResourceItem(facet, name, locale));
    }

    @Nullable
    private static ResourceItem getStringResourceItem(@NotNull AndroidFacet facet, @NotNull String key, @Nullable Locale locale) {
        if (facet == null) {
            StringsWriteUtils.$$$reportNull$$$0(15);
        }
        if (key == null) {
            StringsWriteUtils.$$$reportNull$$$0(16);
        }
        LocalResourceRepository repository = ResourceRepositoryManager.getModuleResources(facet);
        repository.sync();
        List items2 = repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, key);
        for (ResourceItem item : items2) {
            Locale l;
            LocaleQualifier qualifier;
            FolderConfiguration config = item.getConfiguration();
            LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
            if (!(qualifier == null ? locale == null : (l = Locale.create(qualifier)).equals(locale))) continue;
            return item;
        }
        return null;
    }

    @Nullable
    static XmlFile getStringResourceFile(@NotNull Project project, final @NotNull VirtualFile resFolder, @Nullable Locale locale) {
        XmlFile resourceFile;
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(17);
        }
        if (resFolder == null) {
            StringsWriteUtils.$$$reportNull$$$0(18);
        }
        FolderConfiguration configuration = new FolderConfiguration();
        if (locale != null) {
            configuration.setLocaleQualifier(locale.qualifier);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        final String valuesFolderName = configuration.getFolderName(ResourceFolderType.VALUES);
        VirtualFile valuesFolder = resFolder.findChild(valuesFolderName);
        if (valuesFolder == null && (valuesFolder = (VirtualFile)new WriteCommandAction<VirtualFile>(project, "Creating directory " + valuesFolderName, new PsiFile[]{manager.findFile(resFolder)}){

            public void run(@NotNull Result<VirtualFile> result2) {
                if (result2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    result2.setResult((Object)resFolder.createChildDirectory((Object)this, valuesFolderName));
                }
                catch (IOException ex) {
                    result2.setResult(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/strings/StringsWriteUtils$5", "run"));
            }
        }.execute().getResultObject()) == null) {
            return null;
        }
        String resourceFileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        if (resourceFileName == null) {
            return null;
        }
        VirtualFile resourceVirtualFile = valuesFolder.findChild(resourceFileName);
        if (resourceVirtualFile == null) {
            PsiDirectory valuesDir = manager.findDirectory(valuesFolder);
            if (valuesDir == null) {
                return null;
            }
            try {
                resourceFile = AndroidResourceUtil.createFileResource(resourceFileName, valuesDir, "", ResourceType.STRING.getName(), true);
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            PsiFile resourcePsiFile = manager.findFile(resourceVirtualFile);
            if (!(resourcePsiFile instanceof XmlFile)) {
                return null;
            }
            resourceFile = (XmlFile)resourcePsiFile;
        }
        return resourceFile;
    }

    @NotNull
    private static String escapeResourceStringAsXml(@NotNull String xml) {
        String string;
        if (xml == null) {
            StringsWriteUtils.$$$reportNull$$$0(19);
        }
        try {
            string = ValueXmlHelper.escapeResourceStringAsXml((String)xml);
        }
        catch (IllegalArgumentException exception) {
            Logger.getInstance(StringsWriteUtils.class).warn((Throwable)exception);
            String string2 = xml;
            if (string2 == null) {
                StringsWriteUtils.$$$reportNull$$$0(21);
            }
            return string2;
        }
        if (string == null) {
            StringsWriteUtils.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resFolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringsWriteUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringsWriteUtils";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeResourceStringAsXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeLocale";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeForItems";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setItemText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStringResourceItem";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStringResourceFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "escapeResourceStringAsXml";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

