/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceRepository {
    private final Map<VirtualFile, LocalResourceRepository> myResourceDirectoryRepositoryMap;
    private final LocalResourceRepository myDynamicResourceRepository;

    private StringResourceRepository(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            StringResourceRepository.$$$reportNull$$$0(0);
        }
        List<LocalResourceRepository> children = parent.getChildren();
        LinkedHashMap resourceDirectoryRepositoryMap = Maps.newLinkedHashMapWithExpectedSize((int)children.size());
        LocalResourceRepository dynamicResourceRepository = null;
        for (LocalResourceRepository child : children) {
            child.sync();
            if (child instanceof ResourceFolderRepository) {
                resourceDirectoryRepositoryMap.put(((ResourceFolderRepository)child).getResourceDir(), child);
                continue;
            }
            assert (dynamicResourceRepository == null);
            dynamicResourceRepository = child;
        }
        this.myResourceDirectoryRepositoryMap = resourceDirectoryRepositoryMap;
        this.myDynamicResourceRepository = dynamicResourceRepository;
    }

    private StringResourceRepository(@NotNull ResourceFolderRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(1);
        }
        repository.sync();
        this.myResourceDirectoryRepositoryMap = Collections.singletonMap(repository.getResourceDir(), repository);
        this.myDynamicResourceRepository = null;
    }

    private StringResourceRepository(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(2);
        }
        repository.sync();
        this.myResourceDirectoryRepositoryMap = Collections.emptyMap();
        this.myDynamicResourceRepository = repository;
    }

    @NotNull
    public static StringResourceRepository empty() {
        StringResourceRepository stringResourceRepository = new StringResourceRepository(new LocalResourceRepository.EmptyRepository(ResourceNamespace.RES_AUTO));
        if (stringResourceRepository == null) {
            StringResourceRepository.$$$reportNull$$$0(3);
        }
        return stringResourceRepository;
    }

    @NotNull
    static StringResourceRepository create(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(4);
        }
        if (repository instanceof MultiResourceRepository) {
            StringResourceRepository stringResourceRepository = new StringResourceRepository((MultiResourceRepository)repository);
            if (stringResourceRepository == null) {
                StringResourceRepository.$$$reportNull$$$0(5);
            }
            return stringResourceRepository;
        }
        if (repository instanceof ResourceFolderRepository) {
            StringResourceRepository stringResourceRepository = new StringResourceRepository((ResourceFolderRepository)repository);
            if (stringResourceRepository == null) {
                StringResourceRepository.$$$reportNull$$$0(6);
            }
            return stringResourceRepository;
        }
        StringResourceRepository stringResourceRepository = new StringResourceRepository(repository);
        if (stringResourceRepository == null) {
            StringResourceRepository.$$$reportNull$$$0(7);
        }
        return stringResourceRepository;
    }

    @NotNull
    public final StringResourceData getData(@NotNull AndroidFacet facet) {
        if (facet == null) {
            StringResourceRepository.$$$reportNull$$$0(8);
        }
        LinkedHashMap<StringResourceKey, StringResource> map2 = new LinkedHashMap<StringResourceKey, StringResource>();
        Project project = facet.getModule().getProject();
        this.myResourceDirectoryRepositoryMap.entrySet().stream().flatMap(StringResourceRepository::getKeys).forEach(key -> map2.put((StringResourceKey)key, new StringResource((StringResourceKey)key, this, project)));
        if (this.myDynamicResourceRepository != null) {
            this.myDynamicResourceRepository.getResources(ResourceNamespace.TODO(), ResourceType.STRING).keySet().stream().map(name -> new StringResourceKey((String)name, null)).forEach(key -> map2.put((StringResourceKey)key, new StringResource((StringResourceKey)key, this, project)));
        }
        StringResourceData stringResourceData = new StringResourceData(facet, map2, this);
        if (stringResourceData == null) {
            StringResourceRepository.$$$reportNull$$$0(9);
        }
        return stringResourceData;
    }

    @NotNull
    private static Stream<StringResourceKey> getKeys(@NotNull Map.Entry<VirtualFile, LocalResourceRepository> entry) {
        if (entry == null) {
            StringResourceRepository.$$$reportNull$$$0(10);
        }
        VirtualFile directory = entry.getKey();
        Stream<StringResourceKey> stream = entry.getValue().getResources(ResourceNamespace.TODO(), ResourceType.STRING).keySet().stream().map(name -> new StringResourceKey((String)name, directory));
        if (stream == null) {
            StringResourceRepository.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public Collection<ResourceItem> getItems(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(12);
        }
        Collection<ResourceItem> collection = StringResourceRepository.getItems(this.getRepository(key), key);
        if (collection == null) {
            StringResourceRepository.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    final ResourceItem getDefaultValue(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(14);
        }
        return this.getItem(key, item -> item.getConfiguration().getLocaleQualifier() == null);
    }

    @Nullable
    final ResourceItem getTranslation(@NotNull StringResourceKey key, @NotNull Locale locale) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(15);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(16);
        }
        return this.getItem(key, item -> StringResourceRepository.localeEquals((Configurable)item, locale));
    }

    private static boolean localeEquals(@NotNull Configurable item, @NotNull Locale locale) {
        LocaleQualifier qualifier;
        if (item == null) {
            StringResourceRepository.$$$reportNull$$$0(17);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(18);
        }
        return (qualifier = item.getConfiguration().getLocaleQualifier()) != null && Locale.create(qualifier).equals(locale);
    }

    @Nullable
    private ResourceItem getItem(@NotNull StringResourceKey key, @NotNull Predicate<ResourceItem> predicate) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(19);
        }
        if (predicate == null) {
            StringResourceRepository.$$$reportNull$$$0(20);
        }
        LocalResourceRepository repository = this.getRepository(key);
        Optional<ResourceItem> optionalItem = StringResourceRepository.getItems(repository, key).stream().filter(predicate).findFirst();
        return optionalItem.orElse(null);
    }

    @NotNull
    private LocalResourceRepository getRepository(@NotNull StringResourceKey key) {
        VirtualFile directory;
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(21);
        }
        LocalResourceRepository localResourceRepository = (directory = key.getDirectory()) == null ? this.myDynamicResourceRepository : this.myResourceDirectoryRepositoryMap.get(directory);
        if (localResourceRepository == null) {
            StringResourceRepository.$$$reportNull$$$0(22);
        }
        return localResourceRepository;
    }

    @NotNull
    private static Collection<ResourceItem> getItems(@NotNull LocalResourceRepository repository, @NotNull StringResourceKey key) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(23);
        }
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(24);
        }
        repository.sync();
        List list = repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, key.getName());
        if (list == null) {
            StringResourceRepository.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 13: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 12: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTranslation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "localeEquals";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

