/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class StringResourceEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ID = "string-resource-editor";

    public static boolean canViewTranslations(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(1);
        }
        String name = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        assert (name != null);
        if (!file.getName().endsWith(name)) {
            return false;
        }
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES) {
            return false;
        }
        Module m = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file);
        return m != null && AndroidFacet.getInstance(m) != null;
    }

    public static void openEditor(@NotNull Module module) {
        StringsVirtualFile vf;
        if (module == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(2);
        }
        if ((vf = StringsVirtualFile.getStringsVirtualFile(module)) != null) {
            ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$0(module, (VirtualFile)vf));
        }
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(4);
        }
        StringsVirtualFile stringsFile = StringsVirtualFile.getInstance(project, file);
        assert (stringsFile != null);
        ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$1(project, (VirtualFile)stringsFile));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(6);
        }
        return file instanceof StringsVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(8);
        }
        StringResourceEditor stringResourceEditor = new StringResourceEditor((StringsVirtualFile)file);
        if (stringResourceEditor == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(9);
        }
        return stringResourceEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (ID == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(10);
        }
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            StringResourceEditorProvider.$$$reportNull$$$0(11);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void lambda$openEditor$1(Project project, VirtualFile stringsFile) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, stringsFile);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void lambda$openEditor$0(Module module, VirtualFile vf) {
        Project project = module.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vf);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceEditorProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canViewTranslations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

