/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.facet.Facet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private static final int MAX_LOCALE_LABEL_COUNT = 3;
    private final Facet myFacet;
    private final Map<StringResourceKey, StringResource> myKeyToResourceMap;
    private final StringResourceRepository myRepository;

    StringResourceData(@NotNull Facet facet, @NotNull Map<StringResourceKey, StringResource> keyToResourceMap, @NotNull StringResourceRepository repository) {
        if (facet == null) {
            StringResourceData.$$$reportNull$$$0(0);
        }
        if (keyToResourceMap == null) {
            StringResourceData.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            StringResourceData.$$$reportNull$$$0(2);
        }
        this.myFacet = facet;
        this.myKeyToResourceMap = keyToResourceMap;
        this.myRepository = repository;
    }

    public void setKeyName(@NotNull StringResourceKey key, @NotNull String name) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(3);
        }
        if (name == null) {
            StringResourceData.$$$reportNull$$$0(4);
        }
        if (key.getName().equals(name)) {
            return;
        }
        boolean mapContainsName = this.myKeyToResourceMap.keySet().stream().map(k -> k.getName()).anyMatch(n -> n.equals(name));
        if (mapContainsName) {
            return;
        }
        ResourceItem value2 = this.getStringResource(key).getDefaultValueAsResourceItem();
        if (value2 == null) {
            return;
        }
        Project project = this.myFacet.getModule().getProject();
        XmlTag stringElement = LocalResourceRepository.getItemTag(project, value2);
        assert (stringElement != null);
        XmlAttribute nameAttribute = stringElement.getAttribute("name");
        assert (nameAttribute != null);
        XmlAttributeValue nameAttributeValue = nameAttribute.getValueElement();
        assert (nameAttributeValue != null);
        new RenameProcessor(project, (PsiElement)nameAttributeValue, name, false, false).run();
        this.myKeyToResourceMap.remove(key);
        key = new StringResourceKey(name, key.getDirectory());
        this.myKeyToResourceMap.put(key, new StringResource(key, this.myRepository, project));
    }

    public boolean setTranslatable(@NotNull StringResourceKey key, boolean translatable) {
        StringResource stringResource;
        ResourceItem item;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(5);
        }
        if ((item = (stringResource = this.getStringResource(key)).getDefaultValueAsResourceItem()) != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatableAsString, Collections.singletonList(item));
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(6);
        }
        if (!this.myKeyToResourceMap.keySet().contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @NotNull
    Collection<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(7);
        }
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.getLocaleSet()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        HashSet hashSet = missingTranslations;
        if (hashSet == null) {
            StringResourceData.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            StringResourceData.$$$reportNull$$$0(9);
        }
        if (locales.isEmpty()) {
            if ("" == null) {
                StringResourceData.$$$reportNull$$$0(10);
            }
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            String string = StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(11);
            }
            return string;
        }
        List<Locale> sorted = StringResourceData.getLowest(locales);
        if (size <= 3) {
            String string = StringResourceData.getLabels(sorted.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted.get(size - 1));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = StringResourceData.getLabels(sorted) + " and " + (size - 3) + " more";
        if (string == null) {
            StringResourceData.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static List<Locale> getLowest(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            StringResourceData.$$$reportNull$$$0(14);
        }
        List<Locale> list = locales.stream().limit(3L).sorted(Comparator.comparing(StringResourceData::getLabel)).collect(Collectors.toList());
        if (list == null) {
            StringResourceData.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }

    boolean containsKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(16);
        }
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull StringResourceKey key) {
        StringResource resource;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(17);
        }
        if ((resource = this.myKeyToResourceMap.get(key)) == null) {
            throw new IllegalArgumentException(key.toString());
        }
        StringResource stringResource = resource;
        if (stringResource == null) {
            StringResourceData.$$$reportNull$$$0(18);
        }
        return stringResource;
    }

    @NotNull
    public Collection<StringResource> getResources() {
        Collection<StringResource> collection = this.myKeyToResourceMap.values();
        if (collection == null) {
            StringResourceData.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        ArrayList<StringResourceKey> arrayList = new ArrayList<StringResourceKey>(this.myKeyToResourceMap.keySet());
        if (arrayList == null) {
            StringResourceData.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public List<Locale> getLocaleList() {
        List<Locale> list = this.getTranslatedLocaleStream().distinct().sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
        if (list == null) {
            StringResourceData.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    Set<Locale> getLocaleSet() {
        Set<Locale> set = this.getTranslatedLocaleStream().collect(Collectors.toSet());
        if (set == null) {
            StringResourceData.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    private Stream<Locale> getTranslatedLocaleStream() {
        Stream<Locale> stream = this.myKeyToResourceMap.values().stream().flatMap(resource -> resource.getTranslatedLocales().stream());
        if (stream == null) {
            StringResourceData.$$$reportNull$$$0(23);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyToResourceMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingTranslations";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "summarizeLocales";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowest";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringResource";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleSet";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslatedLocaleStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setKeyName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTranslatable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMissingTranslations";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "summarizeLocales";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLowest";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStringResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

