/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.ValueXmlHelper;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringPsiUtils {
    private StringPsiUtils() {
    }

    @Nullable
    static XmlFile getDefaultStringResourceFile(@NotNull Project project, @NotNull StringResourceKey key) {
        VirtualFile directory;
        if (project == null) {
            StringPsiUtils.$$$reportNull$$$0(0);
        }
        if (key == null) {
            StringPsiUtils.$$$reportNull$$$0(1);
        }
        return (directory = key.getDirectory()) == null ? null : StringsWriteUtils.getStringResourceFile(project, directory, null);
    }

    @Nullable
    static XmlFile getStringResourceFile(@NotNull Project project, @NotNull StringResourceKey key, @NotNull Locale locale) {
        VirtualFile directory;
        if (project == null) {
            StringPsiUtils.$$$reportNull$$$0(2);
        }
        if (key == null) {
            StringPsiUtils.$$$reportNull$$$0(3);
        }
        if (locale == null) {
            StringPsiUtils.$$$reportNull$$$0(4);
        }
        return (directory = key.getDirectory()) == null ? null : StringsWriteUtils.getStringResourceFile(project, directory, locale);
    }

    static void addString(@NotNull XmlFile file, @NotNull StringResourceKey key, @NotNull String value2) {
        if (file == null) {
            StringPsiUtils.$$$reportNull$$$0(5);
        }
        if (key == null) {
            StringPsiUtils.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            StringPsiUtils.$$$reportNull$$$0(7);
        }
        StringPsiUtils.addString(file, key, true, value2);
    }

    static void addString(@NotNull XmlFile file, @NotNull StringResourceKey key, boolean translatable, @NotNull String value2) {
        XmlTag resources;
        if (file == null) {
            StringPsiUtils.$$$reportNull$$$0(8);
        }
        if (key == null) {
            StringPsiUtils.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            StringPsiUtils.$$$reportNull$$$0(10);
        }
        if ((resources = file.getRootTag()) == null) {
            return;
        }
        XmlTag string = resources.createChildTag("string", resources.getNamespace(), StringPsiUtils.escape(value2), false);
        string.setAttribute("name", key.getName());
        if (!translatable) {
            string.setAttribute("translatable", Boolean.FALSE.toString());
        }
        resources.addSubTag(string, false);
    }

    @NotNull
    private static String escape(@NotNull String value2) {
        String string;
        if (value2 == null) {
            StringPsiUtils.$$$reportNull$$$0(11);
        }
        try {
            string = ValueXmlHelper.escapeResourceStringAsXml((String)value2);
        }
        catch (IllegalArgumentException exception) {
            String string2 = value2;
            if (string2 == null) {
                StringPsiUtils.$$$reportNull$$$0(13);
            }
            return string2;
        }
        if (string == null) {
            StringPsiUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringPsiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringPsiUtils";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStringResourceFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringResourceFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

