/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class ResourceLoadingTask
extends Task.Backgroundable {
    private final StringResourceViewPanel myPanel;
    private final Supplier<LocalResourceRepository> myRepositorySupplier;
    private LocalResourceRepository myRepository;

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2) {
        if (panel2 == null) {
            ResourceLoadingTask.$$$reportNull$$$0(0);
        }
        this(panel2, () -> ResourceRepositoryManager.getModuleResources(panel2.getFacet()));
    }

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2, @NotNull Supplier<LocalResourceRepository> repositorySupplier) {
        if (panel2 == null) {
            ResourceLoadingTask.$$$reportNull$$$0(1);
        }
        if (repositorySupplier == null) {
            ResourceLoadingTask.$$$reportNull$$$0(2);
        }
        super(panel2.getFacet().getModule().getProject(), "Loading String Resources...");
        this.myPanel = panel2;
        this.myRepositorySupplier = repositorySupplier;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ResourceLoadingTask.$$$reportNull$$$0(3);
        }
        indicator.setIndeterminate(true);
        this.myRepository = this.myRepositorySupplier.get();
    }

    public void onSuccess() {
        this.myPanel.getTable().setModel(new StringResourceTableModel(StringResourceRepository.create(this.myRepository), this.myPanel.getFacet()));
        this.myPanel.getLoadingPanel().stopLoading();
    }

    public void onCancel() {
        this.myPanel.getLoadingPanel().stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositorySupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/ResourceLoadingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

