/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.NewStringKeyDialog;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

final class AddKeyAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    AddKeyAction(@NotNull StringResourceViewPanel panel2) {
        if (panel2 == null) {
            AddKeyAction.$$$reportNull$$$0(0);
        }
        super("Add Key", null, AllIcons.General.Add);
        this.myPanel = panel2;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            AddKeyAction.$$$reportNull$$$0(1);
        }
        event.getPresentation().setEnabled(this.myPanel.getTable().getData() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        StringResourceKey key;
        if (event == null) {
            AddKeyAction.$$$reportNull$$$0(2);
        }
        AndroidFacet facet = this.myPanel.getFacet();
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        NewStringKeyDialog dialog = new NewStringKeyDialog(facet, (Collection<StringResourceKey>)new HashSet(data.getKeys()));
        if (!dialog.showAndGet()) {
            return;
        }
        Project project = facet.getModule().getProject();
        XmlFile file = StringPsiUtils.getDefaultStringResourceFile(project, key = dialog.getKey());
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            StringPsiUtils.addString(file, key, dialog.getDefaultValue());
            this.myPanel.reloadData();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/AddKeyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

