/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.downloads;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DownloadService {
    private static final long REFRESH_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final long RETRY_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private final FileDownloader myDownloader;
    private final String myServiceName;
    private final File myCachePath;
    private final URL myFallbackUrl;
    private final String myFilename;
    private final String myFilePattern;
    private final Object myLock;
    private final List<Runnable> mySuccesses;
    private final List<Runnable> myFailures;
    private volatile boolean myRunning;
    private long myAttemptTime;
    private long myRefreshTime;

    public DownloadService(@NotNull String serviceName, @NotNull String downloadUrl, @NotNull URL fallbackResourceUrl, @NotNull File targetCachePath, @NotNull String tempFilename, @NotNull String filename) {
        if (serviceName == null) {
            DownloadService.$$$reportNull$$$0(0);
        }
        if (downloadUrl == null) {
            DownloadService.$$$reportNull$$$0(1);
        }
        if (fallbackResourceUrl == null) {
            DownloadService.$$$reportNull$$$0(2);
        }
        if (targetCachePath == null) {
            DownloadService.$$$reportNull$$$0(3);
        }
        if (tempFilename == null) {
            DownloadService.$$$reportNull$$$0(4);
        }
        if (filename == null) {
            DownloadService.$$$reportNull$$$0(5);
        }
        this(DownloadableFileService.getInstance().createDownloader((List)ImmutableList.of((Object)DownloadableFileService.getInstance().createFileDescription(downloadUrl, tempFilename)), serviceName), serviceName, fallbackResourceUrl, targetCachePath, filename);
    }

    public DownloadService(@NotNull FileDownloader downloader, @NotNull String serviceName, @NotNull URL fallbackResourceUrl, @NotNull File targetCachePath, @NotNull String filename) {
        if (downloader == null) {
            DownloadService.$$$reportNull$$$0(6);
        }
        if (serviceName == null) {
            DownloadService.$$$reportNull$$$0(7);
        }
        if (fallbackResourceUrl == null) {
            DownloadService.$$$reportNull$$$0(8);
        }
        if (targetCachePath == null) {
            DownloadService.$$$reportNull$$$0(9);
        }
        if (filename == null) {
            DownloadService.$$$reportNull$$$0(10);
        }
        this.mySuccesses = Lists.newLinkedList();
        this.myFailures = Lists.newArrayList();
        this.myRunning = false;
        this.myDownloader = downloader;
        this.myServiceName = serviceName;
        this.myCachePath = targetCachePath;
        this.myFallbackUrl = fallbackResourceUrl;
        this.myFilename = filename;
        this.myFilePattern = FileUtil.getNameWithoutExtension((String)filename) + "(_[0-9]+)?\\." + FileUtilRt.getExtension((String)filename);
        this.myLock = new Object();
    }

    public abstract void loadFromFile(@NotNull URL var1);

    public void refreshSynchronously() {
        Semaphore completed = new Semaphore();
        completed.down();
        Runnable complete = () -> ((Semaphore)completed).up();
        this.refresh(complete, complete);
        completed.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable success, @Nullable Runnable failure) {
        final long time2 = System.currentTimeMillis();
        Object object = this.myLock;
        synchronized (object) {
            if (success != null) {
                this.mySuccesses.add(success);
            }
            if (failure != null) {
                this.myFailures.add(failure);
            }
            if (this.myRunning && time2 < this.myAttemptTime + RETRY_INTERVAL) {
                return;
            }
            if (time2 < this.myRefreshTime + REFRESH_INTERVAL) {
                DownloadService.runContinuations(this.mySuccesses);
                this.clearCallbacks();
                return;
            }
            if (time2 < this.myAttemptTime + RETRY_INTERVAL) {
                DownloadService.runContinuations(this.myFailures);
                this.clearCallbacks();
                return;
            }
            this.myAttemptTime = time2;
            this.myRunning = true;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Downloading " + this.myServiceName, false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                DownloadService.this.loadSynchronously(time2);
            }

            public boolean isHeadless() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/downloads/DownloadService$1", "run"));
            }
        });
    }

    private File loadData(@Nullable File downloaded) {
        if (downloaded == null) {
            downloaded = this.findLatestDownload();
        }
        if (downloaded != null) {
            try {
                this.loadFromFile(downloaded.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this.loadFromFile(this.myFallbackUrl);
        }
        return downloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSynchronously(long time2) {
        File downloaded = null;
        try {
            try {
                List result2 = this.myDownloader.download(this.myCachePath);
                if (!result2.isEmpty()) {
                    downloaded = this.fixupFile((File)((Pair)result2.get(0)).getFirst());
                }
            }
            catch (Exception result2) {
                // empty catch block
            }
            downloaded = this.loadData(downloaded);
        }
        finally {
            ArrayList<Runnable> continuations;
            Object object = this.myLock;
            synchronized (object) {
                if (downloaded == null) {
                    continuations = new ArrayList<Runnable>(this.myFailures);
                } else {
                    continuations = new ArrayList<Runnable>(this.mySuccesses);
                    this.myRefreshTime = time2;
                }
                this.clearCallbacks();
                this.myRunning = false;
            }
            DownloadService.runContinuations(continuations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCallbacks() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySuccesses.clear();
            this.myFailures.clear();
        }
    }

    private File findLatestDownload() {
        long latestModTime = 0L;
        File latestFile = null;
        File[] files2 = this.myCachePath.listFiles();
        if (files2 != null) {
            for (File f : files2) {
                if (!f.getName().matches(this.myFilePattern) || f.lastModified() <= latestModTime) continue;
                latestFile = f;
                latestModTime = f.lastModified();
            }
        }
        return latestFile;
    }

    private File fixupFile(File downloaded) {
        File target = new File(this.myCachePath, this.myFilename).getAbsoluteFile();
        if (!FileUtil.filesEqual((File)downloaded.getAbsoluteFile(), (File)target)) {
            try {
                if ((!target.exists() || target.delete()) && downloaded.renameTo(target)) {
                    downloaded = target;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return downloaded;
    }

    private static void runContinuations(List<Runnable> continuations) {
        for (Runnable runnable : continuations) {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "downloadUrl";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "fallbackResourceUrl";
                break;
            }
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "targetCachePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "tempFilename";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[0] = "filename";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "downloader";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/downloads/DownloadService";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

