/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReport;
import com.android.tools.idea.diagnostics.DiagnosticReportBuilder;
import com.android.tools.idea.diagnostics.LastActionTracker;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiagnosticReportIdePerformanceListener
implements IdePerformanceListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.diagnostics.DiagnosticReportIdePerformanceListener");
    private final Consumer<DiagnosticReport> myReportCallback;
    @Nullable
    private DiagnosticReportBuilder myBuilder;
    @Nullable
    private ReportContext myContext;
    private int myReportsCollected;
    @Nullable
    private MessageBusConnection myMessageBusConnection;
    private LastActionTracker myLastActionTracker;

    public DiagnosticReportIdePerformanceListener(Consumer<DiagnosticReport> reportCallback) {
        this.myReportCallback = reportCallback;
        this.myLastActionTracker = new LastActionTracker();
    }

    public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
        ReportContext currentContext;
        if (toFile == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(0);
        }
        if (dump == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(1);
        }
        if ((currentContext = this.myContext) != null && currentContext.myThreadDumpPath == null) {
            currentContext.myThreadDumpPath = toFile.toPath().getParent();
        }
    }

    public void uiFreezeStarted() {
        ReportContext context;
        LOG.info("uiFreezeStarted");
        if (this.myBuilder != null) {
            return;
        }
        this.myContext = context = new ReportContext();
        int freezeTimeBeforeCreatedMs = Registry.intValue((String)"performance.watcher.unresponsive.interval.ms");
        this.myBuilder = new DiagnosticReportBuilder(DiagnosticReportBuilder.INTERVAL_MS, DiagnosticReportBuilder.MAX_DURATION_MS, DiagnosticReportBuilder.FRAME_IGNORE_THRESHOLD_MS, freezeTimeBeforeCreatedMs, this.myLastActionTracker, new Controller(context));
    }

    private void reportReady(DiagnosticReport report) {
        this.myReportCallback.accept(report);
    }

    public void uiFreezeFinished(int lengthInSeconds) {
        Path localReportPath;
        LOG.info(String.format("uiFreezeFinished: duration = %d seconds", lengthInSeconds));
        DiagnosticReportBuilder localBuilder = this.myBuilder;
        if (localBuilder == null) {
            return;
        }
        ++this.myReportsCollected;
        if (DiagnosticReportBuilder.MAX_REPORTS != -1 && this.myReportsCollected >= DiagnosticReportBuilder.MAX_REPORTS) {
            LOG.info("Stopped collecting UI freeze reports after " + this.myReportsCollected + " reports.");
            this.unregister();
        }
        if (this.myContext != null && (localReportPath = DiagnosticReportIdePerformanceListener.getPathForReportName("profileDiagnostics", this.myContext)) != null && Files.exists(localReportPath, new LinkOption[0])) {
            try {
                Files.write(localReportPath, ("UI freeze lasted " + lengthInSeconds + " seconds.\n").getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                LOG.warn("Exception while appending to a report.", (Throwable)e);
            }
        }
        this.myBuilder = null;
        this.myContext = null;
        localBuilder.stop();
    }

    private static Path tryFixReportPath(@NotNull Path path) {
        Path reportDirectory;
        if (path == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(2);
        }
        if (Files.isDirectory(reportDirectory = path.getParent(), new LinkOption[0])) {
            return path;
        }
        String directoryGlob = reportDirectory.getFileName().toString() + "-*";
        try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(reportDirectory.getParent(), directoryGlob);){
            Iterator<Path> iterator = paths2.iterator();
            if (iterator.hasNext()) {
                reportDirectory = iterator.next();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (reportDirectory == null) {
            return path;
        }
        return reportDirectory.resolve(path.getFileName());
    }

    @Nullable
    private static Path getPathForReportName(@NotNull String reportName, @NotNull ReportContext context) {
        Path threadDumpPath;
        if (reportName == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(4);
        }
        if ((threadDumpPath = context.myThreadDumpPath) == null) {
            return null;
        }
        Path reportPath = threadDumpPath.resolve("diagnosticReport-" + reportName + ".txt");
        return DiagnosticReportIdePerformanceListener.tryFixReportPath(reportPath);
    }

    @Nullable
    private static Path saveReportFile(@NotNull String reportName, @NotNull String reportContents, ReportContext context) {
        Path reportPath;
        if (reportName == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(5);
        }
        if (reportContents == null) {
            DiagnosticReportIdePerformanceListener.$$$reportNull$$$0(6);
        }
        if ((reportPath = DiagnosticReportIdePerformanceListener.getPathForReportName(reportName, context)) == null) {
            return null;
        }
        if (Files.exists(reportPath, new LinkOption[0])) {
            return reportPath;
        }
        try (PrintWriter out = new PrintWriter(reportPath.toFile(), "UTF-8");){
            out.write(reportContents);
            LOG.info(String.format("Freeze report saved: %s", reportPath));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return reportPath;
    }

    public void registerOn(Application application) {
        assert (this.myMessageBusConnection == null);
        this.myMessageBusConnection = application.getMessageBus().connect((Disposable)application);
        this.myMessageBusConnection.subscribe(IdePerformanceListener.TOPIC, (Object)this);
    }

    public void unregister() {
        assert (this.myMessageBusConnection != null);
        this.myMessageBusConnection.disconnect();
        this.myMessageBusConnection = null;
        this.myLastActionTracker.dispose();
        this.myLastActionTracker = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportContents";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/diagnostics/DiagnosticReportIdePerformanceListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpedThreads";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryFixReportPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathForReportName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "saveReportFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class Controller {
        private final ReportContext myContext;

        public Controller(ReportContext context) {
            this.myContext = context;
        }

        public Path saveReportFile(String reportName, String reportContents) {
            return DiagnosticReportIdePerformanceListener.saveReportFile(reportName, reportContents, this.myContext);
        }

        public void reportReady(DiagnosticReport report) {
            DiagnosticReportIdePerformanceListener.this.reportReady(report);
        }
    }

    private static class ReportContext {
        private Path myThreadDumpPath;

        private ReportContext() {
        }
    }
}

