/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        String allCaps;
        if (manufacturer == null) {
            DevicePropertyUtil.$$$reportNull$$$0(0);
        }
        return ourManufacturerNameIsAcronym.contains(allCaps = manufacturer.toUpperCase(Locale.US)) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @NotNull
    public static String getManufacturer(@NotNull IDevice d, @NotNull String unknown) {
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(1);
        }
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(2);
        }
        String string = DevicePropertyUtil.getManufacturer(d.getProperty("ro.product.manufacturer"), d.isEmulator(), unknown);
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getManufacturer(@Nullable String manufacturer, boolean isEmulator, @NotNull String unknown) {
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(4);
        }
        if (isEmulator && "unknown".equals(manufacturer)) {
            manufacturer = unknown;
        }
        String string = manufacturer != null ? DevicePropertyUtil.fixManufacturerName(manufacturer) : unknown;
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getModel(@NotNull IDevice d, @NotNull String unknown) {
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(6);
        }
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(7);
        }
        String string = DevicePropertyUtil.getModel(d.getProperty("ro.product.model"), unknown);
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getModel(@Nullable String model, @NotNull String unknown) {
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(9);
        }
        String string = model != null ? StringUtil.capitalizeWords((String)model, (boolean)true) : unknown;
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getBuild(@NotNull IDevice d) {
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(11);
        }
        String string = DevicePropertyUtil.getBuild(d.getProperty("ro.build.version.release"), d.getProperty("ro.build.version.codename"), d.getProperty("ro.build.version.sdk"));
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getBuild(@Nullable String buildVersion, @Nullable String codeName, @Nullable String apiLevel) {
        String apiString;
        StringBuilder sb = new StringBuilder(20);
        if (buildVersion != null) {
            sb.append("Android ");
            sb.append(buildVersion);
        }
        String string = apiString = codeName == null || codeName.equals("REL") ? apiLevel : codeName;
        if (apiString != null) {
            sb.append(String.format(", API %1$s", apiString));
        }
        String string2 = sb.toString();
        if (string2 == null) {
            DevicePropertyUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manufacturer";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknown";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/DevicePropertyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/DevicePropertyUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getManufacturer";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixManufacturerName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getManufacturer";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

