/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingClass
extends AndroidLightClassBase {
    private static final int STATIC_METHOD_COUNT = 6;
    private DataBindingInfo myInfo;
    private CachedValue<PsiMethod[]> myPsiMethodsCache;
    private CachedValue<PsiField[]> myPsiFieldsCache;
    private PsiReferenceList myExtendsList;
    private PsiClassType[] myExtendsListTypes;
    private final AndroidFacet myFacet;
    private PsiFile myVirtualPsiFile;
    private final DataBindingMode myMode;
    private final Object myLock;

    protected LightBindingClass(AndroidFacet facet, @NotNull PsiManager psiManager, DataBindingInfo info) {
        if (psiManager == null) {
            LightBindingClass.$$$reportNull$$$0(0);
        }
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myLock = new Object();
        this.myInfo = info;
        this.myFacet = facet;
        this.myVirtualPsiFile = info.getPsiFile();
        this.myMode = ModuleDataBinding.getInstance(facet).getDataBindingMode();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)info.getProject());
        this.myPsiMethodsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiMethod[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            PsiMethod[] doCompute() {
                Map<String, PsiDataBindingResourceItem> variables = LightBindingClass.this.myInfo.getItems(DataBindingResourceType.VARIABLE);
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(variables.size() * 2 + 6);
                DataBindingInfo mergedInfo = LightBindingClass.this.myInfo.getMergedInfo();
                if (mergedInfo == null) {
                    for (PsiDataBindingResourceItem variable : variables.values()) {
                        LightBindingClass.this.createVariableMethods(variable, methods, true);
                    }
                    PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                    LightBindingClass.this.createStaticMethods(factory.createType((PsiClass)LightBindingClass.this), methods);
                } else {
                    for (PsiDataBindingResourceItem variable : mergedInfo.getItems(DataBindingResourceType.VARIABLE).values()) {
                        LightBindingClass.this.createVariableMethods(variable, methods, false);
                    }
                }
                PsiMethod constructor = LightBindingClass.this.createConstructor();
                methods.add(constructor);
                return methods.toArray(PsiMethod.EMPTY_ARRAY);
            }

            @Override
            PsiMethod[] defaultValue() {
                return PsiMethod.EMPTY_ARRAY;
            }
        }, false);
        this.myPsiFieldsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            PsiField[] doCompute() {
                if (LightBindingClass.this.myInfo.getMergedInfo() != null) {
                    return PsiField.EMPTY_ARRAY;
                }
                List<DataBindingInfo.ViewWithId> viewsWithIds = LightBindingClass.this.myInfo.getViewsWithIds();
                PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                PsiField[] result2 = new PsiField[viewsWithIds.size()];
                int i2 = 0;
                int unresolved = 0;
                for (DataBindingInfo.ViewWithId viewWithId : viewsWithIds) {
                    PsiField psiField = LightBindingClass.this.createPsiField(viewWithId);
                    if (psiField == null) {
                        ++unresolved;
                        continue;
                    }
                    result2[i2++] = psiField;
                }
                if (unresolved > 0) {
                    PsiField[] validResult = new PsiField[i2];
                    System.arraycopy(result2, 0, validResult, 0, i2);
                    return validResult;
                }
                return result2;
            }

            @Override
            PsiField[] defaultValue() {
                return PsiField.EMPTY_ARRAY;
            }
        }, false);
        this.setModuleInfo(facet.getModule(), false);
    }

    @NotNull
    private PsiMethod createConstructor() {
        LightMethodBuilder constructor = new LightMethodBuilder((PsiClass)this, (Language)JavaLanguage.INSTANCE);
        constructor.setConstructor(true);
        constructor.addModifier("private");
        LightMethodBuilder lightMethodBuilder = constructor;
        if (lightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(1);
        }
        return lightMethodBuilder;
    }

    @Nullable
    public String getQualifiedName() {
        return this.myInfo.getQualifiedName();
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])this.myPsiFieldsCache.getValue();
        if (psiFieldArray == null) {
            LightBindingClass.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = this.getFields();
        if (psiFieldArray == null) {
            LightBindingClass.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])this.myPsiMethodsCache.getValue();
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass getSuperClass() {
        DataBindingInfo mergedInfo = this.myInfo.getMergedInfo();
        String superClassName = mergedInfo == null ? this.myMode.viewDataBinding : mergedInfo.getQualifiedName();
        return JavaPsiFacade.getInstance((Project)this.myInfo.getProject()).findClass(superClassName, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
    }

    @Override
    public PsiReferenceList getExtendsList() {
        if (this.myExtendsList == null) {
            PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)this.myInfo.getProject());
            PsiJavaCodeReferenceElement referenceElementByType = factory.createReferenceElementByType(this.getExtendsListTypes()[0]);
            this.myExtendsList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
        }
        return this.myExtendsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = this.getExtendsListTypes();
        if (psiClassTypeArray == null) {
            LightBindingClass.$$$reportNull$$$0(5);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (this.myExtendsListTypes == null) {
            DataBindingInfo mergedInfo = this.myInfo.getMergedInfo();
            String superClassName = mergedInfo == null ? this.myMode.viewDataBinding : mergedInfo.getQualifiedName();
            this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)superClassName, (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false))};
        }
        if (this.myExtendsListTypes == null) {
            LightBindingClass.$$$reportNull$$$0(6);
        }
        return this.myExtendsListTypes;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = this.getMethods();
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        ArrayList<PsiMethod> matched = null;
        for (PsiMethod method : this.getMethods()) {
            if (!name.equals(method.getName())) continue;
            if (matched == null) {
                matched = new ArrayList<PsiMethod>();
            }
            matched.add(method);
        }
        PsiMethod[] psiMethodArray = matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(8);
        }
        return psiMethodArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean continueProcessing;
        if (processor == null) {
            LightBindingClass.$$$reportNull$$$0(9);
        }
        if (state == null) {
            LightBindingClass.$$$reportNull$$$0(10);
        }
        if (place == null) {
            LightBindingClass.$$$reportNull$$$0(11);
        }
        if (!(continueProcessing = super.processDeclarations(processor, state, lastParent, place))) {
            return false;
        }
        Map<String, PsiDataBindingResourceItem> imports = this.myInfo.getItems(DataBindingResourceType.IMPORT);
        if (imports.isEmpty()) {
            return true;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            for (PsiDataBindingResourceItem imp : imports.values()) {
                String qName;
                String alias = imp.getExtra("alias");
                if (alias != null || (qName = imp.getExtra("type")) == null || name != null && !qName.endsWith("." + name)) continue;
                Module module = this.myInfo.getModule();
                if (module == null) {
                    return true;
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qName, module.getModuleWithDependenciesAndLibrariesScope(true));
                if (aClass == null || processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private void createVariableMethods(@NotNull PsiDataBindingResourceItem item, @NotNull List<PsiMethod> outPsiMethods, boolean addGetter) {
        if (item == null) {
            LightBindingClass.$$$reportNull$$$0(12);
        }
        if (outPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = this.getManager();
        String typeName = item.getExtra("type");
        String variableType = DataBindingUtil.getQualifiedType(typeName, this.myInfo, true);
        if (variableType == null) {
            return;
        }
        PsiType type = DataBindingUtil.parsePsiType(variableType, this.myFacet, (PsiElement)this);
        if (type == null) {
            return;
        }
        String capitalizedName = StringUtil.capitalize((String)item.getName());
        LightMethodBuilder setter = this.createPublicMethod("set" + capitalizedName, (PsiType)PsiType.VOID);
        setter.addParameter(item.getName(), type);
        if (this.myInfo.isMerged()) {
            setter.addModifier("abstract");
        }
        outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, (PsiMethod)setter, this, (Language)JavaLanguage.INSTANCE));
        if (addGetter) {
            LightMethodBuilder getter = this.createPublicMethod("get" + capitalizedName, type);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, (PsiMethod)getter, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    private void createStaticMethods(@NotNull PsiClassType ownerType, @NotNull List<PsiMethod> outPsiMethods) {
        PsiMethod[] methods;
        if (ownerType == null) {
            LightBindingClass.$$$reportNull$$$0(14);
        }
        if (outPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(15);
        }
        Project project = this.myInfo.getProject();
        Module module = this.myFacet.getModule();
        PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType layoutInflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType dataBindingComponent = PsiType.getTypeByName((String)this.myMode.dataBindingComponent, (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        LightMethodBuilder inflate4Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate4Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate4Arg.addParameter("root", (PsiType)viewGroupType);
        inflate4Arg.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
        inflate4Arg.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        LightMethodBuilder inflate3Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate3Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate3Arg.addParameter("root", (PsiType)viewGroupType);
        inflate3Arg.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
        LightMethodBuilder inflate2Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate2Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate2Arg.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        LightMethodBuilder inflate1Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate1Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        LightMethodBuilder bind2 = this.createPublicStaticMethod("bind", (PsiType)ownerType);
        bind2.addParameter("view", (PsiType)viewType);
        LightMethodBuilder bindWithComponent = this.createPublicStaticMethod("bind", (PsiType)ownerType);
        bindWithComponent.addParameter("view", (PsiType)viewType);
        bindWithComponent.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        PsiManager psiManager = this.getManager();
        for (PsiMethod method : methods = new PsiMethod[]{inflate1Arg, inflate2Arg, inflate3Arg, inflate4Arg, bind2, bindWithComponent}) {
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)this.myInfo.getPsiFile(), psiManager, method, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    @NotNull
    private LightMethodBuilder createPublicStaticMethod(@NotNull String name, @NotNull PsiType returnType) {
        if (name == null) {
            LightBindingClass.$$$reportNull$$$0(16);
        }
        if (returnType == null) {
            LightBindingClass.$$$reportNull$$$0(17);
        }
        LightMethodBuilder method = this.createPublicMethod(name, returnType);
        method.addModifier("static");
        LightMethodBuilder lightMethodBuilder = method;
        if (lightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(18);
        }
        return lightMethodBuilder;
    }

    @NotNull
    private LightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType) {
        if (name == null) {
            LightBindingClass.$$$reportNull$$$0(19);
        }
        if (returnType == null) {
            LightBindingClass.$$$reportNull$$$0(20);
        }
        LightMethodBuilder method = new LightMethodBuilder(this.getManager(), (Language)JavaLanguage.INSTANCE, name);
        method.setContainingClass((PsiClass)this);
        method.setMethodReturnType(returnType);
        method.addModifier("public");
        LightMethodBuilder lightMethodBuilder = method;
        if (lightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(21);
        }
        return lightMethodBuilder;
    }

    @Nullable
    private PsiField createPsiField(@NotNull DataBindingInfo.ViewWithId viewWithId) {
        PsiType type;
        if (viewWithId == null) {
            LightBindingClass.$$$reportNull$$$0(22);
        }
        if ((type = DataBindingUtil.resolveViewPsiType(viewWithId, this.myFacet)) == null) {
            return null;
        }
        LightFieldBuilder field2 = new LightFieldBuilder(viewWithId.name, type, (PsiElement)viewWithId.tag);
        field2.setModifiers(new String[]{"public", "final"});
        return new LightDataBindingField(viewWithId, PsiManager.getInstance((Project)this.myInfo.getProject()), (PsiField)field2, this);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myInfo.getNavigationElement();
        if (psiElement == null) {
            LightBindingClass.$$$reportNull$$$0(23);
        }
        return psiElement;
    }

    public String getName() {
        return this.myInfo.getClassName();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myVirtualPsiFile;
    }

    public boolean isValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outPsiMethods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewWithId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublicStaticMethod";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublicMethod";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVariableMethods";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createStaticMethods";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPublicStaticMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPublicMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createPsiField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LightDataBindingField
    extends LightField {
        private final DataBindingInfo.ViewWithId myViewWithId;

        LightDataBindingField(DataBindingInfo.ViewWithId viewWithId, @NotNull PsiManager manager, @NotNull PsiField field2, @NotNull PsiClass containingClass) {
            if (manager == null) {
                LightDataBindingField.$$$reportNull$$$0(0);
            }
            if (field2 == null) {
                LightDataBindingField.$$$reportNull$$$0(1);
            }
            if (containingClass == null) {
                LightDataBindingField.$$$reportNull$$$0(2);
            }
            super(manager, field2, containingClass);
            this.myViewWithId = viewWithId;
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiClass containingClass = super.getContainingClass();
            return containingClass == null ? null : containingClass.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            XmlTag xmlTag = this.myViewWithId.tag;
            if (xmlTag == null) {
                LightDataBindingField.$$$reportNull$$$0(3);
            }
            return xmlTag;
        }

        @NotNull
        public PsiElement setName(@NotNull String name) {
            if (name == null) {
                LightDataBindingField.$$$reportNull$$$0(4);
            }
            LightDataBindingField lightDataBindingField = this;
            if (lightDataBindingField == null) {
                LightDataBindingField.$$$reportNull$$$0(5);
            }
            return lightDataBindingField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
            if (navigationElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                LightDataBindingMethod.$$$reportNull$$$0(1);
            }
            if (method == null) {
                LightDataBindingMethod.$$$reportNull$$$0(2);
            }
            if (containingClass == null) {
                LightDataBindingMethod.$$$reportNull$$$0(3);
            }
            if (language == null) {
                LightDataBindingMethod.$$$reportNull$$$0(4);
            }
            super(manager, method, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiClass containingClass = super.getContainingClass();
            return containingClass.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myNavigationElement;
            if (psiElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/LightBindingClass$LightDataBindingMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

