/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import org.jetbrains.annotations.Nullable;

public class ScrollInteraction
extends Interaction {
    private static final int MAX_SCROLL_MULTIPLIER = 5;
    private final ScrollHandler myHandler;
    private int myScrolledAmount;
    private short myLastScrollSign;
    private int myScrollMultiplier = 1;
    private SceneView mySceneView;

    public ScrollInteraction(SceneView sceneView, ScrollHandler scrollHandler) {
        this.mySceneView = sceneView;
        this.myHandler = scrollHandler;
    }

    @Nullable
    public static ScrollInteraction createScrollInteraction(SceneView sceneView, NlComponent component) {
        ViewGroupHandler viewGroupHandler;
        ViewHandler viewHandler2;
        ScrollHandler scrollHandler = null;
        ViewEditorImpl editor2 = new ViewEditorImpl(sceneView);
        for (NlComponent currentComponent = component; !(currentComponent == null || (viewHandler2 = NlComponentHelperKt.getViewHandler(currentComponent)) instanceof ViewGroupHandler && (scrollHandler = (viewGroupHandler = (ViewGroupHandler)viewHandler2).createScrollHandler(editor2, currentComponent)) != null); currentComponent = currentComponent.getParent()) {
        }
        if (scrollHandler == null) {
            return null;
        }
        return new ScrollInteraction(sceneView, scrollHandler);
    }

    @Override
    public void scroll(int x, int y, int scrollAmount) {
        short currentScrollSign = (short)(scrollAmount < 0 ? -1 : 0);
        if (this.myLastScrollSign != currentScrollSign) {
            this.myScrollMultiplier = 1;
            this.myLastScrollSign = currentScrollSign;
        } else if (this.myScrollMultiplier < 5) {
            ++this.myScrollMultiplier;
        }
        int newScrolledAmount = this.myScrolledAmount + scrollAmount * this.myScrollMultiplier;
        int scrolled = this.myHandler.update(newScrolledAmount);
        if (scrolled != 0) {
            this.myScrolledAmount += scrollAmount;
            this.mySceneView.getSceneManager().requestLayoutAndRender(false);
        }
    }

    @Override
    public void end(int x, int y, int modifiers, boolean canceled) {
        if (canceled) {
            this.myHandler.update(0);
            this.mySceneView.getSceneManager().requestLayoutAndRender(false);
            return;
        }
        this.myScrollMultiplier = 1;
        this.myHandler.commit(this.myScrolledAmount);
        this.myScrolledAmount = 0;
    }

    public boolean canScroll(int scrollAmount) {
        return this.myHandler.canScroll(scrollAmount);
    }
}

