/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u0011\u001a\u00020\rH\u00c2\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\tH\u0016J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020\u0004H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawFilledRectangle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "color", "Ljava/awt/Color;", "(ILjava/awt/geom/Rectangle2D$Float;Ljava/awt/Color;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getLevel", "hashCode", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "toString", "intellij.android.designer"})
public final class DrawFilledRectangle
extends DrawCommandBase {
    private final int level;
    private final Rectangle2D.Float rectangle;
    private final Color color;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.level, DrawCommandSerializationHelperKt.rect2DToString(this.rectangle), DrawCommandSerializationHelperKt.colorToString(this.color));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        g.setColor(this.color);
        g.setRenderingHints((Map)DrawCommandBaseKt.getHQ_RENDERING_HINTS());
        g.fill(this.rectangle);
    }

    @NotNull
    public String toString() {
        return "DrawFilledRectangle[" + this.rectangle.x + ", " + this.rectangle.y + ", " + this.rectangle.width + 'x' + this.rectangle.height + ']';
    }

    public DrawFilledRectangle(int level, @NotNull Rectangle2D.Float rectangle, @NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.level = level;
        this.rectangle = rectangle;
        this.color = color;
    }

    private DrawFilledRectangle(String[] sp) {
        String string = sp[0];
        DrawFilledRectangle drawFilledRectangle = this;
        int n = Integer.parseInt(string);
        drawFilledRectangle(n, DrawCommandSerializationHelperKt.stringToRect2D(sp[1]), DrawCommandSerializationHelperKt.stringToColor(sp[2]));
    }

    public DrawFilledRectangle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 3));
    }

    private final int component1() {
        return this.level;
    }

    private final Rectangle2D.Float component2() {
        return this.rectangle;
    }

    private final Color component3() {
        return this.color;
    }

    @NotNull
    public final DrawFilledRectangle copy(int level, @NotNull Rectangle2D.Float rectangle, @NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        return new DrawFilledRectangle(level, rectangle, color);
    }

    @NotNull
    public static /* synthetic */ DrawFilledRectangle copy$default(DrawFilledRectangle drawFilledRectangle, int n, Rectangle2D.Float float_, Color color, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawFilledRectangle.level;
        }
        if ((n2 & 2) != 0) {
            float_ = drawFilledRectangle.rectangle;
        }
        if ((n2 & 4) != 0) {
            color = drawFilledRectangle.color;
        }
        return drawFilledRectangle.copy(n, float_, color);
    }

    public int hashCode() {
        Rectangle2D.Float float_ = this.rectangle;
        Color color = this.color;
        return (Integer.hashCode(this.level) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawFilledRectangle)) break block3;
                DrawFilledRectangle drawFilledRectangle = (DrawFilledRectangle)object;
                if (!(this.level == drawFilledRectangle.level) || !Intrinsics.areEqual((Object)this.rectangle, (Object)drawFilledRectangle.rectangle) || !Intrinsics.areEqual((Object)this.color, (Object)drawFilledRectangle.color)) break block3;
            }
            return true;
        }
        return false;
    }
}

