/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpFloat;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010B%\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\rH\u0016R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawFilledCircle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "myLevel", "", "myCenter", "Ljava/awt/geom/Point2D$Float;", "myColor", "Ljava/awt/Color;", "radius", "", "(ILjava/awt/geom/Point2D$Float;Ljava/awt/Color;F)V", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "center", "color", "Lcom/android/tools/idea/common/scene/LerpFloat;", "(ILjava/awt/geom/Point2D$Float;Ljava/awt/Color;Lcom/android/tools/idea/common/scene/LerpFloat;)V", "getLevel", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawFilledCircle
extends DrawCommandBase {
    private final int level;
    private final Point2D.Float center;
    private final Color color;
    private final LerpFloat radius;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.level, DrawCommandSerializationHelperKt.point2DToString(this.center), DrawCommandSerializationHelperKt.colorToString(this.color), DrawCommandSerializationHelperKt.lerpToString(this.radius));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        float r = ((Number)this.radius.getValue(sceneContext.getTime())).floatValue();
        g.setColor(this.color);
        Ellipse2D.Float circle = new Ellipse2D.Float(this.center.x - r, this.center.y - r, (float)2 * r, (float)2 * r);
        g.fill(circle);
        if (!this.radius.isComplete(sceneContext.getTime())) {
            sceneContext.repaint();
        }
    }

    public DrawFilledCircle(int level, @NotNull Point2D.Float center, @NotNull Color color, @NotNull LerpFloat radius) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        this.level = level;
        this.center = center;
        this.color = color;
        this.radius = radius;
    }

    public DrawFilledCircle(int myLevel, @NotNull Point2D.Float myCenter, @NotNull Color myColor, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)myCenter, (String)"myCenter");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        this(myLevel, myCenter, myColor, new LerpFloat(radius));
    }

    private DrawFilledCircle(String[] sp) {
        String string = sp[0];
        DrawFilledCircle drawFilledCircle = this;
        int n = Integer.parseInt(string);
        drawFilledCircle(n, DrawCommandSerializationHelperKt.stringToPoint2D(sp[1]), DrawCommandSerializationHelperKt.stringToColor(sp[2]), DrawCommandSerializationHelperKt.stringToLerp(sp[3]));
    }

    public DrawFilledCircle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

