/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpFloat;
import com.google.common.base.Joiner;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001e\u001a\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u000e\u0010#\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010&\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010'\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010)\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010,\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020+\u00a8\u0006-"}, d2={"buildString", "", "simpleName", "properties", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "colorToString", "c", "Ljava/awt/Color;", "fontToString", "f", "Ljava/awt/Font;", "lerpToString", "l", "Lcom/android/tools/idea/common/scene/LerpFloat;", "parse", "s", "expected", "", "(Ljava/lang/String;I)[Ljava/lang/String;", "point2DToString", "p", "Ljava/awt/geom/Point2D$Float;", "pointToString", "Ljava/awt/Point;", "rect2DToString", "r", "Ljava/awt/geom/Rectangle2D$Float;", "roundRect2DToString", "Ljava/awt/geom/RoundRectangle2D$Float;", "splitString", "", "delimiter", "", "stringToColor", "stringToFont", "stringToLerp", "stringToPoint", "stringToPoint2D", "stringToRect2D", "stringToRoundRect2D", "stringToStroke", "Ljava/awt/BasicStroke;", "strokeToString", "intellij.android.designer"})
public final class DrawCommandSerializationHelperKt {
    @NotNull
    public static final String[] parse(@NotNull String s, int expected) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Collection collection = $receiver$iv = (Collection)DrawCommandSerializationHelperKt.splitString(s, ',');
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] sp = stringArray;
        if (sp.length != expected) {
            throw (Throwable)new IllegalArgumentException();
        }
        return sp;
    }

    @NotNull
    public static final String buildString(@NotNull String simpleName, Object ... properties) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)simpleName, (String)"simpleName");
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        Object[] objectArray = properties;
        StringBuilder stringBuilder = new StringBuilder().append(simpleName);
        Object object2 = objectArray;
        boolean bl = !(((Object[])object2).length == 0);
        StringBuilder stringBuilder2 = stringBuilder;
        if (bl) {
            char c = ',';
            String string = Joiner.on((char)',').join(properties);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(',').join(properties)");
            object2 = string;
            stringBuilder = stringBuilder2;
            String string2 = String.valueOf(c) + (String)object2;
            stringBuilder2 = stringBuilder;
            object = string2;
        } else {
            object = Unit.INSTANCE;
        }
        return stringBuilder2.append(object).toString();
    }

    @NotNull
    public static final Rectangle2D.Float stringToRect2D(@NotNull String s) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, 'x');
        Rectangle2D.Float r = new Rectangle2D.Float();
        String string = sp.get(0);
        Rectangle2D.Float float_ = r;
        float_.x = f = Float.parseFloat(string);
        string = sp.get(1);
        float_ = r;
        float_.y = f = Float.parseFloat(string);
        string = sp.get(2);
        float_ = r;
        float_.width = f = Float.parseFloat(string);
        string = sp.get(3);
        float_ = r;
        float_.height = f = Float.parseFloat(string);
        return r;
    }

    @NotNull
    public static final String rect2DToString(@NotNull Rectangle2D.Float r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        String string = Joiner.on((char)'x').join((Object)Float.valueOf(r.x), (Object)Float.valueOf(r.y), new Object[]{Float.valueOf(r.width), Float.valueOf(r.height)});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on('x').join(r.x, r.y, r.width, r.height)");
        return string;
    }

    @NotNull
    public static final RoundRectangle2D.Float stringToRoundRect2D(@NotNull String s) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, 'x');
        RoundRectangle2D.Float r = new RoundRectangle2D.Float();
        String string = sp.get(0);
        RoundRectangle2D.Float float_ = r;
        float_.x = f = Float.parseFloat(string);
        string = sp.get(1);
        float_ = r;
        float_.y = f = Float.parseFloat(string);
        string = sp.get(2);
        float_ = r;
        float_.width = f = Float.parseFloat(string);
        string = sp.get(3);
        float_ = r;
        float_.height = f = Float.parseFloat(string);
        string = sp.get(4);
        float_ = r;
        float_.arcwidth = f = Float.parseFloat(string);
        string = sp.get(5);
        float_ = r;
        float_.archeight = f = Float.parseFloat(string);
        return r;
    }

    @NotNull
    public static final String roundRect2DToString(@NotNull RoundRectangle2D.Float r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        String string = Joiner.on((char)'x').join((Object)Float.valueOf(r.x), (Object)Float.valueOf(r.y), new Object[]{Float.valueOf(r.width), Float.valueOf(r.height), Float.valueOf(r.arcwidth), r.getArcHeight()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on('x').join(r.x,\u2026 r.arcwidth, r.arcHeight)");
        return string;
    }

    @NotNull
    public static final Color stringToColor(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = s;
        int n = 16;
        long l = Long.parseLong(string, CharsKt.checkRadix((int)n));
        int n2 = (int)l;
        return new Color(n2);
    }

    @NotNull
    public static final String colorToString(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        String string = Integer.toHexString(c.getRGB());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toHexString(c.rgb)");
        return string;
    }

    @NotNull
    public static final Font stringToFont(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, ':');
        String string = sp.get(1);
        int style = Integer.parseInt(string);
        String string2 = sp.get(2);
        int size = Integer.parseInt(string2);
        return new Font(sp.get(0), style, size);
    }

    @NotNull
    public static final String fontToString(@NotNull Font f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        String string = Joiner.on((char)':').join((Object)f.getName(), (Object)f.getStyle(), new Object[]{f.getSize()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(':').join(f.name, f.style, f.size)");
        return string;
    }

    @NotNull
    public static final Point stringToPoint(@NotNull String s) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, 'x');
        Point p = new Point();
        String string = sp.get(0);
        Point point = p;
        point.x = n = Integer.parseInt(string);
        string = sp.get(1);
        point = p;
        point.y = n = Integer.parseInt(string);
        return p;
    }

    @NotNull
    public static final String pointToString(@NotNull Point p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        String string = Joiner.on((char)'x').join((Object)p.x, (Object)p.y, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on('x').join(p.x, p.y)");
        return string;
    }

    @NotNull
    public static final Point2D.Float stringToPoint2D(@NotNull String s) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, 'x');
        Point2D.Float p = new Point2D.Float();
        String string = sp.get(0);
        Point2D.Float float_ = p;
        float_.x = f = Float.parseFloat(string);
        string = sp.get(1);
        float_ = p;
        float_.y = f = Float.parseFloat(string);
        return p;
    }

    @NotNull
    public static final String point2DToString(@NotNull Point2D.Float p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        String string = Joiner.on((char)'x').join((Object)Float.valueOf(p.x), (Object)Float.valueOf(p.y), new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on('x').join(p.x, p.y)");
        return string;
    }

    @NotNull
    public static final LerpFloat stringToLerp(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, ':');
        String string = sp.get(0);
        float start = Float.parseFloat(string);
        String string2 = sp.get(1);
        float end = Float.parseFloat(string2);
        String string3 = sp.get(2);
        int duration = Integer.parseInt(string3);
        return new LerpFloat(start, end, duration);
    }

    @NotNull
    public static final String lerpToString(@NotNull LerpFloat l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        String string = Joiner.on((char)':').join(l.getStart(), l.getEnd(), new Object[]{l.getDuration()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(':').join(l.start, l.end, l.duration)");
        return string;
    }

    @NotNull
    public static final BasicStroke stringToStroke(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        List<String> sp = DrawCommandSerializationHelperKt.splitString(s, ':');
        String string = sp.get(0);
        int width = Integer.parseInt(string);
        String string2 = sp.get(1);
        int cap = Integer.parseInt(string2);
        String string3 = sp.get(2);
        int join = Integer.parseInt(string3);
        return new BasicStroke(width, cap, join);
    }

    @NotNull
    public static final String strokeToString(@NotNull BasicStroke s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = Joiner.on((char)':').join((Object)((int)s.getLineWidth()), (Object)s.getEndCap(), new Object[]{s.getLineJoin()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(':').join(s.li\u2026(), s.endCap, s.lineJoin)");
        return string;
    }

    private static final List<String> splitString(String s, char delimiter) {
        List list;
        List $receiver$iv = StringsKt.split$default((CharSequence)s, (char[])new char[]{delimiter}, (boolean)false, (int)0, (int)6, null);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

