/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DrawArrow$WhenMappings;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010#\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020\tH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020\u0004H\u0016R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001b\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006,"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawArrow;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "myLevel", "", "myDirection", "Lcom/android/tools/idea/common/scene/draw/ArrowDirection;", "myRectangle", "Ljava/awt/geom/Rectangle2D$Float;", "myColor", "Ljava/awt/Color;", "(ILcom/android/tools/idea/common/scene/draw/ArrowDirection;Ljava/awt/geom/Rectangle2D$Float;Ljava/awt/Color;)V", "bottom", "", "getBottom", "()F", "left", "getLeft", "path", "Ljava/awt/geom/Path2D$Float;", "right", "getRight", "top", "getTop", "xValues", "", "getXValues", "()[F", "yValues", "getYValues", "buildPath", "getLevel", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawArrow
extends DrawCommandBase {
    private final Path2D.Float path;
    private final int myLevel;
    private final ArrowDirection myDirection;
    private final Rectangle2D.Float myRectangle;
    private final Color myColor;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, new Object[]{this.myLevel, this.myDirection, DrawCommandSerializationHelperKt.rect2DToString(this.myRectangle), DrawCommandSerializationHelperKt.colorToString(this.myColor)});
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        g.setColor(this.myColor);
        g.fill(this.path);
    }

    private final float getLeft() {
        return this.myRectangle.x;
    }

    private final float getRight() {
        return this.myRectangle.x + this.myRectangle.width;
    }

    private final float getTop() {
        return this.myRectangle.y;
    }

    private final float getBottom() {
        return this.myRectangle.y + this.myRectangle.height;
    }

    private final float[] getXValues() {
        float[] fArray;
        switch (DrawArrow$WhenMappings.$EnumSwitchMapping$0[this.myDirection.ordinal()]) {
            case 1: {
                float[] fArray2 = new float[3];
                fArray2[0] = this.getRight();
                fArray2[1] = this.getLeft();
                fArray = fArray2;
                fArray2[2] = this.getRight();
                break;
            }
            case 2: {
                float[] fArray3 = new float[3];
                fArray3[0] = this.getLeft();
                fArray3[1] = this.getRight();
                fArray = fArray3;
                fArray3[2] = this.getLeft();
                break;
            }
            default: {
                float[] fArray4 = new float[3];
                fArray4[0] = this.getLeft();
                fArray4[1] = (this.getLeft() + this.getRight()) / (float)2;
                fArray = fArray4;
                fArray4[2] = this.getRight();
            }
        }
        return fArray;
    }

    private final float[] getYValues() {
        float[] fArray;
        switch (DrawArrow$WhenMappings.$EnumSwitchMapping$1[this.myDirection.ordinal()]) {
            case 1: {
                float[] fArray2 = new float[3];
                fArray2[0] = this.getBottom();
                fArray2[1] = this.getTop();
                fArray = fArray2;
                fArray2[2] = this.getBottom();
                break;
            }
            case 2: {
                float[] fArray3 = new float[3];
                fArray3[0] = this.getTop();
                fArray3[1] = this.getBottom();
                fArray = fArray3;
                fArray3[2] = this.getTop();
                break;
            }
            default: {
                float[] fArray4 = new float[3];
                fArray4[0] = this.getTop();
                fArray4[1] = (this.getTop() + this.getBottom()) / (float)2;
                fArray = fArray4;
                fArray4[2] = this.getBottom();
            }
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    private final Path2D.Float buildPath() {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(this.getXValues()[0], this.getYValues()[0]);
        int n = 1;
        float[] fArray = this.getXValues();
        int n2 = fArray.length;
        while (n < n2) {
            void i2;
            path.lineTo(this.getXValues()[i2], this.getYValues()[i2]);
            ++i2;
        }
        path.closePath();
        return path;
    }

    public DrawArrow(int myLevel, @NotNull ArrowDirection myDirection, @NotNull Rectangle2D.Float myRectangle, @NotNull Color myColor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)myDirection), (String)"myDirection");
        Intrinsics.checkParameterIsNotNull((Object)myRectangle, (String)"myRectangle");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        this.myLevel = myLevel;
        this.myDirection = myDirection;
        this.myRectangle = myRectangle;
        this.myColor = myColor;
        this.path = this.buildPath();
    }

    private DrawArrow(String[] sp) {
        String string = sp[0];
        DrawArrow drawArrow = this;
        int n = Integer.parseInt(string);
        drawArrow(n, ArrowDirection.valueOf(sp[1]), DrawCommandSerializationHelperKt.stringToRect2D(sp[2]), DrawCommandSerializationHelperKt.stringToColor(sp[3]));
    }

    public DrawArrow(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

