/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SceneHitListener
implements ScenePicker.HitElementListener {
    @NotNull
    private SelectionModel mySelectionModel;
    private ScenePicker myPicker;
    double myClosestComponentDistance;
    double myClosestTargetDistance;
    ArrayList<SceneComponent> myHitComponents;
    @NotNull
    final ArrayList<Target> myHitTargets;
    Target mySkipTarget;

    SceneHitListener(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            SceneHitListener.$$$reportNull$$$0(0);
        }
        this.myPicker = new ScenePicker();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myHitComponents = new ArrayList();
        this.myHitTargets = new ArrayList();
        this.mySkipTarget = null;
        this.mySelectionModel = selectionModel;
        this.myPicker.setSelectListener(this);
    }

    public void skipTarget(Target target) {
        this.mySkipTarget = target;
    }

    public void find(@NotNull SceneContext transform2, @NotNull SceneComponent root, int x, int y) {
        if (transform2 == null) {
            SceneHitListener.$$$reportNull$$$0(1);
        }
        if (root == null) {
            SceneHitListener.$$$reportNull$$$0(2);
        }
        this.myHitComponents.clear();
        this.myHitTargets.clear();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myPicker.reset();
        root.addHit(transform2, this.myPicker);
        this.myPicker.find(transform2.getSwingXDip(x), transform2.getSwingYDip(y));
    }

    @Override
    public void over(Object over, double dist) {
        if (over instanceof Target) {
            if (this.mySkipTarget == over) {
                return;
            }
            Target target = (Target)over;
            if (dist < this.myClosestTargetDistance) {
                this.myHitTargets.clear();
                this.myHitTargets.add(target);
                this.myClosestTargetDistance = dist;
            } else if (dist == this.myClosestTargetDistance) {
                this.myHitTargets.add(target);
            }
        } else if (over instanceof SceneComponent) {
            SceneComponent currentSelection;
            SceneComponent component = (SceneComponent)over;
            if (this.myHitComponents.size() == 1 && (currentSelection = this.myHitComponents.get(0)).getChildren().contains(component)) {
                this.myHitComponents.clear();
                this.myHitComponents.add(component);
                this.myClosestComponentDistance = dist;
                return;
            }
            if (dist < this.myClosestComponentDistance) {
                this.myHitComponents.clear();
                this.myHitComponents.add(component);
                this.myClosestComponentDistance = dist;
            } else if (dist == this.myClosestComponentDistance) {
                this.myHitComponents.add(component);
            }
        }
    }

    public Target getClosestTarget() {
        int count = this.myHitTargets.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.myHitTargets.get(0);
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if (selection.isEmpty()) {
            Target candidate = this.myHitTargets.get(count - 1);
            for (int i2 = count - 2; i2 >= 0; --i2) {
                Target target = this.myHitTargets.get(i2);
                if (target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
                candidate = target;
            }
            return candidate;
        }
        Target candidate = this.myHitTargets.get(count - 1);
        boolean inSelection = SceneHitListener.parentInSelection(candidate.getComponent(), selection);
        for (int i3 = count - 2; i3 >= 0; --i3) {
            Target target = this.myHitTargets.get(i3);
            if (inSelection && !SceneHitListener.parentInSelection(target.getComponent(), selection) || (inSelection || !SceneHitListener.parentInSelection(target.getComponent(), selection)) && target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
            candidate = target;
            inSelection = true;
        }
        return candidate;
    }

    @Nullable
    public Target getFilteredTarget(Target filteredTarget) {
        Target hit = null;
        boolean found = false;
        for (Target target : this.myHitTargets) {
            if (target == filteredTarget) {
                found = true;
                continue;
            }
            if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
            hit = target;
        }
        if (hit == null && found) {
            hit = filteredTarget;
        }
        return hit;
    }

    public SceneComponent getClosestComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.myHitComponents.get(0);
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if (selection.isEmpty()) {
            return this.myHitComponents.get(count - 1);
        }
        SceneComponent candidate = this.myHitComponents.get(count - 1);
        boolean inSelection = selection.contains(candidate.getNlComponent());
        if (inSelection) {
            return candidate;
        }
        for (int i2 = count - 1; i2 >= 0; --i2) {
            SceneComponent target = this.myHitComponents.get(i2);
            if (!SceneHitListener.parentInSelection(target, selection)) continue;
            return target;
        }
        return candidate;
    }

    private static boolean parentInSelection(@NotNull SceneComponent component, @NotNull List<NlComponent> selection) {
        if (component == null) {
            SceneHitListener.$$$reportNull$$$0(3);
        }
        if (selection == null) {
            SceneHitListener.$$$reportNull$$$0(4);
        }
        while (component != null) {
            if (selection.contains(component.getNlComponent())) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/SceneHitListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parentInSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

