/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneHitListener;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private final DesignSurface myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents;
    private SceneComponent myRoot;
    private boolean myIsAnimated;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    private int mNeedsLayout;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    @NotNull
    private final SceneHitListener myHoverListener;
    @NotNull
    private final SceneHitListener myHitListener;
    @NotNull
    private final SceneHitListener myFindListener;
    @NotNull
    private final SceneHitListener mySnapListener;
    @Nullable
    private Target myHitTarget;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    List<SceneComponent> myNewSelectedComponentsOnRelease;
    List<SceneComponent> myNewSelectedComponentsOnDown;
    private boolean myIsControlDown;
    private boolean myIsShiftDown;
    private boolean myIsAltDown;
    private boolean myIsLiveRenderingEnabled;
    @NotNull
    private FilterType myFilterType;

    public Scene(@NotNull SceneManager sceneManager, @NotNull DesignSurface surface, @NotNull RenderSettings renderSettings) {
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            Scene.$$$reportNull$$$0(1);
        }
        if (renderSettings == null) {
            Scene.$$$reportNull$$$0(2);
        }
        this.mySceneComponents = new HashMap();
        this.myIsAnimated = true;
        this.myDisplayListVersion = 1L;
        this.mNeedsLayout = 0;
        this.myHitTarget = null;
        this.myNewSelectedComponentsOnRelease = new ArrayList<SceneComponent>();
        this.myNewSelectedComponentsOnDown = new ArrayList<SceneComponent>();
        this.myFilterType = FilterType.NONE;
        this.myDesignSurface = surface;
        this.mySceneManager = sceneManager;
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        this.myHoverListener = new SceneHitListener(selectionModel);
        this.myHitListener = new SceneHitListener(selectionModel);
        this.myFindListener = new SceneHitListener(selectionModel);
        this.mySnapListener = new SceneHitListener(selectionModel);
        selectionModel.addListener(this);
        this.myIsLiveRenderingEnabled = renderSettings.getUseLiveRendering();
        Disposer.register((Disposable)sceneManager, (Disposable)this);
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        SceneManager sceneManager = this.mySceneManager;
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(3);
        }
        return sceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isInRTL() {
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public int getRenderedApiLevel() {
        IAndroidTarget target;
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration != null && (target = configuration.getTarget()) != null) {
            return target.getVersion().getApiLevel();
        }
        return 1;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component) {
        if (component == null) {
            return null;
        }
        return this.mySceneComponents.get(component);
    }

    @NotNull
    public DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            Scene.$$$reportNull$$$0(4);
        }
        return designSurface;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            Scene.$$$reportNull$$$0(5);
        }
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public void updateModifiers(int modifiers) {
        this.myIsControlDown = (modifiers & 0x80) != 0 || (modifiers & 2) != 0;
        this.myIsShiftDown = (modifiers & 0x40) != 0 || (modifiers & 1) != 0;
        this.myIsAltDown = (modifiers & 0x200) != 0 || (modifiers & 8) != 0;
    }

    public boolean isControlDown() {
        return this.myIsControlDown;
    }

    public boolean isShiftDown() {
        return this.myIsShiftDown;
    }

    public boolean isAltDown() {
        return this.myIsAltDown;
    }

    public void clearAllConstraints() {
        if (this.myRoot != null) {
            Stream.of(this.myRoot).flatMap(c -> c.getChildren().stream()).forEach(c -> c.clearAttributes());
        }
        this.select(Collections.emptyList());
    }

    public void addComponent(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(6);
        }
        this.mySceneComponents.put(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(7);
        }
        component.removeFromParent();
        this.mySceneComponents.remove(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            Scene.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            Scene.$$$reportNull$$$0(9);
        }
        if (this.myRoot != null) {
            Scene.markSelection(this.myRoot, model);
        }
    }

    private static void markSelection(SceneComponent component, SelectionModel model) {
        component.setSelected(model.isSelected(component.getNlComponent()));
        for (SceneComponent child : component.getChildren()) {
            Scene.markSelection(child, model);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneView sceneView) {
        void sceneView2;
        if (displayList == null) {
            Scene.$$$reportNull$$$0(10);
        }
        this.buildDisplayList(displayList, time2, SceneContext.get((SceneView)sceneView2));
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(11);
        }
        this.layout(time2, SceneContext.get());
        this.buildDisplayList(displayList, time2, SceneContext.get());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneContext sceneContext) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(12);
        }
        if (this.myRoot != null) {
            void sceneContext2;
            this.myRoot.buildDisplayList(time2, displayList, (SceneContext)sceneContext2);
        }
    }

    public boolean layout(long time2, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        if (this.myRoot != null && (needsToRebuildDisplayList = this.myRoot.layout(sceneContext, time2))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.myIsShiftDown || this.myIsControlDown) {
                ImmutableList<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll((Collection<NlComponent>)selection);
            }
            for (SceneComponent sceneComponent : components) {
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if ((this.myIsShiftDown || this.myIsControlDown) && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public void mouseHover(@NotNull SceneContext transform2, int x, int y) {
        SceneComponent closestComponent;
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(13);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myRoot != null) {
            this.myHoverListener.find(transform2, this.myRoot, x, y);
            this.mySnapListener.find(transform2, this.myRoot, x, y);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget();
        String tooltip = null;
        if (this.myOverTarget != closestTarget) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setMouseHovered(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setMouseHovered(true);
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null) {
            tooltip = closestTarget.getToolTipText();
            Target snapTarget = this.myHoverListener.getFilteredTarget(closestTarget);
            if (snapTarget != this.mySnapTarget) {
                if (this.mySnapTarget != null) {
                    this.mySnapTarget.setMouseHovered(false);
                    this.mySnapTarget = null;
                    this.needsRebuildList();
                }
                if (snapTarget != null) {
                    snapTarget.setMouseHovered(true);
                    this.mySnapTarget = closestTarget;
                    this.needsRebuildList();
                }
            }
        }
        if ((closestComponent = this.myHoverListener.getClosestComponent()) != null && tooltip == null) {
            tooltip = closestComponent.getNlComponent().getTooltipText();
        }
        if (this.myCurrentComponent != closestComponent) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
            this.needsRebuildList();
        }
        transform2.setToolTip(tooltip);
        this.setCursor(transform2, x, y);
    }

    private void setCursor(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(14);
        }
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor();
            return;
        }
        SceneComponent component = this.findComponent(transform2, x, y);
        if (component != null && component.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection;
        if (currentComponent == null) {
            Scene.$$$reportNull$$$0(15);
        }
        if ((selection = this.getSelection()).size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection;
        if (currentComponent == null) {
            Scene.$$$reportNull$$$0(16);
        }
        if ((selection = this.getSelection()).size() > 1) {
            int count = selection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i2);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(17);
        }
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterType = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myNewSelectedComponentsOnDown.clear();
        this.myHitListener.find(transform2, this.myRoot, x, y);
        this.myHitTarget = this.myHitListener.getClosestTarget();
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        } else if (this.myHitComponent != null && !this.inCurrentSelection(this.myHitComponent)) {
            this.myNewSelectedComponentsOnDown.add(this.myHitComponent);
            this.select(this.myNewSelectedComponentsOnDown);
        }
    }

    public void mouseDrag(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(18);
        }
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform2) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform2)) {
                return;
            }
            LassoTarget lassoTarget = null;
            if (this.myHitTarget instanceof LassoTarget && (lassoTarget = (LassoTarget)this.myHitTarget).getSelectWhileDragging() && lassoTarget.getHasChanged()) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.addAll(lassoTarget.getIntersectingComponents());
                this.select(this.myNewSelectedComponentsOnRelease);
                lassoTarget.clearHasChanged();
            }
            this.myHitListener.skipTarget(this.myHitTarget);
            this.myHitListener.find(transform2, this.myRoot, x, y);
            SceneComponent targetComponent = this.myHitTarget.getComponent();
            if ((lassoTarget == null || lassoTarget.getIntersectingComponents().isEmpty()) && targetComponent != null && !this.inCurrentSelection(targetComponent)) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.add(targetComponent);
                this.select(this.myNewSelectedComponentsOnRelease);
            }
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
            this.myHitListener.skipTarget(null);
        }
        this.mouseHover(transform2, x, y);
        this.checkRequestLayoutStatus();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform2) {
        int pos4;
        int pos3 = transform2.getSwingDimensionDip(pos1);
        return Math.abs(pos3 - (pos4 = transform2.getSwingDimensionDip(pos2))) < DRAG_THRESHOLD;
    }

    public void checkRequestLayoutStatus() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.myDesignSurface.getSceneManager();
            if (manager == null) {
                return;
            }
            if (this.myIsLiveRenderingEnabled) {
                manager.requestLayoutAndRender(this.mNeedsLayout == 2);
            } else {
                manager.layout(this.mNeedsLayout == 2);
            }
        }
    }

    public void mouseRelease(@NotNull SceneContext transform2, int x, int y) {
        List<SceneComponent> changed;
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(19);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        SceneComponent closestComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform2, this.myRoot, x, y);
            Target closest = this.myHitListener.getFilteredTarget(this.myHitTarget);
            this.myHitTarget.mouseRelease(x, y, closest != null ? Collections.singletonList(closest) : Collections.emptyList());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        if (this.myHitComponent != null && closestComponent == this.myHitComponent) {
            this.myNewSelectedComponentsOnRelease.add(this.myHitComponent);
        }
        if (this.myHitTarget != null && (changed = this.myHitTarget.newSelection()) != null) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.addAll(changed);
        }
        if (!this.sameSelection() && (this.myHitTarget == null || this.myHitTarget.canChangeSelection())) {
            this.select(this.myNewSelectedComponentsOnRelease);
        }
        this.checkRequestLayoutStatus();
    }

    private boolean inCurrentSelection(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(20);
        }
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        return currentSelection.contains(component.getNlComponent());
    }

    private boolean sameSelection() {
        if (!this.myNewSelectedComponentsOnRelease.isEmpty() && this.myNewSelectedComponentsOnRelease.size() == this.myNewSelectedComponentsOnDown.size() && this.myNewSelectedComponentsOnRelease.containsAll(this.myNewSelectedComponentsOnDown)) {
            return true;
        }
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponentsOnRelease.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                NlComponent component = (NlComponent)currentSelection.get(i2);
                SceneComponent sceneComponent = this.getSceneComponent(component);
                if (this.myNewSelectedComponentsOnRelease.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void needsLayout(int type) {
        if (this.mNeedsLayout < type) {
            this.mNeedsLayout = type;
        }
    }

    public long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList within = Lists.newArrayList();
        if (this.getRoot() != null) {
            Scene.addWithin(within, this.getRoot(), x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result2, @NotNull SceneComponent component, int x, int y, int width, int height) {
        if (result2 == null) {
            Scene.$$$reportNull$$$0(21);
        }
        if (component == null) {
            Scene.$$$reportNull$$$0(22);
        }
        if (component.getDrawX() + component.getDrawWidth() <= x || x + width <= component.getDrawX() || component.getDrawY() + component.getDrawHeight() <= y || y + height <= component.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component.getChildren()) {
            found |= Scene.addWithin(result2, child, x, y, width, height);
        }
        if (!found) {
            result2.add(component);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(23);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform2, this.myRoot, x, y);
        return this.myFindListener.getClosestComponent();
    }

    @Nullable
    public Target findTarget(@NotNull SceneContext transform2, int x, int y) {
        if (transform2 == null) {
            Scene.$$$reportNull$$$0(24);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform2, this.myRoot, x, y);
        return this.myFindListener.getClosestTarget();
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root) {
        this.myRoot = root;
    }

    @NotNull
    public FilterType getFilterType() {
        FilterType filterType = this.myFilterType;
        if (filterType == null) {
            Scene.$$$reportNull$$$0(25);
        }
        return filterType;
    }

    public void setFilterType(@NotNull FilterType filterType) {
        if (filterType == null) {
            Scene.$$$reportNull$$$0(26);
        }
        this.myFilterType = filterType;
    }

    @Nullable
    public Target getInteractingTarget() {
        return this.myHitTarget;
    }

    @Nullable
    public Dimension measureWrapSize(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(27);
        }
        return this.measure(component, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @Nullable
    private Dimension measure(@NotNull SceneComponent component, @Nullable RenderTask.AttributeFilter filter2) {
        NlComponent neleComponent;
        XmlTag tag;
        if (component == null) {
            Scene.$$$reportNull$$$0(28);
        }
        if (!(tag = (neleComponent = component.getNlComponent()).getTag()).isValid()) {
            return null;
        }
        NlModel model = neleComponent.getModel();
        XmlFile xmlFile = model.getFile();
        Module module = model.getModule();
        RenderService renderService = RenderService.getInstance(module.getProject());
        AndroidFacet facet = model.getFacet();
        RenderLogger logger = renderService.createLogger(facet);
        RenderTask task = renderService.taskBuilder(facet, model.getConfiguration()).withLogger(logger).withPsiFile((PsiFile)xmlFile).build();
        if (task == null) {
            return null;
        }
        ViewInfo viewInfo = task.measureChild(tag, filter2);
        if (viewInfo == null) {
            return null;
        }
        viewInfo = RenderService.getSafeBounds(viewInfo);
        return new Dimension(Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getBottom() - viewInfo.getTop()));
    }

    public List<Placeholder> getPlaceholders(@Nullable SceneComponent requester) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Scene.doGetPlaceholders((ImmutableList.Builder<Placeholder>)builder, this.myRoot, requester);
        return builder.build();
    }

    public boolean isLiveRenderingEnabled() {
        return this.myIsLiveRenderingEnabled;
    }

    public void setLiveRenderingEnabled(boolean enabled) {
        this.myIsLiveRenderingEnabled = enabled;
    }

    private static void doGetPlaceholders(@NotNull ImmutableList.Builder<Placeholder> builder, @NotNull SceneComponent component, @Nullable SceneComponent requester) {
        if (builder == null) {
            Scene.$$$reportNull$$$0(29);
        }
        if (component == null) {
            Scene.$$$reportNull$$$0(30);
        }
        if (component == requester) {
            return;
        }
        NlComponent nlComponent = component.getNlComponent();
        ViewHandler handler = NlComponentHelperKt.getViewHandler(nlComponent);
        if (handler != null) {
            builder.addAll(handler.getPlaceholders(component));
        }
        for (SceneComponent child : component.getChildren()) {
            Scene.doGetPlaceholders(builder, child, requester);
        }
    }

    public void setHitTarget(@Nullable Target hitTarget) {
        this.myHitTarget = hitTarget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderSettings";
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayList";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentComponent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mouseHover";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "delegateMouseDragToSelection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "delegateMouseReleaseToSelection";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mouseDown";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inCurrentSelection";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addWithin";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setFilterType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "measureWrapSize";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doGetPlaceholders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

