/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import java.awt.Toolkit;
import org.jetbrains.annotations.NotNull;

public class GotoComponentAction
extends DumbAwareAction {
    private final DesignSurface mySurface;

    public GotoComponentAction(DesignSurface surface) {
        super("Go to XML");
        this.mySurface = surface;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GotoComponentAction.$$$reportNull$$$0(0);
        }
        if (e.getInputEvent().getModifiers() == (0x10 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            return;
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        NlComponent primary = selectionModel.getPrimary();
        XmlTag psiElement = null;
        NlModel model = this.mySurface.getModel();
        if (primary != null) {
            psiElement = primary.getTag();
        } else if (model != null) {
            ImmutableList<NlComponent> components = model.getComponents();
            psiElement = !components.isEmpty() ? ((NlComponent)components.get(0)).getTag() : null;
        }
        this.mySurface.deactivate();
        if (psiElement != null && psiElement.isValid()) {
            GotoComponentAction.switchTabAndNavigate((PsiElement)psiElement);
        } else if (model != null) {
            this.switchTab(model);
        }
    }

    private static void switchTabAndNavigate(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GotoComponentAction.$$$reportNull$$$0(1);
        }
        PsiNavigateUtil.navigate((PsiElement)psiElement);
    }

    private void switchTab(@NotNull NlModel model) {
        if (model == null) {
            GotoComponentAction.$$$reportNull$$$0(2);
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.mySurface.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(model.getProject(), model.getVirtualFile(), 0), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/actions/GotoComponentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "switchTabAndNavigate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "switchTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

