/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging.editor;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.apk.debugging.ExternalSourceFolders;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkDebugProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class ChooseAndAttachJavaSourcesTask
implements Runnable {
    @NotNull
    private final String myClassFqn;
    @NotNull
    private final Module myModule;
    @NotNull
    private final EditorNotifications myEditorNotifications;
    @NotNull
    private final DumbService myDumbService;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;
    @NotNull
    private final FileOrFolderChooser myFileOrFolderChooser;

    ChooseAndAttachJavaSourcesTask(@NotNull String classFqn, @NotNull Module module, @NotNull DexSourceFiles dexSourceFiles) {
        if (classFqn == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(1);
        }
        if (dexSourceFiles == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(2);
        }
        this(classFqn, module, DumbService.getInstance((Project)module.getProject()), EditorNotifications.getInstance((Project)module.getProject()), dexSourceFiles, project -> {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor.setTitle("Attach Sources");
            descriptor.setDescription("Select directories in which Java sources are located");
            return FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)module.getProject(), null);
        });
    }

    @VisibleForTesting
    ChooseAndAttachJavaSourcesTask(@NotNull String classFqn, @NotNull Module module, @NotNull DumbService dumbService, @NotNull EditorNotifications editorNotifications, @NotNull DexSourceFiles dexSourceFiles, @NotNull FileOrFolderChooser fileOrFolderChooser) {
        if (classFqn == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(4);
        }
        if (dumbService == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(5);
        }
        if (editorNotifications == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(6);
        }
        if (dexSourceFiles == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(7);
        }
        if (fileOrFolderChooser == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(8);
        }
        this.myClassFqn = classFqn;
        this.myModule = module;
        this.myDumbService = dumbService;
        this.myEditorNotifications = editorNotifications;
        this.myDexSourceFiles = dexSourceFiles;
        this.myFileOrFolderChooser = fileOrFolderChooser;
    }

    @Override
    public void run() {
        VirtualFile[] chosenFiles = this.myFileOrFolderChooser.choose(this.myModule.getProject());
        if (chosenFiles.length > 0) {
            ApkFacet facet = ApkFacet.getInstance(this.myModule);
            if (facet != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApkDebugProject.Builder project = ApkDebugProject.newBuilder();
                project.setPackageId(AnonymizerUtil.anonymizeUtf8((String)((ApkFacetConfiguration)facet.getConfiguration()).APP_PACKAGE));
                AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                event.setCategory(AndroidStudioEvent.EventCategory.APK_DEBUG).setKind(AndroidStudioEvent.EventKind.APK_DEBUG_ATTACH_JAVA_SOURCES).setApkDebugProject(project);
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myModule.getProject()));
            }
            ModifiableRootModel moduleModel = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            ExternalSourceFolders sourceFolders = new ExternalSourceFolders(moduleModel);
            sourceFolders.addSourceFolders(chosenFiles, () -> {
                if (facet != null) {
                    ChooseAndAttachJavaSourcesTask.storeJavaSourceFolderPaths(facet, chosenFiles);
                }
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)moduleModel).commit());
                this.myDumbService.smartInvokeLater(() -> this.myDexSourceFiles.navigateToJavaFile(this.myClassFqn));
                this.myEditorNotifications.updateAllNotifications();
            });
        }
    }

    private static void storeJavaSourceFolderPaths(@NotNull ApkFacet facet, @NotNull VirtualFile[] chosenFiles) {
        if (facet == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(9);
        }
        if (chosenFiles == null) {
            ChooseAndAttachJavaSourcesTask.$$$reportNull$$$0(10);
        }
        ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet.getConfiguration();
        for (VirtualFile file : chosenFiles) {
            File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            configuration.JAVA_SOURCE_FOLDER_PATHS.add(path.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexSourceFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorNotifications";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrFolderChooser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFiles";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/debugging/editor/ChooseAndAttachJavaSourcesTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "storeJavaSourceFolderPaths";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

