/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.AnimatedComponentSplitter;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidIcons;
import java.awt.Dimension;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MockupToggleAction
extends ToggleAction {
    public static final Dimension CLOSED_DIMENSION = new Dimension(0, 0);
    public static final Dimension OPEN_DIMENSION = new Dimension(200, 200);
    private final NlDesignSurface mySurface;
    private static final String SHOW_ACTION_TITLE = "Show Mockup Editor";
    private static final String HIDE_ACTION_TITLE = "Hide Mockup Editor";

    public MockupToggleAction(@NotNull NlDesignSurface surface) {
        if (surface == null) {
            MockupToggleAction.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(MockupToggleAction.getDesignIcon());
        presentation.setDescription(this.getDescription());
        this.getTemplatePresentation().setEnabledAndVisible(((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue());
    }

    @NotNull
    private String getDescription() {
        String string = this.mySurface.isCanvasResizing() ? HIDE_ACTION_TITLE : SHOW_ACTION_TITLE;
        if (string == null) {
            MockupToggleAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static Icon getDesignIcon() {
        return AndroidIcons.Mockup.Mockup;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            MockupToggleAction.$$$reportNull$$$0(2);
        }
        return this.mySurface.isMockupVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            MockupToggleAction.$$$reportNull$$$0(3);
        }
        this.getTemplatePresentation().setEnabled(state);
        this.mySurface.setMockupVisible(state);
        MockupEditor mockupEditor = this.mySurface.getMockupEditor();
        if (mockupEditor != null) {
            if (mockupEditor.getParent() instanceof AnimatedComponentSplitter) {
                mockupEditor.setMaximumSize(state ? OPEN_DIMENSION : CLOSED_DIMENSION);
                AnimatedComponentSplitter animatedComponentSplitter = (AnimatedComponentSplitter)((Object)mockupEditor.getParent());
                animatedComponentSplitter.showAnimateChild(mockupEditor, state);
                animatedComponentSplitter.setDividerMouseZoneSize(state ? 1 : 0);
                animatedComponentSplitter.setDividerWidth(state ? 1 : 0);
            } else {
                mockupEditor.setSize(this.mySurface.getWidth() / 3, this.mySurface.getHeight());
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            MockupToggleAction.$$$reportNull$$$0(4);
        }
        super.update(event);
        event.getPresentation().setIcon(MockupToggleAction.getDesignIcon());
        event.getPresentation().setDescription(this.getDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/MockupToggleAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/MockupToggleAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

