/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import com.intellij.compiler.notNullVerification.AuxiliaryMethodGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public class NotNullVerifyingInstrumenter
extends ClassVisitor
implements Opcodes {
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String ANNOTATION_DEFAULT_METHOD = "value";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final MethodData myMethodData;
    private String myClassName;
    private boolean myIsModification = false;
    private RuntimeException myPostponedError;
    private final AuxiliaryMethodGenerator myAuxGenerator;
    private final Set<String> myNotNullAnnotations = new HashSet<String>();
    private boolean myEnum;
    private boolean myInner;

    private NotNullVerifyingInstrumenter(ClassVisitor classVisitor, ClassReader reader, String[] notNullAnnotations) {
        super(458752, classVisitor);
        for (String annotation : notNullAnnotations) {
            this.myNotNullAnnotations.add('L' + annotation.replace('.', '/') + ';');
        }
        this.myMethodData = NotNullVerifyingInstrumenter.collectMethodData(reader, this.myNotNullAnnotations);
        this.myAuxGenerator = new AuxiliaryMethodGenerator(reader);
    }

    public static boolean processClassFile(FailSafeClassReader reader, ClassVisitor writer, String[] notNullAnnotations) {
        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter(writer, reader, notNullAnnotations);
        reader.accept(instrumenter, 0);
        return instrumenter.myIsModification;
    }

    private static MethodData collectMethodData(ClassReader reader, final Set<String> notNullAnnotations) {
        final MethodData result = new MethodData();
        reader.accept(new ClassVisitor(458752){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                result.setClassName(name);
            }

            public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
                final LinkedHashMap names = new LinkedHashMap();
                result.paramNames.put(MethodData.key(name, desc), names);
                Type[] args = Type.getArgumentTypes((String)desc);
                final boolean shouldRegisterNotNull = NotNullVerifyingInstrumenter.isReferenceType(Type.getReturnType((String)desc)) && (access & 0x1A) != 0;
                final LinkedHashMap<Integer, Integer> paramSlots = new LinkedHashMap<Integer, Integer>();
                int slotIndex = NotNullVerifyingInstrumenter.isStatic(access) ? 0 : 1;
                for (int paramIndex = 0; paramIndex < args.length; ++paramIndex) {
                    Type arg = args[paramIndex];
                    paramSlots.put(slotIndex, paramIndex);
                    slotIndex += arg.getSize();
                }
                return new MethodVisitor(this.api){

                    public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                        if (shouldRegisterNotNull && notNullAnnotations.contains(anno)) {
                            result.markNotNull(name, desc);
                        }
                        return super.visitAnnotation(anno, isRuntime);
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String anno, boolean visible) {
                        if (shouldRegisterNotNull && new TypeReference(typeRef).getSort() == 20 && notNullAnnotations.contains(anno)) {
                            result.markNotNull(name, desc);
                        }
                        return super.visitTypeAnnotation(typeRef, typePath, anno, visible);
                    }

                    public void visitLocalVariable(String name2, String desc2, String signature, Label start, Label end, int slotIndex) {
                        Integer paramIndex = (Integer)paramSlots.get(slotIndex);
                        if (paramIndex != null) {
                            names.put(paramIndex, name2);
                        }
                    }
                };
            }
        }, 4);
        return result;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
        this.myEnum = (access & 0x4000) != 0;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.myClassName.equals(name)) {
            this.myInner = (access & 8) == 0;
        }
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        if ((access & 0x40) != 0) {
            return new FailSafeMethodVisitor(458752, super.visitMethod(access, name, desc, signature, exceptions));
        }
        final boolean isStatic = NotNullVerifyingInstrumenter.isStatic(access);
        final Type[] args = Type.getArgumentTypes((String)desc);
        final int paramAnnotationOffset = !"<init>".equals(name) ? 0 : (this.myEnum ? 2 : (this.myInner ? 1 : 0));
        final Type returnType = Type.getReturnType((String)desc);
        final NotNullInstructionTracker instrTracker = new NotNullInstructionTracker(this.cv.visitMethod(access, name, desc, signature, exceptions));
        return new FailSafeMethodVisitor(458752, instrTracker){
            private final Map<Integer, NotNullState> myNotNullParams;
            private int myParamAnnotationOffset;
            private NotNullState myMethodNotNull;
            private Label myStartGeneratedCodeLabel;
            {
                super(api, mv);
                this.myNotNullParams = new LinkedHashMap<Integer, NotNullState>();
                this.myParamAnnotationOffset = paramAnnotationOffset;
            }

            private AnnotationVisitor collectNotNullArgs(AnnotationVisitor base, final NotNullState state) {
                return new AnnotationVisitor(458752, base){

                    public void visit(String methodName, Object o) {
                        if (NotNullVerifyingInstrumenter.ANNOTATION_DEFAULT_METHOD.equals(methodName) && !((String)o).isEmpty()) {
                            state.message = (String)o;
                        } else if ("exception".equals(methodName) && o instanceof Type && !((Type)o).getClassName().equals(Exception.class.getName())) {
                            state.exceptionType = ((Type)o).getInternalName();
                        }
                        super.visit(methodName, o);
                    }
                };
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                AnnotationVisitor base = this.mv.visitTypeAnnotation(typeRef, typePath, desc2, visible);
                if (typePath != null) {
                    return base;
                }
                TypeReference ref = new TypeReference(typeRef);
                if (ref.getSort() == 20) {
                    return this.checkNotNullMethod(desc2, base);
                }
                if (ref.getSort() == 22) {
                    return this.checkNotNullParameter(ref.getFormalParameterIndex() + paramAnnotationOffset, desc2, base);
                }
                return base;
            }

            public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                if (this.myParamAnnotationOffset != 0 && parameterCount == args.length) {
                    this.myParamAnnotationOffset = 0;
                }
                super.visitAnnotableParameterCount(parameterCount, visible);
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                AnnotationVisitor base = this.mv.visitParameterAnnotation(parameter, anno, visible);
                return this.checkNotNullParameter(parameter + this.myParamAnnotationOffset, anno, base);
            }

            private AnnotationVisitor checkNotNullParameter(int parameter, String anno, AnnotationVisitor av) {
                if (parameter >= 0 && parameter < args.length && NotNullVerifyingInstrumenter.isReferenceType(args[parameter]) && NotNullVerifyingInstrumenter.this.myNotNullAnnotations.contains(anno)) {
                    NotNullState state = new NotNullState(anno, NotNullVerifyingInstrumenter.IAE_CLASS_NAME);
                    this.myNotNullParams.put(parameter, state);
                    return this.collectNotNullArgs(av, state);
                }
                return av;
            }

            public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                return this.checkNotNullMethod(anno, this.mv.visitAnnotation(anno, isRuntime));
            }

            private AnnotationVisitor checkNotNullMethod(String anno, AnnotationVisitor base) {
                if (NotNullVerifyingInstrumenter.isReferenceType(returnType) && NotNullVerifyingInstrumenter.this.myNotNullAnnotations.contains(anno)) {
                    this.myMethodNotNull = new NotNullState(anno, NotNullVerifyingInstrumenter.ISE_CLASS_NAME);
                    return this.collectNotNullArgs(base, this.myMethodNotNull);
                }
                return base;
            }

            public void visitCode() {
                if (this.myNotNullParams.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                for (Map.Entry<Integer, NotNullState> entry : this.myNotNullParams.entrySet()) {
                    String[] stringArray;
                    Integer param = entry.getKey();
                    int var = isStatic ? 0 : 1;
                    for (int i = 0; i < param; ++i) {
                        var += args[i].getSize();
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    NotNullState state = entry.getValue();
                    String paramName = NotNullVerifyingInstrumenter.this.myMethodData.lookupParamName(name, desc, param);
                    String descrPattern = state.getNullParamMessage(paramName);
                    if (state.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = paramName != null ? paramName : String.valueOf(param - paramAnnotationOffset);
                        stringArray2[1] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[2] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(state.exceptionType, end, descrPattern, args2);
                }
            }

            public void visitLocalVariable(String name2, String desc2, String signature, Label start, Label end, int index) {
                boolean isParameterOrThisRef = isStatic ? index < args.length : index <= args.length;
                Label label = isParameterOrThisRef && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start;
                this.mv.visitLocalVariable(name2, desc2, signature, label, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && this.myMethodNotNull != null && instrTracker.canBeNull()) {
                    String[] stringArray;
                    this.mv.visitInsn(89);
                    Label skipLabel = new Label();
                    this.mv.visitJumpInsn(199, skipLabel);
                    String descrPattern = this.myMethodNotNull.getNullResultMessage();
                    if (this.myMethodNotNull.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[1] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(this.myMethodNotNull.exceptionType, skipLabel, descrPattern, args2);
                }
                this.mv.visitInsn(opcode);
            }

            private void reportError(String exceptionClass, Label end, String descrPattern, String[] args2) {
                NotNullVerifyingInstrumenter.this.myAuxGenerator.reportError(this.mv, NotNullVerifyingInstrumenter.this.myClassName, exceptionClass, descrPattern, args2);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
                NotNullVerifyingInstrumenter.this.processPostponedErrors();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                try {
                    super.visitMaxs(maxStack, maxLocals);
                }
                catch (Throwable e) {
                    NotNullVerifyingInstrumenter.this.registerError(name, "visitMaxs", e);
                }
            }
        };
    }

    public void visitEnd() {
        this.myAuxGenerator.generateReportingMethod(this.cv);
        super.visitEnd();
    }

    private static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    private void registerError(String methodName, String operationName, Throwable e) {
        if (this.myPostponedError == null) {
            Throwable err = e.getCause();
            if (err == null) {
                err = e;
            }
            StringBuilder message = new StringBuilder();
            message.append("Operation '").append(operationName).append("' failed for ").append(this.myClassName).append(".").append(methodName).append("(): ");
            String errMessage = err.getMessage();
            if (errMessage != null) {
                message.append(errMessage);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(out));
            message.append('\n').append(out.toString());
            this.myPostponedError = new RuntimeException(message.toString(), err);
        }
        if (this.myIsModification) {
            this.processPostponedErrors();
        }
    }

    private void processPostponedErrors() {
        RuntimeException error = this.myPostponedError;
        if (error != null) {
            throw error;
        }
    }

    private final class NotNullInstructionTracker
    extends MethodVisitor {
        private boolean myCanBeNull;

        NotNullInstructionTracker(MethodVisitor delegate) {
            super(458752, delegate);
            this.myCanBeNull = true;
        }

        public boolean canBeNull() {
            return this.myCanBeNull;
        }

        public void visitIntInsn(int opcode, int operand) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode, owner, name, descriptor);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            this.myCanBeNull = this.nextCanBeNullValue(186);
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object value) {
            this.myCanBeNull = this.nextCanBeNullValue(18);
            super.visitLdcInsn(value);
        }

        public void visitIincInsn(int var, int increment) {
            this.myCanBeNull = this.nextCanBeNullValue(132);
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.myCanBeNull = this.nextCanBeNullValue(170);
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.myCanBeNull = this.nextCanBeNullValue(171);
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            this.myCanBeNull = this.nextCanBeNullValue(197);
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
        }

        public void visitInsn(int opcode) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitInsn(opcode);
        }

        private boolean nextCanBeNullValue(int nextMethodCallOpcode, String owner, String name, String descriptor) {
            if (nextMethodCallOpcode == 183 && ("<init>".equals(name) || NotNullVerifyingInstrumenter.this.myMethodData.isAlwaysNotNull(owner, name, descriptor))) {
                return false;
            }
            return nextMethodCallOpcode != 184 && nextMethodCallOpcode != 182 || !NotNullVerifyingInstrumenter.this.myMethodData.isAlwaysNotNull(owner, name, descriptor);
        }

        private boolean nextCanBeNullValue(int nextOpcode) {
            if (nextOpcode == 18 || nextOpcode == 187 || nextOpcode == 189 || nextOpcode == 188 || nextOpcode == 197) {
                return false;
            }
            if (nextOpcode == 89 || nextOpcode == 90 || nextOpcode == 91 || nextOpcode == 92 || nextOpcode == 93 || nextOpcode == 94 || nextOpcode == 168 || nextOpcode == 167 || nextOpcode == 0 || nextOpcode == 169 || nextOpcode == 192) {
                return this.myCanBeNull;
            }
            return true;
        }
    }

    private static class NotNullState {
        String message;
        String exceptionType;
        final String notNullAnno;

        NotNullState(String notNullAnno, String exceptionType) {
            this.notNullAnno = notNullAnno;
            this.exceptionType = exceptionType;
        }

        String getNullParamMessage(String paramName) {
            if (this.message != null) {
                return this.message;
            }
            String shortName = this.getAnnoShortName();
            if (paramName != null) {
                return "Argument for @" + shortName + " parameter '%s' of %s.%s must not be null";
            }
            return "Argument %s for @" + shortName + " parameter of %s.%s must not be null";
        }

        String getNullResultMessage() {
            if (this.message != null) {
                return this.message;
            }
            String shortName = this.getAnnoShortName();
            return "@" + shortName + " method %s.%s must not return null";
        }

        private String getAnnoShortName() {
            String fullName = this.notNullAnno.substring(1, this.notNullAnno.length() - 1);
            return fullName.substring(fullName.lastIndexOf(47) + 1);
        }
    }

    private static final class MethodData {
        private String myClassName;
        final Map<String, Map<Integer, String>> paramNames = new LinkedHashMap<String, Map<Integer, String>>();
        final Set<String> alwaysNotNullMethods = new HashSet<String>();

        private MethodData() {
        }

        public void setClassName(String className) {
            this.myClassName = className;
        }

        static String key(String methodName, String desc) {
            return methodName + desc;
        }

        String lookupParamName(String methodName, String desc, Integer num) {
            Map<Integer, String> names = this.paramNames.get(MethodData.key(methodName, desc));
            return names != null ? names.get(num) : null;
        }

        void markNotNull(String methodName, String desc) {
            this.alwaysNotNullMethods.add(MethodData.key(methodName, desc));
        }

        boolean isAlwaysNotNull(String className, String methodName, String desc) {
            return this.myClassName.equals(className) && this.alwaysNotNullMethods.contains(MethodData.key(methodName, desc));
        }
    }
}

