/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="DefaultGradleProjectSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DefaultGradleProjectSettings
implements PersistentStateComponent<MyState> {
    private boolean myMigrated;
    private boolean myDelegatedBuild = true;
    @NotNull
    private TestRunner myTestRunner = TestRunner.GRADLE;

    @NotNull
    public TestRunner getTestRunner() {
        TestRunner testRunner = this.myTestRunner;
        if (testRunner == null) {
            DefaultGradleProjectSettings.$$$reportNull$$$0(0);
        }
        return testRunner;
    }

    void setTestRunner(@NotNull TestRunner testRunner) {
        if (testRunner == null) {
            DefaultGradleProjectSettings.$$$reportNull$$$0(1);
        }
        this.myTestRunner = testRunner;
    }

    public boolean isDelegatedBuild() {
        return this.myDelegatedBuild;
    }

    public void setDelegatedBuild(boolean delegatedBuild) {
        this.myDelegatedBuild = delegatedBuild;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    boolean isMigrated() {
        return this.myMigrated;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    void setMigrated(boolean migrated) {
        this.myMigrated = migrated;
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.delegatedBuild = this.myDelegatedBuild;
        state.testRunner = this.myTestRunner;
        state.isMigrated = this.myMigrated;
        return state;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            DefaultGradleProjectSettings.$$$reportNull$$$0(2);
        }
        if (!state.isMigrated) {
            this.migrateOldSettings();
        } else {
            this.myDelegatedBuild = state.delegatedBuild;
            this.myTestRunner = state.testRunner;
        }
        this.myMigrated = true;
    }

    private void migrateOldSettings() {
        GradleSystemRunningSettings oldAppSettings = GradleSystemRunningSettings.getInstance();
        this.myDelegatedBuild = oldAppSettings.isUseGradleAwareMake();
        GradleSystemRunningSettings.PreferredTestRunner oldTestRunner = oldAppSettings.getDefaultTestRunner();
        if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            this.myTestRunner = TestRunner.PLATFORM;
        } else if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER) {
            this.myTestRunner = TestRunner.GRADLE;
        } else if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST) {
            this.myTestRunner = TestRunner.CHOOSE_PER_TEST;
        }
    }

    @NotNull
    public static DefaultGradleProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            DefaultGradleProjectSettings.$$$reportNull$$$0(3);
        }
        DefaultGradleProjectSettings defaultGradleProjectSettings = (DefaultGradleProjectSettings)ServiceManager.getService((Project)project, DefaultGradleProjectSettings.class);
        if (defaultGradleProjectSettings == null) {
            DefaultGradleProjectSettings.$$$reportNull$$$0(4);
        }
        return defaultGradleProjectSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/DefaultGradleProjectSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunner";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/DefaultGradleProjectSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTestRunner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static class MyState {
        public TestRunner testRunner = TestRunner.PLATFORM;
        public boolean delegatedBuild;
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
        public boolean isMigrated;
    }
}

