/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DefaultGradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

public class GradleSettingsService {
    @NotNull
    private final Project myProject;

    public GradleSettingsService(@NotNull Project project) {
        if (project == null) {
            GradleSettingsService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean isDelegatedBuildEnabled(@NotNull String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        if (gradleProjectPath == null) {
            GradleSettingsService.$$$reportNull$$$0(1);
        }
        if ((projectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(gradleProjectPath)) == null) {
            return false;
        }
        if (projectSettings.getDelegatedBuild() == ThreeState.UNSURE) {
            return DefaultGradleProjectSettings.getInstance(this.myProject).isDelegatedBuild();
        }
        return projectSettings.getDelegatedBuild().toBoolean();
    }

    @NotNull
    public TestRunner getTestRunner(@NotNull String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        if (gradleProjectPath == null) {
            GradleSettingsService.$$$reportNull$$$0(2);
        }
        TestRunner testRunner = (projectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(gradleProjectPath)) == null || projectSettings.getTestRunner() == null ? DefaultGradleProjectSettings.getInstance(this.myProject).getTestRunner() : projectSettings.getTestRunner();
        if (testRunner == null) {
            GradleSettingsService.$$$reportNull$$$0(3);
        }
        return testRunner;
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Module module) {
        String projectPath;
        if (module == null) {
            GradleSettingsService.$$$reportNull$$$0(4);
        }
        if ((projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)) == null) {
            return false;
        }
        return GradleSettingsService.getInstance(module.getProject()).isDelegatedBuildEnabled(projectPath);
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Module module) {
        String projectPath;
        if (module == null) {
            GradleSettingsService.$$$reportNull$$$0(5);
        }
        if ((projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)) == null) {
            TestRunner testRunner = DefaultGradleProjectSettings.getInstance(module.getProject()).getTestRunner();
            if (testRunner == null) {
                GradleSettingsService.$$$reportNull$$$0(6);
            }
            return testRunner;
        }
        TestRunner testRunner = GradleSettingsService.getInstance(module.getProject()).getTestRunner(projectPath);
        if (testRunner == null) {
            GradleSettingsService.$$$reportNull$$$0(7);
        }
        return testRunner;
    }

    @NotNull
    public static GradleSettingsService getInstance(@NotNull Project project) {
        if (project == null) {
            GradleSettingsService.$$$reportNull$$$0(8);
        }
        GradleSettingsService gradleSettingsService = (GradleSettingsService)ServiceManager.getService((Project)project, GradleSettingsService.class);
        if (gradleSettingsService == null) {
            GradleSettingsService.$$$reportNull$$$0(9);
        }
        return gradleSettingsService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/GradleSettingsService";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/GradleSettingsService";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedBuildEnabled";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunner";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

