/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.RepositoryLibraryDefinition;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryDescription {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    public static final Icon DEFAULT_ICON = OpenapiIcons.RepositoryLibraryLogo;
    private static volatile Map<String, RepositoryLibraryDescription> ourStaticallyDefinedLibraries;
    private final String groupId;
    private final String artifactId;
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId, String artifactId, String libraryName) {
        this.groupId = groupId == null ? "" : groupId;
        this.artifactId = artifactId == null ? "" : artifactId;
        this.libraryName = libraryName == null ? "<unknown>" : libraryName;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@Nullable String groupId, @Nullable String artifactId) {
        if (ourStaticallyDefinedLibraries == null) {
            HashMap<String, RepositoryLibraryDescription> map = new HashMap<String, RepositoryLibraryDescription>();
            for (RepositoryLibraryDefinition def : (RepositoryLibraryDefinition[])RepositoryLibraryDefinition.EP_NAME.getExtensions()) {
                String id = def.groupId + ":" + def.artifactId;
                map.put(id, new RepositoryLibraryDescription(def.groupId, def.artifactId, def.name));
            }
            ourStaticallyDefinedLibraries = Collections.unmodifiableMap(Collections.synchronizedMap(map));
        }
        String id = groupId == null && artifactId == null ? "<unknown>" : groupId + ":" + artifactId;
        RepositoryLibraryDescription description = ourStaticallyDefinedLibraries.get(id);
        RepositoryLibraryDescription repositoryLibraryDescription = description != null ? description : new RepositoryLibraryDescription(groupId, artifactId, id);
        if (repositoryLibraryDescription == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(0);
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(1);
        }
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
        if (repositoryLibraryDescription == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(2);
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
        if (descriptor == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(3);
        }
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(descriptor.getGroupId(), descriptor.getArtifactId());
        if (repositoryLibraryDescription == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(4);
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.libraryName;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DEFAULT_ICON;
        if (icon == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE", true, ContainerUtil.emptyList());
    }

    public String getDisplayName(String version) {
        if (LatestVersionId.equals(version)) {
            version = LatestVersionDisplayName;
        } else if ("RELEASE".equals(version)) {
            version = ReleaseVersionDisplayName;
        }
        return this.getDisplayName() + (version == null ? "" : ":" + version);
    }

    public String getMavenCoordinates(String version) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescription";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

