/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LanguageLevelState;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelModuleExtensionImpl
extends ModuleExtension
implements LanguageLevelModuleExtension,
PersistentStateComponentWithModificationTracker<LanguageLevelState> {
    private static final Logger LOG = Logger.getInstance(LanguageLevelModuleExtensionImpl.class);
    private Module myModule;
    private final boolean myWritable;
    private final LanguageLevelModuleExtensionImpl mySource;
    private LanguageLevelState myState = new LanguageLevelState();

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    public static LanguageLevelModuleExtensionImpl getInstance(Module module) {
        return (LanguageLevelModuleExtensionImpl)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtensionImpl.class);
    }

    public LanguageLevelModuleExtensionImpl(Module module) {
        this.myModule = module;
        this.mySource = null;
        this.myWritable = false;
    }

    public LanguageLevelModuleExtensionImpl(LanguageLevelModuleExtensionImpl source, boolean writable) {
        this.myWritable = writable;
        this.myModule = source.myModule;
        this.mySource = source;
        this.myState.setLanguageLevel(source.getLanguageLevel());
    }

    @Override
    public void setLanguageLevel(LanguageLevel languageLevel) {
        if (this.myState.getLanguageLevel() == languageLevel) {
            return;
        }
        LOG.assertTrue(this.myWritable, (Object)"Writable model can be retrieved from writable ModifiableRootModel");
        this.myState.setLanguageLevel(languageLevel);
    }

    @Nullable
    public LanguageLevelState getState() {
        return this.myState;
    }

    public void loadState(@NotNull LanguageLevelState state) {
        if (state == null) {
            LanguageLevelModuleExtensionImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    public ModuleExtension getModifiableModel(boolean writable) {
        LanguageLevelModuleExtensionImpl languageLevelModuleExtensionImpl = new LanguageLevelModuleExtensionImpl(this, writable);
        if (languageLevelModuleExtensionImpl == null) {
            LanguageLevelModuleExtensionImpl.$$$reportNull$$$0(1);
        }
        return languageLevelModuleExtensionImpl;
    }

    public void commit() {
        if (this.isChanged()) {
            this.mySource.myState.setLanguageLevel(this.myState.getLanguageLevel());
            LanguageLevelProjectExtension.getInstance(this.myModule.getProject()).languageLevelsChanged();
        }
    }

    public boolean isChanged() {
        return this.mySource != null && !this.mySource.myState.equals((Object)this.myState);
    }

    public void dispose() {
        this.myModule = null;
        this.myState = null;
    }

    @Override
    @Nullable
    public LanguageLevel getLanguageLevel() {
        return this.myState.getLanguageLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/LanguageLevelModuleExtensionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/LanguageLevelModuleExtensionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

