/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.view.math.Math3DHelper;

class SpotShadowVertexCalculator {
    private SpotShadowVertexCalculator() {
    }

    public static float[] calculateLight(float radius, int points, float x, float y, float height) {
        float[] ret = new float[points * 3];
        for (int i = 0; i < points; ++i) {
            double angle = (double)(2 * i) * Math.PI / (double)points;
            ret[i * 3] = (float)Math.sin(angle) * radius + x;
            ret[i * 3 + 1] = (float)Math.cos(angle) * radius + y;
            ret[i * 3 + 2] = height;
        }
        return ret;
    }

    public static int getStripSize(int rays, int layers) {
        return 2 + rays + layers * 2 * (rays + 1);
    }

    public static int calculateShadow(float[] lightPoly, int lightPolyLength, float[] poly, int polyLength, int rays, int layers, float strength, float[] retstrips) {
        float[] shadowRegion = new float[lightPolyLength * polyLength * 2];
        float[] outline = new float[polyLength * 2];
        float[] umbra = new float[polyLength * lightPolyLength * 2];
        int umbraLength = 0;
        int k = 0;
        for (int j = 0; j < lightPolyLength; ++j) {
            int i;
            int m = 0;
            for (i = 0; i < polyLength; ++i) {
                float t = lightPoly[j * 3 + 2] - poly[i * 3 + 2];
                if (t == 0.0f) {
                    return 0;
                }
                t = lightPoly[j * 3 + 2] / t;
                float x = lightPoly[j * 3] - t * (lightPoly[j * 3] - poly[i * 3]);
                float y = lightPoly[j * 3 + 1] - t * (lightPoly[j * 3 + 1] - poly[i * 3 + 1]);
                shadowRegion[k * 2] = x;
                shadowRegion[k * 2 + 1] = y;
                outline[m * 2] = x;
                outline[m * 2 + 1] = y;
                ++k;
                ++m;
            }
            if (umbraLength == 0) {
                for (i = 0; i < polyLength * 2; ++i) {
                    umbra[i] = outline[i];
                }
                umbraLength = polyLength;
                continue;
            }
            if ((umbraLength = Math3DHelper.intersection(outline, polyLength, umbra, umbraLength)) == 0) break;
        }
        int shadowRegionLength = k;
        float[] penumbra = new float[k * 2];
        int penumbraLength = Math3DHelper.hull(shadowRegion, shadowRegionLength, penumbra);
        if (umbraLength < 3) {
            float[] p = new float[3];
            Math3DHelper.centroid3d(lightPoly, lightPolyLength, p);
            float[] centShadow = new float[polyLength * 2];
            for (int i = 0; i < polyLength; ++i) {
                float t = p[2] - poly[i * 3 + 2];
                if (t == 0.0f) {
                    return 0;
                }
                t = p[2] / t;
                float x = p[0] - t * (p[0] - poly[i * 3]);
                float y = p[1] - t * (p[1] - poly[i * 3 + 1]);
                centShadow[i * 2] = x;
                centShadow[i * 2 + 1] = y;
            }
            float[] c = new float[2];
            Math3DHelper.centroid2d(centShadow, polyLength, c);
            for (int i = 0; i < polyLength; ++i) {
                centShadow[i * 2] = (c[0] * 9.0f + centShadow[i * 2]) / 10.0f;
                centShadow[i * 2 + 1] = (c[1] * 9.0f + centShadow[i * 2 + 1]) / 10.0f;
            }
            umbra = centShadow;
            umbraLength = polyLength;
        }
        Math3DHelper.donutPie2(penumbra, penumbraLength, umbra, umbraLength, rays, layers, strength, retstrips);
        return 1;
    }
}

