/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Rect;
import android.view.ViewGroup;
import android.view.shadow.AmbientShadowBitmapGenerator;
import android.view.shadow.AmbientShadowConfig;
import android.view.shadow.SpotShadowBitmapGenerator;
import android.view.shadow.SpotShadowConfig;

public class HighQualityShadowPainter {
    private HighQualityShadowPainter() {
    }

    public static void paintRectShadow(ViewGroup parent, Outline outline, float elevation, Canvas canvas, float alpha, float densityDpi) {
        if (!HighQualityShadowPainter.validate(elevation, densityDpi)) {
            return;
        }
        int width = parent.getWidth() / 5;
        int height = parent.getHeight() / 5;
        Rect rectBound = new Rect();
        if (!outline.getRect(rectBound)) {
            return;
        }
        rectBound.left /= 5;
        rectBound.right /= 5;
        rectBound.top /= 5;
        rectBound.bottom /= 5;
        float[] poly = HighQualityShadowPainter.getPoly(rectBound, elevation / 5.0f);
        HighQualityShadowPainter.paintAmbientShadow(poly, canvas, width, height);
        HighQualityShadowPainter.paintSpotShadow(poly, rectBound, elevation / 5.0f, canvas, alpha, densityDpi, width, height);
    }

    private static boolean validate(float elevation, float densityDpi) {
        float scaledElevationPx = elevation / 5.0f;
        float scaledSpotLightHeightPx = 10.0f * (densityDpi / 160.0f);
        return !(scaledElevationPx > scaledSpotLightHeightPx);
    }

    private static void paintAmbientShadow(float[] polygon, Canvas canvas, int width, int height) {
        AmbientShadowConfig config = new AmbientShadowConfig.Builder().setSize(width, height).setPolygon(polygon).setEdgeScale(60.0f).setShadowBoundRatio(0.099999994f).setShadowStrength(1.0f).setRays(120).setLayers(1).build();
        AmbientShadowBitmapGenerator generator = new AmbientShadowBitmapGenerator(config);
        generator.populateShadow();
        if (!generator.isValid()) {
            return;
        }
        HighQualityShadowPainter.drawScaled(canvas, generator.getBitmap(), (int)generator.getTranslateX(), (int)generator.getTranslateY(), width, height);
    }

    private static void paintSpotShadow(float[] poly, Rect rectBound, float elevation, Canvas canvas, float alpha, float densityDpi, int width, int height) {
        float lightZHeightPx = 10.0f * (densityDpi / 160.0f);
        if (lightZHeightPx - elevation < 2.0f) {
            return;
        }
        float lightX = (rectBound.left + rectBound.right) / 2;
        float lightY = rectBound.top;
        SpotShadowConfig config = new SpotShadowConfig.Builder().setSize(width, height).setLayers(1).setRays(40).setLightCoord(lightX, lightY, lightZHeightPx).setLightRadius(10).setLightSourcePoints(4).setShadowStrength(0.3f).setPolygon(poly, 4).build();
        SpotShadowBitmapGenerator generator = new SpotShadowBitmapGenerator(config);
        generator.populateShadow();
        if (!generator.validate()) {
            return;
        }
        HighQualityShadowPainter.drawScaled(canvas, generator.getBitmap(), (int)generator.getTranslateX(), (int)generator.getTranslateY(), width, height);
    }

    private static void drawScaled(Canvas canvas, Bitmap bitmap, int translateX, int translateY, int width, int height) {
        Rect dest = new Rect();
        dest.left = -translateX * 5;
        dest.top = -translateY * 5;
        dest.right = width * 5 + dest.left;
        dest.bottom = height * 5 + dest.top;
        int save = canvas.save();
        canvas.drawBitmap(bitmap, null, dest, null);
        canvas.restoreToCount(save);
    }

    private static float[] getPoly(Rect rect, float elevation) {
        float[] poly = new float[12];
        poly[0] = poly[9] = (float)rect.left;
        poly[1] = poly[4] = (float)rect.top;
        poly[3] = poly[6] = (float)rect.right;
        poly[7] = poly[10] = (float)rect.bottom;
        poly[8] = poly[11] = elevation;
        poly[5] = poly[11];
        poly[2] = poly[11];
        return poly;
    }
}

