/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.LeakyTypefaceStorage;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.R;

public class TextAppearanceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final String mFamilyName;
    private final int mStyle;
    private final int mTextSize;
    private final ColorStateList mTextColor;
    private final ColorStateList mTextColorLink;
    private final Typeface mTypeface;

    public TextAppearanceSpan(Context context, int appearance) {
        this(context, appearance, -1);
    }

    public TextAppearanceSpan(Context context, int appearance, int colorList) {
        TypedArray a = context.obtainStyledAttributes(appearance, R.styleable.TextAppearance);
        ColorStateList textColor = a.getColorStateList(3);
        this.mTextColorLink = a.getColorStateList(6);
        this.mTextSize = a.getDimensionPixelSize(0, -1);
        this.mStyle = a.getInt(2, 0);
        this.mTypeface = !context.isRestricted() && context.canLoadUnsafeResources() ? a.getFont(12) : null;
        if (this.mTypeface != null) {
            this.mFamilyName = null;
        } else {
            String family = a.getString(12);
            if (family != null) {
                this.mFamilyName = family;
            } else {
                int tf = a.getInt(1, 0);
                switch (tf) {
                    case 1: {
                        this.mFamilyName = "sans";
                        break;
                    }
                    case 2: {
                        this.mFamilyName = "serif";
                        break;
                    }
                    case 3: {
                        this.mFamilyName = "monospace";
                        break;
                    }
                    default: {
                        this.mFamilyName = null;
                    }
                }
            }
        }
        a.recycle();
        if (colorList >= 0) {
            a = context.obtainStyledAttributes(16973829, R.styleable.Theme);
            textColor = a.getColorStateList(colorList);
            a.recycle();
        }
        this.mTextColor = textColor;
    }

    public TextAppearanceSpan(String family, int style2, int size, ColorStateList color2, ColorStateList linkColor) {
        this.mFamilyName = family;
        this.mStyle = style2;
        this.mTextSize = size;
        this.mTextColor = color2;
        this.mTextColorLink = linkColor;
        this.mTypeface = null;
    }

    public TextAppearanceSpan(Parcel src) {
        this.mFamilyName = src.readString();
        this.mStyle = src.readInt();
        this.mTextSize = src.readInt();
        this.mTextColor = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
        this.mTextColorLink = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
        this.mTypeface = LeakyTypefaceStorage.readTypefaceFromParcel(src);
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 17;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeString(this.mFamilyName);
        dest.writeInt(this.mStyle);
        dest.writeInt(this.mTextSize);
        if (this.mTextColor != null) {
            dest.writeInt(1);
            this.mTextColor.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mTextColorLink != null) {
            dest.writeInt(1);
            this.mTextColorLink.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        LeakyTypefaceStorage.writeTypefaceToParcel(this.mTypeface, dest);
    }

    public String getFamily() {
        return this.mFamilyName;
    }

    public ColorStateList getTextColor() {
        return this.mTextColor;
    }

    public ColorStateList getLinkTextColor() {
        return this.mTextColorLink;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public int getTextStyle() {
        return this.mStyle;
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        this.updateMeasureState(ds);
        if (this.mTextColor != null) {
            ds.setColor(this.mTextColor.getColorForState(ds.drawableState, 0));
        }
        if (this.mTextColorLink != null) {
            ds.linkColor = this.mTextColorLink.getColorForState(ds.drawableState, 0);
        }
    }

    @Override
    public void updateMeasureState(TextPaint ds) {
        Typeface styledTypeface;
        int style2 = 0;
        if (this.mTypeface != null) {
            style2 = this.mStyle;
            styledTypeface = Typeface.create(this.mTypeface, style2);
        } else if (this.mFamilyName != null || this.mStyle != 0) {
            Typeface tf = ds.getTypeface();
            if (tf != null) {
                style2 = tf.getStyle();
            }
            styledTypeface = this.mFamilyName != null ? Typeface.create(this.mFamilyName, style2) : (tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2 |= this.mStyle));
        } else {
            styledTypeface = null;
        }
        if (styledTypeface != null) {
            int fake = style2 & ~styledTypeface.getStyle();
            if ((fake & 1) != 0) {
                ds.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                ds.setTextSkewX(-0.25f);
            }
            ds.setTypeface(styledTypeface);
        }
        if (this.mTextSize > 0) {
            ds.setTextSize(this.mTextSize);
        }
    }
}

