/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.Context;
import android.databinding.tool.LibTypes;
import android.databinding.tool.reflection.CachedClass;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ModelAnalyzer {
    public static final String GENERATED_ANNOTATION = "javax.annotation.Generated";
    private static final String MAP_CLASS_NAME = "java.util.Map";
    private static final String STRING_CLASS_NAME = "java.lang.String";
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";
    private static final String VIEW_STUB_CLASS_NAME = "android.view.ViewStub";
    private List<ModelClass> mListTypes;
    private CachedClass mMapType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.loadClassErasure(ModelAnalyzer.MAP_CLASS_NAME);
        }
    };
    private CachedClass mStringType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.STRING_CLASS_NAME, null);
        }
    };
    private CachedClass mObjectType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.OBJECT_CLASS_NAME, null);
        }
    };
    private CachedClass mObservableType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.this.libTypes.getObservable(), null);
        }
    };
    private CachedClass mObservableListType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.loadClassErasure(ModelAnalyzer.this.libTypes.getObservableList());
        }
    };
    private CachedClass mObservableMapType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.loadClassErasure(ModelAnalyzer.this.libTypes.getObservableMap());
        }
    };
    private CachedClass mLiveDataType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.loadClassErasure(ModelAnalyzer.this.libTypes.getLiveData());
        }
    };
    private CachedClass mMutableLiveDataType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.loadClassErasure(ModelAnalyzer.this.libTypes.getMutableLiveData());
        }
    };
    private List<ModelClass> mObservableFieldTypes;
    private CachedClass mViewBindingType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.this.libTypes.getViewDataBinding(), null);
        }
    };
    private CachedClass mViewStubType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.VIEW_STUB_CLASS_NAME, null);
        }
    };
    private CachedClass mViewStubProxyType = new CachedClass(){

        @Override
        ModelClass find() {
            return ModelAnalyzer.this.findClass(ModelAnalyzer.this.libTypes.getViewStubProxy(), null);
        }
    };
    public final LibTypes libTypes;
    private Boolean mHasGeneratedAnnotation;
    private final Map<String, InjectedClass> mInjectedClasses = new HashMap<String, InjectedClass>();

    protected ModelAnalyzer(LibTypes libTypes) {
        this.libTypes = libTypes;
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2) {
        return this.findCommonParentOf(modelClass1, modelClass2, true);
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2, boolean failOnError) {
        ModelClass curr;
        for (curr = modelClass1; curr != null && !curr.isAssignableFrom(modelClass2); curr = curr.getSuperclass()) {
        }
        if (curr == null) {
            if (modelClass1.isObject() && modelClass2.isInterface()) {
                return modelClass1;
            }
            if (modelClass2.isObject() && modelClass1.isInterface()) {
                return modelClass2;
            }
            ModelClass primitive1 = modelClass1.unbox();
            ModelClass primitive2 = modelClass2.unbox();
            if (!modelClass1.equals(primitive1) || !modelClass2.equals(primitive2)) {
                return this.findCommonParentOf(primitive1, primitive2, failOnError);
            }
        }
        if (failOnError) {
            Preconditions.checkNotNull(curr, "must be able to find a common parent for " + modelClass1 + " and " + modelClass2, new Object[0]);
        }
        return curr;
    }

    public abstract ModelClass loadPrimitive(String var1);

    public static ModelAnalyzer getInstance() {
        return Context.getModelAnalyzer();
    }

    public String applyImports(String className, Map<String, String> imports) {
        String rest;
        String qualifier;
        int dotIndex;
        className = className.trim();
        int numDimensions = 0;
        String generic = null;
        while (className.endsWith("[]")) {
            ++numDimensions;
            className = className.substring(0, className.length() - 2);
        }
        int lastCharIndex = className.length() - 1;
        if ('>' == className.charAt(lastCharIndex)) {
            int open = className.indexOf(60);
            if (open == -1) {
                L.e("un-matching generic syntax for %s", className);
                return className;
            }
            generic = this.applyImports(className.substring(open + 1, lastCharIndex), imports);
            className = className.substring(0, open);
        }
        if ((dotIndex = className.indexOf(46)) == -1) {
            qualifier = className;
            rest = null;
        } else {
            qualifier = className.substring(0, dotIndex);
            rest = className.substring(dotIndex);
        }
        String expandedQualifier = imports.get(qualifier);
        String result = expandedQualifier != null ? (rest == null ? expandedQualifier : expandedQualifier + rest) : className;
        if (generic != null) {
            result = result + "<" + this.applyImports(generic, imports) + ">";
        }
        while (numDimensions-- > 0) {
            result = result + "[]";
        }
        return result;
    }

    public String getDefaultValue(String className) {
        if ("int".equals(className)) {
            return "0";
        }
        if ("short".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("float".equals(className)) {
            return "0f";
        }
        if ("double".equals(className)) {
            return "0.0";
        }
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("char".equals(className)) {
            return "'\\u0000'";
        }
        if ("byte".equals(className)) {
            return "0";
        }
        return "null";
    }

    public final ModelClass findClass(String className, Map<String, String> imports) {
        if (this.mInjectedClasses.containsKey(className)) {
            return this.mInjectedClasses.get(className);
        }
        return this.findClassInternal(className, imports);
    }

    public abstract ModelClass findClassInternal(String var1, Map<String, String> var2);

    public abstract ModelClass findClass(Class var1);

    public abstract TypeUtil createTypeUtil();

    public ModelClass injectClass(InjectedClass injectedClass) {
        this.mInjectedClasses.put(injectedClass.getCanonicalName(), injectedClass);
        return injectedClass;
    }

    List<ModelClass> getListTypes() {
        if (this.mListTypes == null) {
            this.mListTypes = this.libTypes.getListClassNames().stream().map(this::loadClassErasure).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.mListTypes;
    }

    public ModelClass getMapType() {
        return this.mMapType.get();
    }

    ModelClass getStringType() {
        return this.mStringType.get();
    }

    ModelClass getObjectType() {
        return this.mObjectType.get();
    }

    ModelClass getObservableType() {
        return this.mObservableType.get();
    }

    ModelClass getObservableListType() {
        return this.mObservableListType.get();
    }

    ModelClass getObservableMapType() {
        return this.mObservableMapType.get();
    }

    ModelClass getLiveDataType() {
        return this.mLiveDataType.get();
    }

    ModelClass getMutableLiveDataType() {
        return this.mMutableLiveDataType.get();
    }

    ModelClass getViewDataBindingType() {
        ModelClass result = this.mViewBindingType.get();
        Preconditions.checkNotNull(result, "Cannot find %s class. Something is wrong in the classpath, please submit a bug report", this.libTypes.getViewDataBinding());
        return result;
    }

    public ModelClass getViewStubProxyType() {
        return this.mViewStubProxyType.get();
    }

    protected List<ModelClass> getObservableFieldTypes() {
        if (this.mObservableFieldTypes == null) {
            this.mObservableFieldTypes = this.libTypes.getObservableFields().stream().map(this::loadClassErasure).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.mObservableFieldTypes;
    }

    ModelClass getViewStubType() {
        return this.mViewStubType.get();
    }

    private ModelClass loadClassErasure(String className) {
        ModelClass modelClass = this.findClass(className, null);
        if (modelClass == null) {
            return null;
        }
        return modelClass.erasure();
    }

    public final boolean hasGeneratedAnnotation() {
        if (this.mHasGeneratedAnnotation == null) {
            this.mHasGeneratedAnnotation = this.findGeneratedAnnotation();
        }
        return this.mHasGeneratedAnnotation;
    }

    protected abstract boolean findGeneratedAnnotation();
}

