/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_DUMP_TEMPLATE_VARS = Flag.create((FlagGroup)NPW, (String)"dump.template.vars", (String)"Dump template variables to a scratch file", (String)"Dump the variables used in creating a template to a scrach file that is opened after creating the project.", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_DYNAMIC_APPS = Flag.create((FlagGroup)NPW, (String)"dynamic.apps", (String)"New Dynamic App Project flow", (String)"Use new Dynamic App flow when creating a New Mobile Project", (boolean)true);
    public static final Flag<Boolean> NPW_USE_HOME_FOLDER_AS_EXTRA_TEMPLATE_ROOT_FOLDER = Flag.create((FlagGroup)NPW, (String)"home.template.root", (String)"Use .android folder as a Template Root Folder", (String)"Let the user keep templates in the .android folder such that they are kept after a Studio install/upgrade", (boolean)true);
    public static final Flag<Boolean> NPW_OFFLINE_REPO_CHECKBOX = Flag.create((FlagGroup)NPW, (String)"offline.repo.checkbox", (String)"Use offline repo shipped with Android Studio", (String)"Checkbox mark adds a path to shipped offline repo to local.properties and references it in build.gradle's dependencies", (boolean)false);
    public static final Flag<Boolean> NPW_NAVIGATION_SUPPORT = Flag.create((FlagGroup)NPW, (String)"navigation.support", (String)"Add a navigation support for each template", (String)"Add a option what type of Navigation is added in the created Activity in the selected template", (boolean)false);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_FRAGMENT_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"event.fragment", (String)"Enable fragment profiling", (String)"Shows fragment information in event profiler's activity bar and tooltip.", (boolean)true);
    public static final Flag<Boolean> PROFILER_SHOW_SESSIONS = Flag.create((FlagGroup)PROFILER, (String)"show.session", (String)"Enable the sessions panel", (String)"Shows the sessions panel used for managing and navigating profiling data.", (boolean)true);
    public static final Flag<Boolean> PROFILER_IMPORT_SESSION = Flag.create((FlagGroup)PROFILER, (String)"import.session", (String)"Enable the session import dialog", (String)"Shows the file open drop down menu for session import.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_IMPORT_CPU_TRACE = Flag.create((FlagGroup)PROFILER, (String)"cpu.import.trace", (String)"Enable CPU trace importing", (String)"Add the option to import CPU trace files when right-clicking the CPU profiler usage chart.", (boolean)true);
    public static final Flag<Boolean> PROFILER_EXPORT_CPU_TRACE = Flag.create((FlagGroup)PROFILER, (String)"cpu.export.trace", (String)"Enable CPU trace exporting", (String)"Add the option to export CPU trace files when right-clicking a CPU capture.", (boolean)true);
    public static final Flag<Boolean> PROFILER_OPEN_CAPTURES = Flag.create((FlagGroup)PROFILER, (String)"profiler.open.captures", (String)"Enable opening .trace and .hprof files", (String)"Allow opening .hprof and .trace files (e.g. File -> Open; via Drag & Drop) which imports them into Android Profiler.", (boolean)true);
    public static final Flag<Boolean> PROFILER_STARTUP_CPU_PROFILING = Flag.create((FlagGroup)PROFILER, (String)"startup.cpu.profiling", (String)"Enable startup CPU Profiling", (String)"Record a method trace on startup by enabling it in the Profiler tab of Run/Debug configuration.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CPU_API_TRACING = Flag.create((FlagGroup)PROFILER, (String)"cpu.api.tracing", (String)"Enable CPU API Tracing", (String)"Support method tracing through APIs from android.os.Debug.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_CAPTURE_FILTER = Flag.create((FlagGroup)PROFILER, (String)"memory.capture.filter", (String)"Enable Memory Capture Filter", (String)"Show a text input field in the Memory profiler that is used to filter class names.", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"livealloc", (String)"Enable JVMTI-based live allocation tracking", (String)"For Android O or newer, allocations are tracked all the time while inside the Memory Profiler.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_SNAPSHOT = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.snapshot", (String)"Enable Memory Class Histogram Display", (String)"For Android O or newer, supports single-point selection which shows a snapshot of the heap at the specific time.", (boolean)true);
    public static final Flag<Boolean> PROFILER_SAMPLE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.sampled", (String)"Enable Sampled Live Allocation Tracking", (String)"For Android O or newer, allows users to configure the sampling mode of live allocation tracking", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_ATRACE = Flag.create((FlagGroup)PROFILER, (String)"atrace", (String)"Show the atrace option in CPU profiler", (String)"Toggles if atrace is a valid option to choose from the CPU profiling dropdown.", (boolean)true);
    public static final Flag<Boolean> PROFILER_TRACK_JNI_REFS = Flag.create((FlagGroup)PROFILER, (String)"jni", (String)"Enable JVMTI-based JNI reference tracking.", (String)"For Android O or newer, JNI references are tracked in Memory Profiler and shown in JNI heap.", (boolean)true);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_CPU_NEW_RECORDING_WORKFLOW = Flag.create((FlagGroup)PROFILER, (String)"cpu.new.recording.workflow", (String)"Enable new CPU recording workflow", (String)"Shows recording options and status of the ongoing recording in the method trace pane.", (boolean)false);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ANIMATIONS = Flag.create((FlagGroup)NELE, (String)"animated.motion.layout", (String)"Show preview animations toolbar for MotionLayout", (String)"Show an animations bar that allows playback of MotionLayout animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"animated.motion.editor", (String)"Show motion editor for MotionLayout", (String)"Show the motion editor UI for MotionLayout.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)true);
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR = Flag.create((FlagGroup)NELE, (String)"mockup.editor", (String)"Enable the Mockup Editor", (String)"Enable the Mockup Editor to ease the creation of Layouts from a design file.", (boolean)false);
    public static final Flag<Boolean> NELE_DEFAULT_LIVE_RENDER = Flag.create((FlagGroup)NELE, (String)"live.render", (String)"Enable the Live Render by default", (String)"Enable the continuous rendering of the surface when moving/resizing components unless the user disables it.", (boolean)true);
    public static final Flag<Boolean> NELE_SAMPLE_DATA_UI = Flag.create((FlagGroup)NELE, (String)"widget.assistant", (String)"Enable the new Sample Data UI components", (String)"Enable the Sample Data UI to setup tools attributes.", (boolean)true);
    public static final Flag<Boolean> NELE_CONVERT_VIEW = Flag.create((FlagGroup)NELE, (String)"convert.view", (String)"Enable the Convert View Action", (String)"Enable the Convert View Action when right clicking on a component", (boolean)true);
    public static final Flag<Boolean> ENABLE_NEW_SCOUT = Flag.create((FlagGroup)NELE, (String)"exp.scout.engine", (String)"Experimental version of the Scout inference system", (String)"Enable experimental version of the Scout inference system", (boolean)false);
    public static final Flag<Boolean> NELE_USE_ANDROIDX_DEFAULT = Flag.create((FlagGroup)NELE, (String)"androidx.default", (String)"Use androidx. support lib by default", (String)"Enable the use of androidx dependencies by default when the old support library is not present", (boolean)true);
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
    public static final Flag<Boolean> NELE_SHOW_ON_HOVER = Flag.create((FlagGroup)NELE, (String)"design.surface.show.hover", (String)"Enable show on hover for the design surface", (String)"If enabled, the design surface will only display additional overlays (like constraints) if the mouse is over the layout", (boolean)false);
    private static final FlagGroup ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"connection.enabled", (String)"Enable the connection assistant", (String)"If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", (boolean)true);
    public static final Flag<Boolean> WHATS_NEW_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"whats.new.enabled", (String)"Enable the \"What's New\" assistant", (String)"If enabled, user can access the \"What's New\" assistant under \"Help\" and \"What's New in Android Studio\"", (boolean)true);
    public static final Flag<Boolean> WHATS_NEW_ASSISTANT_AUTO_SHOW = Flag.create((FlagGroup)ASSISTANT, (String)"whats.new.auto.show", (String)"Displays the \"What's New\" assistant on first start", (String)"If enabled, the \"What's New\" assistant will be displayed the first time user opens a new version of Android Studio.", (boolean)true);
    public static final Flag<Boolean> NELE_NEW_PROPERTY_PANEL = Flag.create((FlagGroup)NELE, (String)"new.property", (String)"Enable the new Property Panel", (String)"Enable the new Property Panel", (boolean)false);
    public static final Flag<Boolean> NELE_NEW_COLOR_PICKER = Flag.create((FlagGroup)NELE, (String)"new.color.picker", (String)"New Color Picker", (String)"Enable new Color Picker in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)false);
    public static final Flag<Boolean> NELE_RENDER_HIGH_QUALITY_SHADOW = Flag.create((FlagGroup)NELE, (String)"high.quality.shadow", (String)"Enable the high quality shadows", (String)"Enable the high quality shadow rendering in Layout Editor", (boolean)false);
    public static final Flag<Boolean> NELE_ENABLE_SHADOW = Flag.create((FlagGroup)NELE, (String)"enable.shadow", (String)"Enable shadows", (String)"Enable the shadow rendering in Layout Editor", (boolean)false);
    private static final FlagGroup RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)true);
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)"If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.visible", (String)"Show the Select Device/Snapshot combo box", (String)"Show the Select Device/Snapshot combo box next to the Select Run/Debug Configuration one in the toolbar", (boolean)false);
    public static final Flag<Boolean> JVMTI_REFRESH = Flag.create((FlagGroup)RUNDEBUG, (String)"jvmti.refresh", (String)"Application refresh with JVMTI", (String)"Use JVMTI to support application refresh. This implies incremental deployment", (boolean)false);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
    public static final Flag<Boolean> GRADLE_INVOCATIONS_INDEXING_AWARE = Flag.create((FlagGroup)GRADLE_IDE, (String)"indexing.aware", (String)"Execute gradle actions in indexing-aware mode", (String)"Make Gradle actions and IDE indexing mutually exclusive to allow better utilisation of machine resources.", (boolean)true);
    public static final Flag<Boolean> NEW_SYNC_INFRA_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.sync", (String)"Enable \"New Sync\" infrastructure", (String)"Turns on the new infrastructure for \"Gradle Sync\", resulting in faster Sync executions.", (boolean)false);
    public static final Flag<Boolean> NEW_PSD_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.psd", (String)"Enable new \"Project Structure\" dialog", (String)"Turns on the new \"Project Structure\" dialog.", (boolean)false);
    public static final Flag<Boolean> SINGLE_VARIANT_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"single.variant.sync", (String)"Enable new \"Single-Variant Sync\"", (String)"Turns on Single-Variant Sync.", (boolean)false);
    public static final Flag<Boolean> COMPOUND_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"compound.sync", (String)"Enable new \"Compound Sync\"", (String)"Turns on Compound Sync.", (boolean)false);
    public static final Flag<Boolean> SHIPPED_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"shipped.sync", (String)"Enable \"Shipped Sync\"", (String)"Use shipped Gradle Sync when possible e.g. in freshly created projects. Allows to avoid running an actual Gradle Sync.", (boolean)false);
    public static final Flag<Boolean> L4_DEPENDENCY_MODEL = Flag.create((FlagGroup)GRADLE_IDE, (String)"level4.dependency.model", (String)"Use L4 DependencyGraph Model", (String)"Use level4 DependencyGraph model.", (boolean)false);
    private static final FlagGroup SQLITE_VIEWER = new FlagGroup(FLAGS, "sqlite.viewer", "SQLite Viewer");
    public static final Flag<Boolean> SQLITE_VIEWER_ENABLED = Flag.create((FlagGroup)SQLITE_VIEWER, (String)"enabled", (String)"Enable the SQLite database viewer", (String)"If enabled, SQLite files downloaded from Android devices or emulators are open in a custom SQLite editor window", (boolean)false);
    private static final FlagGroup RESOURCES_MANAGEMENT = new FlagGroup(FLAGS, "res.manag", "Resource Management");
    public static final Flag<Boolean> RESOURCE_MANAGER_ENABLED = Flag.create((FlagGroup)RESOURCES_MANAGEMENT, (String)"enabled", (String)"Enable the new resources management tools", (String)"If enabled, the new resource management tools are enabled. Subflags will also need to be enabled to enable all available new tools", (boolean)false);
    private static final FlagGroup LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
    public static final Flag<Boolean> LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"load.overlay", (String)"Enable the Load Overlay feature", (String)"If enabled, Show actions to let user choose overlay image on preview.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_SUB_VIEW_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"sub.view", (String)"Enable the sub view feature", (String)"If enabled, changes the preview to focus on a component.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"capture.v2", (String)"Enable using V2 protocol to capture view data", (String)"If enabled, uses V2 protocol to capture view information from device.", (boolean)false);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"ui.editing", (String)"Enable editing ViewNode properties in the properties table.", (String)"If enabled, users can edit properties in the properties table.", (boolean)false);
    private static final FlagGroup REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
    public static final Flag<Boolean> MIGRATE_TO_APPCOMPAT_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.appcompat.enabled", (String)"Enable the Migrate to AppCompat refactoring feature", (String)"If enabled, show the action in the refactoring menu", (boolean)true);
    public static final Flag<Boolean> MIGRATE_TO_ANDROID_X_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.androidx.enabled", (String)"Enable the Migrate to AndroidX refactoring feature", (String)"If enabled, show the action in the refactoring menu", (boolean)true);
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring feature", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    private static final FlagGroup IOT = new FlagGroup(FLAGS, "iot", "IoT features");
    public static final Flag<Boolean> UNINSTALL_LAUNCHER_APPS_ENABLED = Flag.create((FlagGroup)IOT, (String)"iot.uninstalllauncherapps.enabled", (String)"Enable the Uninstall of IoT launcher apps feature", (String)"If enabled, uninstall IoT launcher apps when installing a new one", (boolean)false);
    private static final FlagGroup NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
    public static final Flag<Boolean> LLDB_ASSEMBLY_DEBUGGING = Flag.create((FlagGroup)NDK, (String)"debugging.assembly", (String)"Enable assembly debugging", (String)"If enabled, frames without sources will show the assembly of the function and allow breakpoints to be set there", (boolean)false);
    public static final Flag<Boolean> ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT = Flag.create((FlagGroup)NDK, (String)"enhancednativeheadersupport", (String)"Enable enhanced native header support", (String)"If enabled, project system view will show a new include node with organized header files", (boolean)true);
    public static final Flag<Boolean> ENABLE_CLANG_TIDY_INSPECTIONS = Flag.create((FlagGroup)NDK, (String)"clangtidyinspections", (String)"Enable clang-tidy inspections", (String)"If enabled, show inspections derived from clang-tidy.", (boolean)true);
    private static final FlagGroup EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
    public static final Flag<Boolean> IN_MEMORY_R_CLASSES = Flag.create((FlagGroup)EDITOR, (String)"in.memory.r.classes", (String)"Generate R classes fully in memory", (String)"If enabled, R classes are generated in memory", (boolean)true);
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
    public static final Flag<Boolean> RESOLVE_USING_REPOS = Flag.create((FlagGroup)EDITOR, (String)"resolve.using.repos", (String)"Resolve references using resource repositories", (String)"Use ResourceRepository to resolve references, not ResourceManager.", (boolean)false);
    private static final FlagGroup ANALYZER = new FlagGroup(FLAGS, "analyzer", "Apk/Bundle Analyzer");
    public static final Flag<Boolean> ENABLE_APP_SIZE_OPTIMIZER = Flag.create((FlagGroup)ANALYZER, (String)"enable.app.size.optimizer", (String)"Enable size optimization suggestions in apk analyzer", (String)"If enabled, it will enable the apk analyzer tool to display suggestions for reducing application size", (boolean)false);
    private static final FlagGroup UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
    public static final Flag<Boolean> UAB_HIDE_INSTANT_MODULES_FOR_NON_FEATURE_PLUGIN_PROJECTS = Flag.create((FlagGroup)UAB, (String)"hide.instant.modules", (String)"Hide Instant Modules for non-feature plugin Project", (String)"If a user is working on an older instant app project, they will be able to create instant modules. Otherwise the option won't be available", (boolean)true);
    public static final Flag<Boolean> UAB_INSTANT_DYNAMIC_FEATURE_MODULE = Flag.create((FlagGroup)UAB, (String)"instant.dynamic.feature.modules", (String)"Enable Instant Dynamic Feature Template", (String)"If enabled, the new module wizard will include the template for instant dynamic feature modules", (boolean)true);
    public static final Flag<Boolean> UAB_NEW_PROJECT_INSTANT_APP_IS_DYNAMIC_APP = Flag.create((FlagGroup)UAB, (String)"dynamic.instant.app", (String)"When Instant is checked, only create app module with dist:module in manifest", (String)"If enabled, when the user checks the instant checkbox when creating a new project, then a project with only an app module and with dist:module in the manifest", (boolean)true);
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
    private static final FlagGroup THEME_EDITOR = new FlagGroup(FLAGS, "theme.editor", "Theme Editor");
    public static final Flag<Boolean> THEME_EDITOR_ENABLED = Flag.create((FlagGroup)THEME_EDITOR, (String)"theme.editor.enabled", (String)"Enable the theme editor", (String)"If enabled, a visual editor will be available for Android themes.", (boolean)false);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        Flags flags = new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides()});
        if (flags == null) {
            StudioFlags.$$$reportNull$$$0(0);
        }
        return flags;
    }

    private StudioFlags() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/flags/StudioFlags", "createFlags"));
    }
}

