/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrent;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FutureCallbackExecutor
implements Executor {
    @NotNull
    private final Executor myExecutor;

    public FutureCallbackExecutor(@NotNull Executor executor) {
        if (executor == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(0);
        }
        this.myExecutor = executor;
    }

    public static FutureCallbackExecutor wrap(@NotNull Executor executor) {
        if (executor == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(1);
        }
        if (executor instanceof FutureCallbackExecutor) {
            return (FutureCallbackExecutor)executor;
        }
        return new FutureCallbackExecutor(executor);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(2);
        }
        this.myExecutor.execute(command);
    }

    @NotNull
    public <V> ListenableFuture<V> executeAsync(@NotNull Callable<V> function) {
        if (function == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(3);
        }
        SettableFuture futureResult = SettableFuture.create();
        this.myExecutor.execute(() -> {
            try {
                futureResult.set(function.call());
            }
            catch (Throwable t) {
                futureResult.setException(t);
            }
        });
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(4);
        }
        return settableFuture;
    }

    public <V> void addCallback(@NotNull ListenableFuture<V> future, @NotNull FutureCallback<? super V> callback) {
        if (future == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(6);
        }
        Futures.addCallback(future, callback, (Executor)this);
    }

    public <V> void addConsumer(@NotNull ListenableFuture<V> future, final @NotNull BiConsumer<? super V, Throwable> consumer) {
        if (future == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(8);
        }
        this.addCallback(future, new FutureCallback<V>(){

            public void onSuccess(@Nullable V result) {
                consumer.accept(result, null);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumer.accept(null, t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/concurrent/FutureCallbackExecutor$1", "onFailure"));
            }
        });
    }

    public <V> void addListener(@NotNull ListenableFuture<V> future, @NotNull Runnable listener) {
        if (future == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(9);
        }
        if (listener == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(10);
        }
        future.addListener(listener, this.myExecutor);
    }

    @NotNull
    public <I, O> ListenableFuture<O> transform(@NotNull ListenableFuture<I> input, @NotNull ThrowableFunction<? super I, ? extends O> function) {
        if (input == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(11);
        }
        if (function == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(12);
        }
        ListenableFuture listenableFuture = Futures.transform(input, FutureCallbackExecutor.wrapThrowableFunction(function)::apply, (Executor)this.myExecutor);
        if (listenableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(13);
        }
        return listenableFuture;
    }

    @NotNull
    public <I, O> ListenableFuture<O> transformAsync(@NotNull ListenableFuture<I> input, @NotNull AsyncFunction<? super I, ? extends O> function) {
        if (input == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(14);
        }
        if (function == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(15);
        }
        ListenableFuture listenableFuture = Futures.transformAsync(input, function, (Executor)this.myExecutor);
        if (listenableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(16);
        }
        return listenableFuture;
    }

    @NotNull
    public <V, X extends Throwable> ListenableFuture<V> catching(@NotNull ListenableFuture<? extends V> input, Class<X> exceptionType, @NotNull ThrowableFunction<? super X, ? extends V> fallback) {
        if (input == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(17);
        }
        if (fallback == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(18);
        }
        ListenableFuture listenableFuture = Futures.catching(input, exceptionType, FutureCallbackExecutor.wrapThrowableFunction(fallback)::apply, (Executor)this);
        if (listenableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(19);
        }
        return listenableFuture;
    }

    @NotNull
    public <V, X extends Throwable> ListenableFuture<V> catchingAsync(@NotNull ListenableFuture<? extends V> input, Class<X> exceptionType, @NotNull AsyncFunction<? super X, ? extends V> fallback) {
        if (input == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(20);
        }
        if (fallback == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(21);
        }
        ListenableFuture listenableFuture = Futures.catchingAsync(input, exceptionType, fallback, (Executor)this);
        if (listenableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(22);
        }
        return listenableFuture;
    }

    @NotNull
    public <I> ListenableFuture<I> finallyAsync(@NotNull ListenableFuture<I> input, @NotNull Callable<ListenableFuture<Void>> finallyBlock) {
        if (input == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(23);
        }
        if (finallyBlock == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(24);
        }
        SettableFuture futureResult = SettableFuture.create();
        this.addConsumer(input, (i, futureThrowable) -> {
            try {
                ListenableFuture futureFinallyBlock = (ListenableFuture)finallyBlock.call();
                this.addConsumer(futureFinallyBlock, (aVoid, finallyError) -> {
                    if (futureThrowable != null) {
                        futureResult.setException(futureThrowable);
                    } else if (finallyError != null) {
                        futureResult.setException(finallyError);
                    } else {
                        futureResult.set(i);
                    }
                });
            }
            catch (Throwable t) {
                if (futureThrowable != null) {
                    futureResult.setException(futureThrowable);
                }
                futureResult.setException(t);
            }
        });
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(25);
        }
        return settableFuture;
    }

    @NotNull
    public <T> ListenableFuture<Void> executeFuturesInSequence(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Void>> taskFactory) {
        if (iterator == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(26);
        }
        if (taskFactory == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(27);
        }
        SettableFuture finalResult = SettableFuture.create();
        this.executeFuturesInSequenceWorker(iterator, taskFactory, (SettableFuture<Void>)finalResult);
        SettableFuture settableFuture = finalResult;
        if (settableFuture == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(28);
        }
        return settableFuture;
    }

    private <T> void executeFuturesInSequenceWorker(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Void>> taskFactory, @NotNull SettableFuture<Void> finalResult) {
        if (iterator == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(29);
        }
        if (taskFactory == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(30);
        }
        if (finalResult == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(31);
        }
        if (iterator.hasNext()) {
            ListenableFuture<Void> future = taskFactory.apply(iterator.next());
            this.addConsumer(future, (aVoid, throwable) -> this.executeFuturesInSequenceWorker(iterator, taskFactory, finalResult));
        } else {
            finalResult.set(null);
        }
    }

    @NotNull
    private static <I, O> Function<I, O> wrapThrowableFunction(@NotNull ThrowableFunction<I, O> function) {
        if (function == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(32);
        }
        Function<Object, Object> function2 = input -> {
            try {
                return function.apply(input);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        };
        if (function2 == null) {
            FutureCallbackExecutor.$$$reportNull$$$0(33);
        }
        return function2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/concurrent/FutureCallbackExecutor";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFactory";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/concurrent/FutureCallbackExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAsync";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "transformAsync";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "catching";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "catchingAsync";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "finallyAsync";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "executeFuturesInSequence";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapThrowableFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeAsync";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCallback";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConsumer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "transformAsync";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "catching";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "catchingAsync";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "finallyAsync";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "executeFuturesInSequence";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "executeFuturesInSequenceWorker";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapThrowableFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

