/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class VariableDescriptorWithInitializerImpl
extends VariableDescriptorImpl {
    private final boolean isVar;
    protected NullableLazyValue<ConstantValue<?>> compileTimeInitializer;

    public VariableDescriptorWithInitializerImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @Nullable KotlinType outType, boolean isVar, @NotNull SourceElement source) {
        super(containingDeclaration, annotations2, name, outType, source);
        this.isVar = isVar;
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    @Nullable
    public ConstantValue<?> getCompileTimeInitializer() {
        if (this.compileTimeInitializer != null) {
            return (ConstantValue)this.compileTimeInitializer.invoke();
        }
        return null;
    }

    public void setCompileTimeInitializer(@NotNull NullableLazyValue<ConstantValue<?>> compileTimeInitializer) {
        assert (!this.isVar()) : "Constant value for variable initializer should be recorded only for final variables: " + this.getName();
        this.compileTimeInitializer = compileTimeInitializer;
    }
}

