/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBreakStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiLabelReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBreakStatementImpl");

    public PsiBreakStatementImpl() {
        super(BREAK_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findChildByRoleAsPsiElement(83);
    }

    @Override
    public PsiStatement findExitedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label == null) {
            for (ASTNode parent2 = this.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
                IElementType i = parent2.getElementType();
                if (i == FOR_STATEMENT || i == WHILE_STATEMENT || i == DO_WHILE_STATEMENT || i == SWITCH_STATEMENT || i == FOREACH_STATEMENT) {
                    return (PsiStatement)SourceTreeToPsiMap.treeElementToPsi(parent2);
                }
                if (i != METHOD && i != CLASS_INITIALIZER) continue;
                return null;
            }
        } else {
            String labelName = label.getText();
            for (CompositeElement parent3 = this.getTreeParent(); parent3 != null; parent3 = parent3.getTreeParent()) {
                ASTNode statementLabel;
                if (parent3.getElementType() == LABELED_STATEMENT && (statementLabel = parent3.findChildByRole(93)).getText().equals(labelName)) {
                    return ((PsiLabeledStatement)SourceTreeToPsiMap.treeElementToPsi(parent3)).getStatement();
                }
                if (parent3.getElementType() != METHOD && parent3.getElementType() != CLASS_INITIALIZER && parent3.getElementType() != LAMBDA_EXPRESSION) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 81: {
                return this.findChildByType(BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(IDENTIFIER);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiBreakStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == BREAK_KEYWORD) {
            return 81;
        }
        if (i == IDENTIFIER) {
            return 83;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiBreakStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBreakStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references != null && references.length > 0) {
            return references[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        if (this.getLabelIdentifier() == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PsiBreakStatementImpl.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiLabelReference(this, this.getLabelIdentifier())};
        if (psiReferenceArray == null) {
            PsiBreakStatementImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    @Override
    public String toString() {
        return "PsiBreakStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

