/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.resources.TextResource;

public class PmdExtension
extends CodeQualityExtension {
    private final Project project;
    private List<String> ruleSets;
    private TargetJdk targetJdk;
    private int rulePriority = 5;
    private TextResource ruleSetConfig;
    private ConfigurableFileCollection ruleSetFiles;
    private boolean consoleOutput;

    public PmdExtension(Project project) {
        this.project = project;
    }

    public List<String> getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(List<String> ruleSets) {
        this.ruleSets = ruleSets;
    }

    public void ruleSets(String ... ruleSets) {
        this.ruleSets.addAll(Arrays.asList(ruleSets));
    }

    public TargetJdk getTargetJdk() {
        return this.targetJdk;
    }

    public void setTargetJdk(TargetJdk targetJdk) {
        this.targetJdk = targetJdk;
    }

    public void setTargetJdk(Object value) {
        this.targetJdk = TargetJdk.toVersion(value);
    }

    public int getRulePriority() {
        return this.rulePriority;
    }

    public void setRulePriority(int intValue) {
        Pmd.validate(intValue);
        this.rulePriority = intValue;
    }

    @Nullable
    public TextResource getRuleSetConfig() {
        return this.ruleSetConfig;
    }

    public void setRuleSetConfig(@Nullable TextResource ruleSetConfig) {
        this.ruleSetConfig = ruleSetConfig;
    }

    public FileCollection getRuleSetFiles() {
        return this.ruleSetFiles;
    }

    public void setRuleSetFiles(FileCollection ruleSetFiles) {
        this.ruleSetFiles = this.project.getLayout().configurableFiles(new Object[]{ruleSetFiles});
    }

    public void ruleSetFiles(Object ... ruleSetFiles) {
        this.ruleSetFiles.from(ruleSetFiles);
    }

    public boolean isConsoleOutput() {
        return this.consoleOutput;
    }

    public void setConsoleOutput(boolean consoleOutput) {
        this.consoleOutput = consoleOutput;
    }
}

