/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependenciesInternal;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.CachingTransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.SummarizingChangeContainer;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.CacheHandler;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.AbstractFingerprintChanges;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.OutputFileCollectionFingerprinter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.util.GFileUtils;

public class DefaultTransformerInvoker
implements TransformerInvoker {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final WorkExecutor<UpToDateResult> workExecutor;
    private final ArtifactTransformListener artifactTransformListener;
    private final CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider;
    private final FileCollectionFingerprinter dependencyFingerprinter;
    private final OutputFileCollectionFingerprinter outputFingerprinter;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ProjectFinder projectFinder;
    private final boolean useTransformationWorkspaces;

    public DefaultTransformerInvoker(WorkExecutor<UpToDateResult> workExecutor, FileSystemSnapshotter fileSystemSnapshotter, ArtifactTransformListener artifactTransformListener, CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider, FileCollectionFingerprinter dependencyFingerprinter, OutputFileCollectionFingerprinter outputFileCollectionFingerprinter, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ProjectFinder projectFinder, boolean useTransformationWorkspaces) {
        this.workExecutor = workExecutor;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableTransformationWorkspaceProvider = immutableTransformationWorkspaceProvider;
        this.dependencyFingerprinter = dependencyFingerprinter;
        this.outputFingerprinter = outputFileCollectionFingerprinter;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.projectFinder = projectFinder;
        this.useTransformationWorkspaces = useTransformationWorkspaces;
    }

    @Override
    public Try<ImmutableList<File>> invoke(Transformer transformer, File primaryInput, ArtifactTransformDependenciesInternal dependencies, TransformationSubject subject) {
        CurrentFileCollectionFingerprint dependenciesFingerprint = dependencies.fingerprint(this.dependencyFingerprinter);
        ProjectInternal producerProject = this.determineProducerProject(subject);
        CachingTransformationWorkspaceProvider workspaceProvider = this.determineWorkspaceProvider(producerProject);
        FileSystemLocationSnapshot primaryInputSnapshot = this.fileSystemSnapshotter.snapshot(primaryInput);
        TransformationWorkspaceIdentity identity = this.getTransformationIdentity(producerProject, primaryInputSnapshot, transformer, dependenciesFingerprint);
        return workspaceProvider.withWorkspace(identity, (identityString, workspace) -> this.fireTransformListeners(transformer, subject, () -> {
            CurrentFileCollectionFingerprint primaryInputFingerprint = DefaultCurrentFileCollectionFingerprint.from((Iterable)ImmutableList.of((Object)primaryInputSnapshot), (FingerprintingStrategy)AbsolutePathFingerprintingStrategy.INCLUDE_MISSING);
            ImplementationSnapshot implementationSnapshot = ImplementationSnapshot.of(transformer.getImplementationClass(), (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
            TransformerExecution execution = new TransformerExecution(transformer, implementationSnapshot, workspace, identityString, workspaceProvider.getExecutionHistoryStore(), primaryInput, primaryInputFingerprint, dependencies, dependenciesFingerprint, this.outputFingerprinter);
            UpToDateResult outcome = (UpToDateResult)this.workExecutor.execute((UnitOfWork)execution);
            return execution.getResult(outcome);
        }));
    }

    private TransformationWorkspaceIdentity getTransformationIdentity(@Nullable ProjectInternal project, FileSystemLocationSnapshot primaryInputSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return project == null ? this.getImmutableTransformationIdentity(primaryInputSnapshot, transformer, dependenciesFingerprint) : this.getMutableTransformationIdentity(primaryInputSnapshot, transformer, dependenciesFingerprint);
    }

    private TransformationWorkspaceIdentity getImmutableTransformationIdentity(FileSystemLocationSnapshot primaryInputSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new ImmutableTransformationWorkspaceIdentity(primaryInputSnapshot.getAbsolutePath(), primaryInputSnapshot.getHash(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private TransformationWorkspaceIdentity getMutableTransformationIdentity(FileSystemLocationSnapshot primaryInputSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new MutableTransformationWorkspaceIdentity(primaryInputSnapshot.getAbsolutePath(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private CachingTransformationWorkspaceProvider determineWorkspaceProvider(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableTransformationWorkspaceProvider;
        }
        return (CachingTransformationWorkspaceProvider)producerProject.getServices().get(CachingTransformationWorkspaceProvider.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        if (!this.useTransformationWorkspaces || !subject.getProducer().isPresent()) {
            return null;
        }
        ProjectComponentIdentifier projectComponentIdentifier = subject.getProducer().get();
        return this.projectFinder.findProject(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Try<ImmutableList<File>> fireTransformListeners(Transformer transformer, TransformationSubject subject, Supplier<Try<ImmutableList<File>>> execution) {
        this.artifactTransformListener.beforeTransformerInvocation((Describable)transformer, (Describable)subject);
        try {
            Try<ImmutableList<File>> try_ = execution.get();
            return try_;
        }
        finally {
            this.artifactTransformListener.afterTransformerInvocation((Describable)transformer, (Describable)subject);
        }
    }

    public static class MutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String primaryInputAbsolutePath;
        private final HashCode secondaryInputsHash;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String primaryInputAbsolutePath, HashCode secondaryInputsHash, HashCode dependenciesHash) {
            this.primaryInputAbsolutePath = primaryInputAbsolutePath;
            this.secondaryInputsHash = secondaryInputsHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.primaryInputAbsolutePath);
            hasher.putHash(this.secondaryInputsHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsHash.equals((Object)that.secondaryInputsHash)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.primaryInputAbsolutePath.equals(that.primaryInputAbsolutePath);
        }

        public int hashCode() {
            int result = this.primaryInputAbsolutePath.hashCode();
            result = 31 * result + this.secondaryInputsHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    public static class ImmutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String primaryInputAbsolutePath;
        private final HashCode primaryInputHash;
        private final HashCode secondaryInputHash;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(String primaryInputAbsolutePath, HashCode primaryInputHash, HashCode secondaryInputHash, HashCode dependenciesHash) {
            this.primaryInputAbsolutePath = primaryInputAbsolutePath;
            this.primaryInputHash = primaryInputHash;
            this.secondaryInputHash = secondaryInputHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putHash(this.secondaryInputHash);
            hasher.putString((CharSequence)this.primaryInputAbsolutePath);
            hasher.putHash(this.primaryInputHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.primaryInputHash.equals((Object)that.primaryInputHash)) {
                return false;
            }
            if (!this.secondaryInputHash.equals((Object)that.secondaryInputHash)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.primaryInputAbsolutePath.equals(that.primaryInputAbsolutePath);
        }

        public int hashCode() {
            int result = this.primaryInputHash.hashCode();
            result = 31 * result + this.secondaryInputHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class AllOutputFileChanges
    extends AbstractFingerprintChanges {
        public AllOutputFileChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            super(previous, current, "Output");
        }

        public boolean accept(ChangeVisitor visitor) {
            return this.accept(visitor, true);
        }
    }

    private static class TransformerExecution
    implements UnitOfWork {
        private static final String PRIMARY_INPUT_PROPERTY_NAME = "primaryInput";
        private static final String DEPENDENCIES_PROPERTY_NAME = "dependencies";
        private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
        private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
        private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
        private static final String INPUT_FILE_PATH_PREFIX = "i/";
        private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
        private final Transformer transformer;
        private final ImplementationSnapshot implementationSnapshot;
        private final TransformationWorkspaceProvider.TransformationWorkspace workspace;
        private final File primaryInput;
        private final String identityString;
        private final ExecutionHistoryStore executionHistoryStore;
        private final ArtifactTransformDependenciesInternal dependencies;
        private final ImmutableSortedMap<String, ValueSnapshot> inputSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints;
        private final OutputFileCollectionFingerprinter outputFingerprinter;

        public TransformerExecution(Transformer transformer, ImplementationSnapshot implementationSnapshot, TransformationWorkspaceProvider.TransformationWorkspace workspace, String identityString, ExecutionHistoryStore executionHistoryStore, File primaryInput, CurrentFileCollectionFingerprint primaryInputFingerprint, ArtifactTransformDependenciesInternal dependencies, CurrentFileCollectionFingerprint dependenciesFingerprint, OutputFileCollectionFingerprinter outputFingerprinter) {
            this.implementationSnapshot = implementationSnapshot;
            this.primaryInput = primaryInput;
            this.transformer = transformer;
            this.workspace = workspace;
            this.identityString = "transform/" + identityString;
            this.executionHistoryStore = executionHistoryStore;
            this.dependencies = dependencies;
            this.inputSnapshots = ImmutableSortedMap.of((Comparable)((Object)SECONDARY_INPUTS_HASH_PROPERTY_NAME), (Object)ImplementationSnapshot.of((String)"secondary inputs", (HashCode)transformer.getSecondaryInputHash()));
            this.inputFileFingerprints = TransformerExecution.createInputFileFingerprints(primaryInputFingerprint, dependenciesFingerprint);
            this.outputFingerprinter = outputFingerprinter;
        }

        private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> createInputFileFingerprints(CurrentFileCollectionFingerprint primaryInputFingerprint, CurrentFileCollectionFingerprint dependenciesFingerprint) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)PRIMARY_INPUT_PROPERTY_NAME, (Object)primaryInputFingerprint);
            builder.put((Object)DEPENDENCIES_PROPERTY_NAME, (Object)dependenciesFingerprint);
            return builder.build();
        }

        public ExecutionOutcome execute() {
            File outputDir = this.workspace.getOutputDirectory();
            File resultsFile = this.workspace.getResultsFile();
            GFileUtils.cleanDirectory((File)outputDir);
            GFileUtils.deleteFileQuietly((File)resultsFile);
            ImmutableList result = ImmutableList.copyOf(this.transformer.transform(this.primaryInput, outputDir, this.dependencies));
            this.writeResultsFile(outputDir, resultsFile, (ImmutableList<File>)result);
            return ExecutionOutcome.EXECUTED;
        }

        private void writeResultsFile(File outputDir, File resultsFile, ImmutableList<File> result) {
            String outputDirPrefix = outputDir.getPath() + File.separator;
            String inputFilePrefix = this.primaryInput.getPath() + File.separator;
            Stream<String> relativePaths = result.stream().map(file -> {
                if (file.equals(outputDir)) {
                    return OUTPUT_FILE_PATH_PREFIX;
                }
                if (file.equals(this.primaryInput)) {
                    return INPUT_FILE_PATH_PREFIX;
                }
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    return OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(outputDirPrefix.length())).getPathString();
                }
                if (absolutePath.startsWith(inputFilePrefix)) {
                    return INPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(inputFilePrefix.length())).getPathString();
                }
                throw new IllegalStateException("Invalid result path: " + absolutePath);
            });
            UncheckedException.callUnchecked(() -> Files.write(resultsFile.toPath(), relativePaths::iterator, new OpenOption[0]));
        }

        private Try<ImmutableList<File>> getResult(UpToDateResult result) {
            return result.getOutcome().map(outcome -> this.loadResultsFile());
        }

        private ImmutableList<File> loadResultsFile() {
            Path transformerResultsPath = this.workspace.getResultsFile().toPath();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
                for (String path : paths) {
                    if (path.startsWith(OUTPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.workspace.getOutputDirectory(), path.substring(2)));
                        continue;
                    }
                    if (path.startsWith(INPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.primaryInput, path.substring(2)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot parse result path string: " + path);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            visitor.visitOutputProperty(OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, (FileCollection)ImmutableFileCollection.of((File[])new File[]{this.workspace.getOutputDirectory()}));
            visitor.visitOutputProperty(RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, (FileCollection)ImmutableFileCollection.of((File[])new File[]{this.workspace.getResultsFile()}));
        }

        public long markExecutionTime() {
            return 0L;
        }

        public void visitLocalState(CacheableEntity.LocalStateVisitor visitor) {
        }

        public void outputsRemovedAfterFailureToLoadFromCache() {
        }

        public CacheHandler createCacheHandler() {
            return new CacheHandler(){

                public <T> Optional<T> load(Function<BuildCacheKey, T> loader) {
                    return Optional.empty();
                }

                public void store(Consumer<BuildCacheKey> storer) {
                }
            };
        }

        public void persistResult(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs, boolean successful, OriginMetadata originMetadata) {
            if (successful) {
                this.executionHistoryStore.store(this.identityString, originMetadata, this.implementationSnapshot, ImmutableList.of(), this.inputSnapshots, this.inputFileFingerprints, finalOutputs, successful);
            }
        }

        public Optional<ExecutionStateChanges> getChangesSincePreviousExecution() {
            return this.executionHistoryStore.load(this.identityString).map(previous -> {
                ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsBeforeExecution = this.snapshotOutputs();
                InputFileChanges inputFileChanges = new InputFileChanges(previous.getInputFileProperties(), this.inputFileFingerprints);
                AllOutputFileChanges outputFileChanges = new AllOutputFileChanges((ImmutableSortedMap<String, FileCollectionFingerprint>)previous.getOutputFileProperties(), outputsBeforeExecution);
                return new TransformerExecutionStateChanges(inputFileChanges, outputFileChanges, (AfterPreviousExecutionState)previous);
            });
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.of(ImmutableList.of((Object)this.workspace.getOutputDirectory().getAbsolutePath(), (Object)this.workspace.getResultsFile().getAbsolutePath()));
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated() {
            return this.snapshotOutputs();
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotOutputs() {
            CurrentFileCollectionFingerprint outputFingerprint = this.outputFingerprinter.fingerprint((FileCollection)ImmutableFileCollection.of((File[])new File[]{this.workspace.getOutputDirectory()}));
            CurrentFileCollectionFingerprint resultsFileFingerprint = this.outputFingerprinter.fingerprint((FileCollection)ImmutableFileCollection.of((File[])new File[]{this.workspace.getResultsFile()}));
            return ImmutableSortedMap.of((Comparable)((Object)OUTPUT_DIRECTORY_PROPERTY_NAME), (Object)outputFingerprint, (Comparable)((Object)RESULTS_FILE_PROPERTY_NAME), (Object)resultsFileFingerprint);
        }

        public String getIdentity() {
            return this.identityString;
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            throw new UnsupportedOperationException("we don't cache yet");
        }

        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.primaryInput;
        }

        private class TransformerExecutionStateChanges
        implements ExecutionStateChanges {
            private final InputFileChanges inputFileChanges;
            private final AllOutputFileChanges outputFileChanges;
            private final AfterPreviousExecutionState afterPreviousExecutionState;

            public TransformerExecutionStateChanges(InputFileChanges inputFileChanges, AllOutputFileChanges outputFileChanges, AfterPreviousExecutionState afterPreviousExecutionState) {
                this.inputFileChanges = inputFileChanges;
                this.outputFileChanges = outputFileChanges;
                this.afterPreviousExecutionState = afterPreviousExecutionState;
            }

            public Iterable<Change> getInputFilesChanges() {
                return ImmutableList.of();
            }

            public void visitAllChanges(ChangeVisitor visitor) {
                new SummarizingChangeContainer(new ChangeContainer[]{this.inputFileChanges, this.outputFileChanges}).accept(visitor);
            }

            public boolean isRebuildRequired() {
                return true;
            }

            public AfterPreviousExecutionState getPreviousExecution() {
                return this.afterPreviousExecutionState;
            }
        }
    }
}

