/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.plugin;

import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.jaxb.core.internal.InternalJaxbWorkspace;
import org.osgi.framework.BundleContext;

public class JptJaxbCorePlugin
extends JptPlugin {
    private final Hashtable<IWorkspace, InternalJaxbWorkspace> jaxbWorkspaces = new Hashtable();
    private static JptJaxbCorePlugin INSTANCE;

    public static JptJaxbCorePlugin instance() {
        return INSTANCE;
    }

    protected void setInstance(JptPlugin plugin) {
        INSTANCE = (JptJaxbCorePlugin)plugin;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.disposeJaxbWorkspaces();
        }
        finally {
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalJaxbWorkspace getJaxbWorkspace(IWorkspace workspace) {
        Hashtable<IWorkspace, InternalJaxbWorkspace> hashtable = this.jaxbWorkspaces;
        synchronized (hashtable) {
            return this.getJaxbWorkspace_(workspace);
        }
    }

    private InternalJaxbWorkspace getJaxbWorkspace_(IWorkspace workspace) {
        InternalJaxbWorkspace jaxbWorkspace = this.jaxbWorkspaces.get(workspace);
        if (jaxbWorkspace == null && this.isActive()) {
            jaxbWorkspace = this.buildJaxbWorkspace(workspace);
            this.jaxbWorkspaces.put(workspace, jaxbWorkspace);
        }
        return jaxbWorkspace;
    }

    private InternalJaxbWorkspace buildJaxbWorkspace(IWorkspace workspace) {
        return new InternalJaxbWorkspace(workspace);
    }

    private void disposeJaxbWorkspaces() {
        for (InternalJaxbWorkspace jaxbWorkspace : this.jaxbWorkspaces.values()) {
            try {
                jaxbWorkspace.dispose();
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        this.jaxbWorkspaces.clear();
    }
}

