/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.js.node.internal.Messages;
import org.eclipse.wst.jsdt.js.node.internal.launch.NodeDebugConnector;
import org.eclipse.wst.jsdt.js.node.internal.util.LaunchConfigurationUtil;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;

public class NodeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && !LaunchConfigurationUtil.isChromiumAvailable()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", Messages.LAUNCH_CONFIGURATION_CHROMIUM_IS_NOT_AVAILABLE_ERROR));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String mainTypeName = configuration.getAttribute("attr_app_path", "");
            mainTypeName = LaunchConfigurationUtil.resolveValue(mainTypeName);
            IJSRunner runner = this.getJSRunner(configuration, mode);
            if (runner == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", Messages.LAUNCH_CONFIGURATION_NO_RUNNER_FOUND_ERROR));
            }
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String[] envp = this.getEnvironment(configuration);
            String pgmArgs = this.getProgramArguments(configuration);
            String nodeArgs = this.getNodeArguments(configuration);
            if (mode.equals("debug")) {
                String debugPort = configuration.getAttribute("attr_port_field", String.valueOf(5858));
                Boolean isBreakEnable = configuration.getAttribute("attr_break_field", true);
                nodeArgs = isBreakEnable != false ? "--debug-brk=" + debugPort + " " + nodeArgs : "--debug=" + debugPort + " " + nodeArgs;
            }
            ExecutionArguments execArgs = new ExecutionArguments(nodeArgs, pgmArgs);
            mainTypeName = this.getJsFile(mainTypeName);
            JSRunnerConfiguration runConfig = new JSRunnerConfiguration(mainTypeName);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            runConfig.setJSRuntimeArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            IProcess process = runner.run(runConfig, launch, monitor);
            if (process == null) {
                return;
            }
            if (mode.equals("debug")) {
                DebuggerConnectRunnable runnable = new DebuggerConnectRunnable();
                runnable.connector = new NodeDebugConnector(configuration, launch);
                Thread thread = new Thread((Runnable)runnable, "Connect to node.js debugger thread");
                thread.setDaemon(true);
                thread.start();
                while (thread.isAlive()) {
                    if (monitor.isCanceled()) {
                        thread.interrupt();
                        if (process.canTerminate()) {
                            process.terminate();
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                if (runnable.exception != null) {
                    if (runnable.exception instanceof CoreException) {
                        throw (CoreException)((Object)runnable.exception);
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", runnable.exception.getMessage(), (Throwable)runnable.exception));
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getJsFile(String mainTypeName) throws CoreException {
        Path file = new Path(mainTypeName);
        String jsFile = ChromiumDebugPlugin.getSourceMapManager().getJsFile((IPath)file);
        return jsFile != null ? jsFile : mainTypeName;
    }

    public IJSRunner getJSRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IJSRuntimeInstall runtimeInstall = this.verifyJSRuntimeInstall(configuration);
        if (runtimeInstall != null) {
            return runtimeInstall.getJSRunner(mode);
        }
        return null;
    }

    public IJSRuntimeInstall verifyJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return this.getJSRuntimeInstall(configuration);
    }

    public IJSRuntimeInstall getJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return JSRuntimeManager.getDefaultRuntimeInstall((String)"org.eclipse.wst.jsdt.js.node.runtimeType");
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath location;
        String projectName;
        File workingPath = null;
        String workingDirectory = configuration.getAttribute("attr_working_directory", "");
        if (workingDirectory.equals("") && !(projectName = configuration.getAttribute("attr_app_project", "")).equals("") && (location = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation()) != null) {
            workingDirectory = location.toOSString();
        }
        if (workingDirectory.length() > 0 && (workingDirectory = LaunchConfigurationUtil.resolveValue(workingDirectory)) != null) {
            workingPath = new File(workingDirectory);
        }
        return workingPath;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String appArguments = configuration.getAttribute("attr_app_arguments", "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(appArguments);
    }

    public String getNodeArguments(ILaunchConfiguration configuration) throws CoreException {
        String nodeArguments = configuration.getAttribute("attr_node_arguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(nodeArguments);
        return args;
    }

    class DebuggerConnectRunnable
    implements Runnable {
        private static final int TIMEOUT = 15000;
        Exception exception = null;
        NodeDebugConnector connector;

        DebuggerConnectRunnable() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            boolean attached = false;
            Exception e = null;
            do {
                try {
                    attached = this.connector.attach();
                }
                catch (Exception ex) {
                    e = ex;
                }
            } while (!attached && System.currentTimeMillis() < start + 15000L);
            if (!attached) {
                this.exception = e;
            }
        }
    }
}

