/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class MySQLUtils {
    private static final Log log = Log.getLog(MySQLUtils.class);
    private static Map<String, Integer> typeMap = new HashMap<String, Integer>();
    public static final String COLUMN_POSTFIX_PRIV = "_priv";

    static {
        typeMap.put("bit", -7);
        typeMap.put("bool", 16);
        typeMap.put("boolean", 16);
        typeMap.put("tinyint", -6);
        typeMap.put("smallint", 5);
        typeMap.put("mediumint", 4);
        typeMap.put("int", 4);
        typeMap.put("integer", 4);
        typeMap.put("int24", 4);
        typeMap.put("bigint", -5);
        typeMap.put("real", 8);
        typeMap.put("float", 7);
        typeMap.put("decimal", 3);
        typeMap.put("dec", 3);
        typeMap.put("numeric", 3);
        typeMap.put("double", 8);
        typeMap.put("double precision", 8);
        typeMap.put("char", 1);
        typeMap.put("varchar", 12);
        typeMap.put("date", 91);
        typeMap.put("time", 92);
        typeMap.put("year", 91);
        typeMap.put("timestamp", 93);
        typeMap.put("datetime", 93);
        typeMap.put("tinyblob", -2);
        typeMap.put("blob", -4);
        typeMap.put("mediumblob", -4);
        typeMap.put("longblob", -4);
        typeMap.put("tinytext", 12);
        typeMap.put("text", 12);
        typeMap.put("mediumtext", 12);
        typeMap.put("longtext", 12);
        typeMap.put("enum", 1);
        typeMap.put("set", 1);
        typeMap.put("geometry", -2);
        typeMap.put("binary", -2);
        typeMap.put("varbinary", -3);
    }

    public static int typeNameToValueType(String typeName) {
        Integer valueType = typeMap.get(typeName.toLowerCase(Locale.ENGLISH));
        return valueType == null ? 1111 : valueType;
    }

    public static List<String> collectPrivilegeNames(ResultSet resultSet) {
        try {
            ArrayList<String> privs = new ArrayList<String>();
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            int colCount = rsMetaData.getColumnCount();
            int i = 0;
            while (i < colCount) {
                String colName = rsMetaData.getColumnName(i + 1);
                if (colName.toLowerCase(Locale.ENGLISH).endsWith(COLUMN_POSTFIX_PRIV)) {
                    privs.add(colName.substring(0, colName.length() - COLUMN_POSTFIX_PRIV.length()));
                }
                ++i;
            }
            return privs;
        }
        catch (SQLException e) {
            log.debug((Object)e);
            return Collections.emptyList();
        }
    }

    public static Map<String, Boolean> collectPrivileges(List<String> privNames, ResultSet resultSet) {
        TreeMap<String, Boolean> privs = new TreeMap<String, Boolean>();
        for (String privName : privNames) {
            privs.put(privName, "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)(String.valueOf(privName) + COLUMN_POSTFIX_PRIV))));
        }
        return privs;
    }

    public static String getMySQLConsoleBinaryName() {
        return RuntimeUtils.getNativeBinaryName((String)"mysql");
    }

    public static String determineCurrentDatabase(JDBCSession session) throws DBCException {
        JDBCResultSet resultSet;
        JDBCPreparedStatement dbStat;
        block27: {
            String string;
            block28: {
                Throwable throwable = null;
                Object var2_4 = null;
                dbStat = session.prepareStatement("SELECT DATABASE()");
                Throwable throwable2 = null;
                Object var5_9 = null;
                resultSet = dbStat.executeQuery();
                try {
                    if (!resultSet.next()) break block27;
                    string = resultSet.getString(1);
                    if (resultSet == null) break block28;
                }
                catch (Throwable throwable3) {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable5) {
                            try {
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    if (throwable == null) {
                                        throwable = throwable6;
                                    } else if (throwable != throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    throw throwable;
                                }
                                catch (SQLException e) {
                                    throw new DBCException(e, (DBPDataSource)session.getDataSource());
                                }
                            }
                        }
                    }
                }
                resultSet.close();
            }
            if (dbStat != null) {
                dbStat.close();
            }
            return string;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (dbStat != null) {
            dbStat.close();
        }
        return null;
    }

    public static boolean isMariaDB(DBPDriver driver) {
        return "org.mariadb.jdbc.Driver".equals(driver.getDriverClassName());
    }
}

