/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

public abstract class NavigatorViewBase
extends ViewPart
implements INavigatorModelView,
IDataSourceContainerProvider,
DBPPreferenceListener {
    private DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
    private DatabaseNavigatorTree tree;
    private transient Object lastSelection;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior;

    protected NavigatorViewBase() {
    }

    public DBNModel getModel() {
        return this.model;
    }

    protected DatabaseNavigatorTree getNavigatorTree() {
        return this.tree;
    }

    protected INavigatorFilter getNavigatorFilter() {
        return null;
    }

    @NotNull
    public TreeViewer getNavigatorViewer() {
        return this.tree.getViewer();
    }

    public void createPartControl(Composite parent) {
        this.tree = this.createNavigatorTree(parent, this.getRootNode());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree.getViewer());
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.tree.getViewer().getControl(), (String)"org.jkiss.dbeaver.ui.context.navigator");
    }

    private DatabaseNavigatorTree createNavigatorTree(Composite parent, DBNNode rootNode) {
        DatabaseNavigatorTree navigatorTree = new DatabaseNavigatorTree(parent, rootNode, this.getTreeStyle(), false, this.getNavigatorFilter());
        navigatorTree.getViewer().addSelectionChangedListener(event -> this.onSelectionChange((IStructuredSelection)event.getSelection()));
        navigatorTree.getViewer().addDoubleClickListener(event -> {
            TreeViewer viewer = this.tree.getViewer();
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    Object node;
                    block18: {
                        DoubleClickBehavior dsBehaviorDefault;
                        block19: {
                            block16: {
                                node = objectArray[n2];
                                if (!(node instanceof DBNResource) || !(((DBNResource)node).getResource() instanceof IFolder)) break block16;
                                this.toggleNode(viewer, node);
                                break block17;
                            }
                            if (!(node instanceof DBNDataSource)) break block18;
                            dsBehaviorDefault = DoubleClickBehavior.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.connection.doubleClick"));
                            if (dsBehaviorDefault != DoubleClickBehavior.EXPAND) break block19;
                            this.toggleNode(viewer, node);
                            break block17;
                        }
                        DBPDataSourceContainer dataSource = ((DBNDataSource)node).getObject();
                        switch (NavigatorViewBase.$SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior()[dsBehaviorDefault.ordinal()]) {
                            case 1: {
                                NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)((DBNDataSource)node), null, UIUtils.getActiveWorkbenchWindow());
                                break;
                            }
                            case 2: {
                                UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                                if (dataSource.isConnected()) {
                                    serviceConnections.disconnectDataSource(dataSource);
                                    break;
                                }
                                serviceConnections.connectDataSource(dataSource, null);
                                break;
                            }
                            case 3: {
                                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                                if (serviceSQL != null) {
                                    serviceSQL.openRecentScript(dataSource);
                                    break;
                                }
                                break block17;
                            }
                            case 5: {
                                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                                if (serviceSQL == null) break block17;
                                serviceSQL.openNewScript(dataSource);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block17;
                    }
                    if (node instanceof TreeNodeSpecial) {
                        ((TreeNodeSpecial)node).handleDefaultAction(navigatorTree);
                    } else {
                        boolean hasChildren;
                        DoubleClickBehavior dcBehaviorDefault = DoubleClickBehavior.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.object.doubleClick"));
                        boolean bl = hasChildren = node instanceof DBNNode && ((DBNNode)node).hasChildren(true);
                        if (hasChildren && dcBehaviorDefault == DoubleClickBehavior.EXPAND) {
                            this.toggleNode(viewer, node);
                        } else {
                            NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, (IServiceLocator)this.getSite());
                        }
                    }
                }
                ++n2;
            }
        });
        NavigatorUtils.addContextMenu((IWorkbenchSite)this.getSite(), (Viewer)navigatorTree.getViewer());
        NavigatorUtils.addDragAndDropSupport((Viewer)navigatorTree.getViewer());
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
        return navigatorTree;
    }

    private void toggleNode(TreeViewer viewer, Object node) {
        if (Boolean.TRUE.equals(viewer.getExpandedState(node))) {
            viewer.collapseToLevel(node, 1);
        } else {
            viewer.expandToLevel(node, 1);
        }
    }

    protected void onSelectionChange(IStructuredSelection structSel) {
        IEditorPart activeEditor;
        if (!structSel.isEmpty()) {
            this.lastSelection = structSel.getFirstElement();
            if (this.lastSelection instanceof DBNNode) {
                String desc = ((DBNNode)this.lastSelection).getNodeDescription();
                if (CommonUtils.isEmpty((String)desc)) {
                    desc = ((DBNNode)this.lastSelection).getNodeName();
                }
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(desc);
            }
        } else {
            this.lastSelection = null;
        }
        if (this.lastSelection instanceof DBNDatabaseNode && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.sync.editor.datasource") && (activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            NavigatorUtils.syncEditorWithNavigator(this, activeEditor);
        }
    }

    protected int getTreeStyle() {
        return 2;
    }

    public void dispose() {
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        this.model = null;
        super.dispose();
    }

    public void setFocus() {
        this.tree.getViewer().getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        return (T)super.getAdapter(adapter);
    }

    public void showNode(DBNNode node) {
        this.tree.showNode(node);
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        Collection containers;
        if (this.lastSelection instanceof DBNDatabaseNode) {
            if (this.lastSelection instanceof DBNDataSource) {
                return ((DBNDataSource)this.lastSelection).getDataSourceContainer();
            }
            if (((DBNDatabaseNode)this.lastSelection).getObject() != null) {
                DBPDataSource dataSource = ((DBNDatabaseNode)this.lastSelection).getObject().getDataSource();
                return dataSource == null ? null : dataSource.getContainer();
            }
        } else if (this.lastSelection instanceof DBNResource && (containers = ((DBNResource)this.lastSelection).getAssociatedDataSources()) != null && containers.size() == 1) {
            return (DBPDataSourceContainer)containers.iterator().next();
        }
        return null;
    }

    public void configureView() {
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        String property = event.getProperty();
        if (CommonUtils.equalObjects((Object)event.getOldValue(), (Object)event.getNewValue())) {
            return;
        }
        switch (property) {
            case "navigator.sort.case.insensitive": 
            case "navigator.sort.forlers.first": 
            case "navigator.group.by.driver": 
            case "navigator.show.folder.placeholders": {
                this.tree.getViewer().refresh();
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior;
        }
        int[] nArray = new int[DoubleClickBehavior.values().length];
        try {
            nArray[DoubleClickBehavior.CONNECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DoubleClickBehavior.EDIT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DoubleClickBehavior.EXPAND.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DoubleClickBehavior.SQL_EDITOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DoubleClickBehavior.SQL_EDITOR_NEW.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$database$NavigatorViewBase$DoubleClickBehavior = nArray;
        return nArray;
    }

    public static enum DoubleClickBehavior {
        EDIT,
        CONNECT,
        SQL_EDITOR,
        EXPAND,
        SQL_EDITOR_NEW;

    }
}

