/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardCalcType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConstants;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardFetchType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardQuery;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardMapQueryDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardViewTypeDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DashboardDescriptor
extends AbstractContextDescriptor
implements DBPNamedObject {
    private static final Log log = Log.getLog(DashboardDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dashboard";
    private String id;
    private String name;
    private String description;
    private String group;
    private String measure;
    private boolean showByDefault;
    private DashboardViewTypeDescriptor defaultViewType;
    private DashboardMapQueryDescriptor mapQuery;
    private String[] mapKeys;
    private String[] mapLabels;
    private String mapFormula;
    private Expression mapFormulaExpr;
    private String[] tags;
    private final List<DataSourceMapping> dataSourceMappings = new ArrayList<DataSourceMapping>();
    private final List<QueryMapping> queries = new ArrayList<QueryMapping>();
    private DashboardDataType dataType;
    private float widthRatio;
    private DashboardCalcType calcType;
    private DashboardFetchType fetchType;
    private long updatePeriod;
    private int maxItems;
    private long maxAge;
    private boolean isCustom;
    private DashboardValueType valueType;

    DashboardDescriptor(DashboardRegistry registry, IConfigurationElement config) {
        super(config);
        IConfigurationElement ds;
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.group = config.getAttribute("group");
        this.measure = config.getAttribute("measure");
        this.tags = CommonUtils.split((String)config.getAttribute("tags"), (String)",");
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("showByDefault"));
        this.dataType = (DashboardDataType)CommonUtils.valueOf(DashboardDataType.class, (String)config.getAttribute("dataType"), (Enum)DashboardConstants.DEF_DASHBOARD_DATA_TYPE);
        this.defaultViewType = registry.getViewType(config.getAttribute("defaultView"));
        if (this.defaultViewType == null) {
            this.defaultViewType = registry.getViewType("timeseries");
        }
        this.widthRatio = (float)CommonUtils.toDouble((Object)config.getAttribute("ratio"), (double)1.5);
        this.calcType = (DashboardCalcType)CommonUtils.valueOf(DashboardCalcType.class, (String)config.getAttribute("calc"), (Enum)DashboardConstants.DEF_DASHBOARD_CALC_TYPE);
        this.valueType = (DashboardValueType)CommonUtils.valueOf(DashboardValueType.class, (String)config.getAttribute("value"), (Enum)DashboardConstants.DEF_DASHBOARD_VALUE_TYPE);
        this.fetchType = (DashboardFetchType)CommonUtils.valueOf(DashboardFetchType.class, (String)config.getAttribute("fetch"), (Enum)DashboardConstants.DEF_DASHBOARD_FETCH_TYPE);
        this.updatePeriod = CommonUtils.toLong((Object)config.getAttribute("updatePeriod"), (long)1000L);
        this.maxItems = CommonUtils.toInt((Object)config.getAttribute("maxItems"), (int)300);
        this.maxAge = CommonUtils.toLong((Object)config.getAttribute("maxAge"), (long)1800000L);
        String mapQueryId = config.getAttribute("mapQuery");
        if (!CommonUtils.isEmpty((String)mapQueryId)) {
            this.mapQuery = registry.getMapQuery(mapQueryId);
            if (this.mapQuery != null) {
                this.mapKeys = CommonUtils.split((String)config.getAttribute("mapKeys"), (String)",");
                this.mapLabels = CommonUtils.split((String)config.getAttribute("mapLabels"), (String)",");
                this.mapFormula = config.getAttribute("mapFormula");
                if (!CommonUtils.isEmpty((String)this.mapFormula)) {
                    try {
                        this.mapFormulaExpr = AbstractDescriptor.parseExpression((String)this.mapFormula);
                    }
                    catch (DBException e) {
                        log.warn((Object)e);
                    }
                }
            }
        }
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("datasource");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ds = iConfigurationElementArray[n2];
            this.dataSourceMappings.add(new DataSourceMapping(ds));
            ++n2;
        }
        iConfigurationElementArray = config.getChildren("query");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            ds = iConfigurationElementArray[n2];
            this.queries.add(new QueryMapping(ds));
            ++n2;
        }
        this.isCustom = false;
    }

    DashboardDescriptor(DashboardRegistry registry, Element config) {
        super("org.jkiss.dbeaver.ui.dashboard");
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.group = config.getAttribute("group");
        this.measure = config.getAttribute("measure");
        this.tags = CommonUtils.split((String)config.getAttribute("tags"), (String)",");
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("showByDefault"));
        this.dataType = (DashboardDataType)CommonUtils.valueOf(DashboardDataType.class, (String)config.getAttribute("dataType"), (Enum)DashboardConstants.DEF_DASHBOARD_DATA_TYPE);
        this.defaultViewType = registry.getViewType(config.getAttribute("defaultView"));
        if (this.defaultViewType == null) {
            this.defaultViewType = registry.getViewType("timeseries");
        }
        this.widthRatio = (float)CommonUtils.toDouble((Object)config.getAttribute("ratio"), (double)1.5);
        this.calcType = (DashboardCalcType)CommonUtils.valueOf(DashboardCalcType.class, (String)config.getAttribute("calc"), (Enum)DashboardConstants.DEF_DASHBOARD_CALC_TYPE);
        this.valueType = (DashboardValueType)CommonUtils.valueOf(DashboardValueType.class, (String)config.getAttribute("value"), (Enum)DashboardConstants.DEF_DASHBOARD_VALUE_TYPE);
        this.fetchType = (DashboardFetchType)CommonUtils.valueOf(DashboardFetchType.class, (String)config.getAttribute("fetch"), (Enum)DashboardConstants.DEF_DASHBOARD_FETCH_TYPE);
        this.updatePeriod = CommonUtils.toLong((Object)config.getAttribute("updatePeriod"), (long)1000L);
        this.maxItems = CommonUtils.toInt((Object)config.getAttribute("maxItems"), (int)300);
        this.maxAge = CommonUtils.toLong((Object)config.getAttribute("maxAge"), (long)1800000L);
        for (Element ds : XMLUtils.getChildElementList((Element)config, (String)"datasource")) {
            this.dataSourceMappings.add(new DataSourceMapping(ds));
        }
        for (Element ds : XMLUtils.getChildElementList((Element)config, (String)"query")) {
            this.queries.add(new QueryMapping(ds));
        }
        this.isCustom = true;
    }

    public DashboardDescriptor(DashboardDescriptor source) {
        super(source.getPluginId());
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.group = source.group;
        this.measure = source.measure;
        this.tags = source.tags;
        this.showByDefault = source.showByDefault;
        this.dataType = source.dataType;
        this.defaultViewType = source.defaultViewType;
        this.widthRatio = source.widthRatio;
        this.calcType = source.calcType;
        this.valueType = source.valueType;
        this.fetchType = source.fetchType;
        this.updatePeriod = source.updatePeriod;
        this.maxItems = source.maxItems;
        this.maxAge = source.maxAge;
        this.dataSourceMappings.addAll(source.dataSourceMappings);
        this.queries.addAll(source.queries);
        this.isCustom = source.isCustom;
    }

    public DashboardDescriptor(String id, String name, String description, String group) {
        super("org.jkiss.dbeaver.ui.dashboard");
        this.id = id;
        this.name = name;
        this.description = description;
        this.group = group;
        this.dataType = DashboardDataType.timeseries;
        this.defaultViewType = DashboardRegistry.getInstance().getViewType("timeseries");
        this.widthRatio = 1.5f;
        this.calcType = DashboardConstants.DEF_DASHBOARD_CALC_TYPE;
        this.valueType = DashboardConstants.DEF_DASHBOARD_VALUE_TYPE;
        this.fetchType = DashboardConstants.DEF_DASHBOARD_FETCH_TYPE;
        this.updatePeriod = 1000L;
        this.maxItems = 300;
        this.maxAge = 1800000L;
        this.isCustom = true;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public DashboardDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DashboardDataType dataType) {
        this.dataType = dataType;
    }

    public DashboardViewTypeDescriptor getDefaultViewType() {
        return this.defaultViewType;
    }

    public void setDefaultViewType(DashboardViewTypeDescriptor defaultViewType) {
        this.defaultViewType = defaultViewType;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public void setWidthRatio(float widthRatio) {
        this.widthRatio = widthRatio;
    }

    public DashboardCalcType getCalcType() {
        return this.calcType;
    }

    public void setCalcType(DashboardCalcType calcType) {
        this.calcType = calcType;
    }

    public DashboardValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(DashboardValueType valueType) {
        this.valueType = valueType;
    }

    public DashboardFetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(DashboardFetchType fetchType) {
        this.fetchType = fetchType;
    }

    public List<QueryMapping> getQueries() {
        return this.queries;
    }

    public void setQueries(String[] queryStrings) {
        this.queries.clear();
        String[] stringArray = queryStrings;
        int n = queryStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String qs = stringArray[n2];
            this.queries.add(new QueryMapping(qs.trim()));
            ++n2;
        }
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public DashboardMapQueryDescriptor getMapQuery() {
        return this.mapQuery;
    }

    public String[] getMapKeys() {
        return this.mapKeys;
    }

    public String[] getMapLabels() {
        return this.mapLabels;
    }

    public Expression getMapFormulaExpr() {
        return this.mapFormulaExpr;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean custom) {
        this.isCustom = custom;
    }

    public List<DBPNamedObject> getDataSourceMappings() {
        return this.getSupportedSources();
    }

    public void setDataSourceMappings(List<DBPNamedObject> targets) {
        this.dataSourceMappings.clear();
        for (DBPNamedObject target : targets) {
            if (target instanceof DBPDataSourceProviderDescriptor) {
                this.dataSourceMappings.add(new DataSourceMapping(((DBPDataSourceProviderDescriptor)target).getId(), null, null));
                continue;
            }
            if (!(target instanceof DBPDriver)) continue;
            DBPDriver driver = (DBPDriver)target;
            this.dataSourceMappings.add(new DataSourceMapping(driver.getProviderId(), driver.getId(), null));
        }
    }

    public boolean matches(String providerId, String driverId, String driverClass) {
        for (DataSourceMapping dsm : this.dataSourceMappings) {
            if (dsm.matches(providerId, driverId, driverClass)) continue;
            return false;
        }
        return true;
    }

    public List<DBPNamedObject> getSupportedSources() {
        DBPPlatform platform = DBWorkbench.getPlatform();
        ArrayList<DBPNamedObject> results = new ArrayList<DBPNamedObject>();
        for (DataSourceMapping dsm : this.dataSourceMappings) {
            DBPDriver driver;
            if (dsm.dataSourceProvider != null) {
                DBPDataSourceProviderDescriptor provider = platform.getDataSourceProviderRegistry().getDataSourceProvider(dsm.dataSourceProvider);
                if (provider == null) continue;
                results.add((DBPNamedObject)provider);
                continue;
            }
            if (dsm.driverId == null || (driver = platform.getDataSourceProviderRegistry().findDriver(dsm.driverId)) == null) continue;
            results.add((DBPNamedObject)driver);
        }
        return results;
    }

    void serialize(XMLBuilder xml) throws IOException {
        xml.addAttribute("id", this.id);
        xml.addAttribute("label", this.name);
        if (!CommonUtils.isEmpty((String)this.description)) {
            xml.addAttribute("description", this.description);
        }
        if (!CommonUtils.isEmpty((String)this.group)) {
            xml.addAttribute("group", this.group);
        }
        if (!CommonUtils.isEmpty((String)this.measure)) {
            xml.addAttribute("measure", this.measure);
        }
        if (!ArrayUtils.isEmpty((Object[])this.tags)) {
            xml.addAttribute("tags", String.join((CharSequence)",", this.tags));
        }
        xml.addAttribute("showByDefault", this.showByDefault);
        xml.addAttribute("viewType", this.defaultViewType.getId());
        xml.addAttribute("ratio", this.widthRatio);
        xml.addAttribute("calc", this.calcType.name());
        xml.addAttribute("value", this.valueType.name());
        xml.addAttribute("fetch", this.fetchType.name());
        xml.addAttribute("updatePeriod", this.updatePeriod);
        xml.addAttribute("maxItems", this.maxItems);
        xml.addAttribute("maxAge", this.maxAge);
        if (this.mapQuery != null) {
            xml.addAttribute("mapQuery", this.mapQuery.getId());
        }
        if (!ArrayUtils.isEmpty((Object[])this.mapKeys)) {
            xml.addAttribute("mapKeys", String.join((CharSequence)",", this.mapKeys));
        }
        if (!CommonUtils.isEmpty((String)this.mapFormula)) {
            xml.addAttribute("mapFormula", this.mapFormula);
        }
        for (DataSourceMapping mapping : this.dataSourceMappings) {
            xml.startElement("datasource");
            mapping.serialize(xml);
            xml.endElement();
        }
        for (QueryMapping qm : this.queries) {
            xml.startElement("query");
            qm.serialize(xml);
            xml.endElement();
        }
        this.isCustom = true;
    }

    public String toString() {
        return this.id;
    }

    private static class DataSourceMapping {
        private final String dataSourceProvider;
        private final String driverId;
        private final String driverClass;

        DataSourceMapping(IConfigurationElement config) {
            this.dataSourceProvider = CommonUtils.nullIfEmpty((String)config.getAttribute("id"));
            this.driverId = CommonUtils.nullIfEmpty((String)config.getAttribute("driver"));
            this.driverClass = CommonUtils.nullIfEmpty((String)config.getAttribute("driverClass"));
        }

        DataSourceMapping(Element config) {
            this.dataSourceProvider = CommonUtils.nullIfEmpty((String)config.getAttribute("id"));
            this.driverId = CommonUtils.nullIfEmpty((String)config.getAttribute("driver"));
            this.driverClass = CommonUtils.nullIfEmpty((String)config.getAttribute("driverClass"));
        }

        public DataSourceMapping(String dataSourceProvider, String driverId, String driverClass) {
            this.dataSourceProvider = dataSourceProvider;
            this.driverId = driverId;
            this.driverClass = driverClass;
        }

        boolean matches(String providerId, String checkDriverId, String checkDriverClass) {
            if (this.dataSourceProvider != null && !this.dataSourceProvider.equals(providerId)) {
                return false;
            }
            if (checkDriverId != null && this.driverId != null && !this.driverId.equals(checkDriverId)) {
                return false;
            }
            return checkDriverClass == null || this.driverClass == null || this.driverClass.equals(checkDriverClass);
        }

        void serialize(XMLBuilder xml) throws IOException {
            if (!CommonUtils.isEmpty((String)this.dataSourceProvider)) {
                xml.addAttribute("id", this.dataSourceProvider);
            }
            if (!CommonUtils.isEmpty((String)this.driverId)) {
                xml.addAttribute("driver", this.driverId);
            }
            if (!CommonUtils.isEmpty((String)this.driverClass)) {
                xml.addAttribute("driverClass", this.driverClass);
            }
        }
    }

    public static class QueryMapping
    implements DashboardQuery {
        private String queryText;

        QueryMapping(IConfigurationElement config) {
            this.queryText = config.getValue();
        }

        QueryMapping(Element config) {
            this.queryText = XMLUtils.getElementBody((Element)config);
        }

        public QueryMapping(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public String getQueryText() {
            return this.queryText;
        }

        void serialize(XMLBuilder xml) throws IOException {
            xml.addText((CharSequence)this.queryText);
        }
    }
}

