/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;

class WorkbenchContextListener
implements IWindowListener,
IPageListener,
IPartListener {
    private static final String RESULTS_CONTEXT_ID = "org.jkiss.dbeaver.ui.context.resultset";
    private static final String PERSPECTIVE_CONTEXT_ID = "org.jkiss.dbeaver.ui.perspective";
    private IContextActivation activationNavigator;
    private IContextActivation activationSQL;
    private IContextActivation activationResults;
    private CommandExecutionListener commandExecutionListener;

    public WorkbenchContextListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.listenWindowEvents(window);
            ++n2;
        }
        workbench.addWindowListener((IWindowListener)this);
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService != null) {
            this.commandExecutionListener = new CommandExecutionListener();
            commandService.addExecutionListener((IExecutionListener)this.commandExecutionListener);
        }
        workbench.addWindowListener((IWindowListener)this);
        workbench.addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            this.windowActivated(activeWindow);
            IWorkbenchPage activePage = activeWindow.getActivePage();
            if (activePage != null) {
                this.pageActivated(activePage);
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart != null) {
                    this.partActivated(activePart);
                }
            }
        }
    }

    private void listenWindowEvents(IWorkbenchWindow window) {
        IPerspectiveListener perspectiveListener = new IPerspectiveListener(){
            private IContextActivation perspectiveActivation;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                if (contextService == null) {
                    return;
                }
                if (perspective.getId().equals("org.jkiss.dbeaver.core.perspective")) {
                    this.perspectiveActivation = contextService.activateContext(WorkbenchContextListener.PERSPECTIVE_CONTEXT_ID);
                } else if (this.perspectiveActivation != null) {
                    contextService.deactivateContext(this.perspectiveActivation);
                    this.perspectiveActivation = null;
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        window.addPerspectiveListener(perspectiveListener);
        perspectiveListener.perspectiveActivated(window.getActivePage(), window.getActivePage().getPerspective());
        window.addPageListener((IPageListener)this);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            page.addPartListener((IPartListener)this);
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.listenWindowEvents(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        this.activatePartContexts(part);
    }

    void activatePartContexts(IWorkbenchPart part) {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        try {
            contextService.deferUpdates(true);
            if (part instanceof INavigatorModelView) {
                if (this.activationNavigator != null) {
                    contextService.deactivateContext(this.activationNavigator);
                }
                this.activationNavigator = contextService.activateContext("org.jkiss.dbeaver.ui.context.navigator");
            }
            if (part instanceof SQLEditorBase || part.getAdapter(SQLEditorBase.class) != null) {
                if (this.activationSQL != null) {
                    contextService.deactivateContext(this.activationSQL);
                }
                this.activationSQL = contextService.activateContext("org.jkiss.dbeaver.ui.editors.sql");
            }
            if (part.getAdapter(ResultSetViewer.class) != null || part instanceof SQLEditor || part instanceof EntityEditor && ((EntityEditor)part).getDatabaseObject() instanceof DBSDataContainer) {
                if (this.activationResults != null) {
                    contextService.deactivateContext(this.activationResults);
                }
                this.activationResults = contextService.activateContext(RESULTS_CONTEXT_ID);
            }
            ActionUtils.fireCommandRefresh((String)"org.jkiss.dbeaver.core.txn.autocommit");
        }
        finally {
            contextService.deferUpdates(false);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.deactivatePartContexts(part);
    }

    void deactivatePartContexts(IWorkbenchPart part) {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        try {
            contextService.deferUpdates(true);
            if (this.activationNavigator != null && part instanceof INavigatorModelView) {
                contextService.deactivateContext(this.activationNavigator);
                this.activationNavigator = null;
            }
            if (this.activationSQL != null) {
                contextService.deactivateContext(this.activationSQL);
                this.activationSQL = null;
            }
            if (this.activationResults != null) {
                contextService.deactivateContext(this.activationResults);
                this.activationResults = null;
            }
        }
        finally {
            contextService.deferUpdates(false);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    static WorkbenchContextListener registerInWorkbench() {
        return new WorkbenchContextListener();
    }

    private static class CommandExecutionListener
    implements IExecutionListener {
        private CommandExecutionListener() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            DBRFeature commandFeature = DBRFeatureRegistry.getInstance().findCommandFeature(commandId);
            if (commandFeature != null) {
                commandFeature.use();
            }
        }

        public void preExecute(String commandId, ExecutionEvent event) {
        }
    }
}

