/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractStructDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCComposite
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(JDBCComposite.class);
    @Nullable
    private Struct rawStruct;
    @NotNull
    protected DBSDataType type;
    @NotNull
    protected DBSEntityAttribute[] attributes;
    @NotNull
    protected Object[] values;
    protected boolean modified;

    protected JDBCComposite() {
    }

    public JDBCComposite(Struct rawStruct) {
        this.rawStruct = rawStruct;
    }

    protected JDBCComposite(@NotNull JDBCComposite struct, @NotNull DBRProgressMonitor monitor) throws DBCException {
        this.type = struct.type;
        this.attributes = Arrays.copyOf(struct.attributes, struct.attributes.length);
        this.values = new Object[struct.values.length];
        int i = 0;
        while (i < struct.values.length) {
            Object value = struct.values[i];
            if (value instanceof DBDValueCloneable) {
                value = ((DBDValueCloneable)value).cloneValue(monitor);
            }
            this.values[i] = value;
            ++i;
        }
    }

    @Override
    public boolean isNull() {
        Object[] objectArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (!DBUtils.isNullValue(value)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void release() {
        this.values = EMPTY_VALUES;
    }

    @NotNull
    public String getTypeName() {
        return this.type.getTypeName();
    }

    public String getStringRepresentation() {
        return CommonUtils.toString((Object)this.getRawValue());
    }

    @NotNull
    public Object[] getValues() {
        return this.values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Struct getStructValue() throws DBCException {
        Object attr2;
        if (this.rawStruct != null) {
            return this.rawStruct;
        }
        Object[] attrs = new Object[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            attr2 = this.values[i];
            if (attr2 instanceof DBDValue) {
                attr2 = ((DBDValue)attr2).getRawValue();
            }
            attrs[i] = attr2;
            ++i;
        }
        DBSDataType dataType = this.getDataType();
        try {
            attr2 = null;
            Object var4_7 = null;
            try {
                Struct struct;
                Object session = DBUtils.openUtilSession(new VoidProgressMonitor(), dataType, "Create JDBC struct");
                try {
                    if (session instanceof Connection) {
                        struct = ((Connection)session).createStruct(dataType.getTypeName(), attrs);
                        return struct;
                    }
                    return new JDBCStructImpl(dataType.getTypeName(), attrs, this.getStringRepresentation());
                }
                catch (Throwable attr2) {
                    throw attr2;
                }
                finally {
                    if (session == null) return struct;
                    session.close();
                }
            }
            catch (Throwable throwable) {
                if (attr2 == null) {
                    attr2 = throwable;
                    throw attr2;
                }
                if (attr2 == throwable) throw attr2;
                ((Throwable)attr2).addSuppressed(throwable);
                throw attr2;
            }
        }
        catch (Throwable e) {
            throw new DBCException("Error creating struct", e);
        }
    }

    @Override
    public DBSDataType getDataType() {
        return this.type;
    }

    @Override
    public Struct getRawValue() {
        if (this.rawStruct != null) {
            return this.rawStruct;
        }
        try {
            return this.getStructValue();
        }
        catch (Throwable e) {
            log.error(e);
            return null;
        }
    }

    @Override
    @NotNull
    public DBSAttributeBase[] getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        int position = attribute.getOrdinalPosition();
        if (position >= this.values.length) {
            log.debug("Attribute index is out of range (" + position + ">=" + this.values.length + ")");
            return null;
        }
        return this.values[position];
    }

    @Override
    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        if (!CommonUtils.equalObjects((Object)this.values[attribute.getOrdinalPosition()], (Object)value)) {
            this.values[attribute.getOrdinalPosition()] = value;
            this.modified = true;
        }
    }

    protected static class StructAttribute
    extends AbstractAttribute
    implements DBSEntityAttribute {
        final DBSDataType type;
        DBPDataKind dataKind;

        public StructAttribute(DBSDataType type, int index, Object value) {
            this.type = type;
            if (value instanceof CharSequence) {
                this.dataKind = DBPDataKind.STRING;
                this.setValueType(12);
            } else if (value instanceof Number) {
                this.dataKind = DBPDataKind.NUMERIC;
                this.setValueType(2);
            } else if (value instanceof Boolean) {
                this.dataKind = DBPDataKind.BOOLEAN;
                this.setValueType(16);
            } else if (value instanceof Date) {
                this.dataKind = DBPDataKind.DATETIME;
                this.setValueType(93);
            } else if (value instanceof byte[]) {
                this.dataKind = DBPDataKind.BINARY;
                this.setValueType(-2);
            } else {
                this.dataKind = DBPDataKind.OBJECT;
                this.setValueType(1111);
            }
            this.setName("Attr" + index);
            this.setOrdinalPosition(index);
            this.setTypeName(this.dataKind.name());
        }

        public StructAttribute(DBSDataType type, ResultSetMetaData metaData, int index) throws SQLException {
            super(metaData.getColumnName(index + 1), metaData.getColumnTypeName(index + 1), metaData.getColumnType(index + 1), index, metaData.getColumnDisplaySize(index + 1), metaData.getScale(index + 1), metaData.getPrecision(index + 1), metaData.isNullable(index + 1) == 0, metaData.isAutoIncrement(index + 1));
            this.type = type;
            this.dataKind = JDBCUtils.resolveDataKind(type.getDataSource(), this.getTypeName(), this.getTypeID());
        }

        @Override
        public DBPDataKind getDataKind() {
            return this.dataKind;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StructAttribute)) {
                return false;
            }
            StructAttribute attr = (StructAttribute)obj;
            return CommonUtils.equalObjects((Object)this.name, (Object)attr.name) && this.valueType == attr.valueType && this.maxLength == attr.maxLength && CommonUtils.equalObjects((Object)this.scale, (Object)attr.scale) && CommonUtils.equalObjects((Object)this.precision, (Object)attr.precision) && CommonUtils.equalObjects((Object)this.typeName, (Object)attr.typeName) && this.ordinalPosition == attr.ordinalPosition;
        }

        public int hashCode() {
            return (int)((long)(this.name.hashCode() + this.valueType) + this.maxLength + (long)this.scale.intValue() + (long)this.precision.intValue() + (long)this.typeName.hashCode() + (long)this.ordinalPosition);
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @Override
        @NotNull
        public DBSEntity getParentObject() {
            return (StructType)this.type;
        }

        @Override
        @NotNull
        public DBPDataSource getDataSource() {
            return this.type.getDataSource();
        }
    }

    protected class StructType
    extends AbstractStructDataType<DBPDataSource>
    implements DBSEntity {
        public StructType(DBPDataSource dataSource) {
            super(dataSource);
        }

        @Override
        @NotNull
        public String getTypeName() {
            return "Object";
        }

        @Override
        public int getTypeID() {
            return 2002;
        }

        @Override
        public DBPDataKind getDataKind() {
            return DBPDataKind.STRUCT;
        }

        @Override
        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.TYPE;
        }

        @Override
        @Nullable
        public Collection<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
            return Arrays.asList(JDBCComposite.this.attributes);
        }
    }
}

