/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDPseudoReferrer;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetUtils {
    private static final Log log = Log.getLog(ResultSetUtils.class);
    private static volatile IDialogSettings viewerSettings;

    @NotNull
    public static IDialogSettings getViewerSettings(String section) {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getDialogSettings((String)ResultSetViewer.class.getSimpleName());
        }
        return UIUtils.getSettingsSection((IDialogSettings)viewerSettings, (String)section);
    }

    public static void bindAttributes(@NotNull DBCSession session, @Nullable DBSEntity sourceEntity, @Nullable DBCResultSet resultSet, @NotNull DBDAttributeBindingMeta[] bindings, @Nullable List<Object[]> rows) throws DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBPDataSource dataSource = session.getDataSource();
        boolean readMetaData = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.metadata");
        if (!readMetaData && sourceEntity == null) {
            return;
        }
        boolean readReferences = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.references");
        IdentityHashMap<DBCEntityMetaData, DBSEntity> entityBindingMap = new IdentityHashMap<DBCEntityMetaData, DBSEntity>();
        monitor.beginTask("Discover resultset metadata", 3);
        try {
            DBSEntity attrEntity;
            DBDAttributeBindingMeta binding;
            DBCStatement sourceStatement;
            SQLQuery sqlQuery = null;
            DBSEntity entity = null;
            if (sourceEntity != null) {
                entity = sourceEntity;
            } else if (resultSet != null && (sourceStatement = resultSet.getSourceStatement()) != null && sourceStatement.getStatementSource() != null) {
                DBCExecutionSource executionSource = sourceStatement.getStatementSource();
                monitor.subTask("Discover owner entity");
                DBSDataContainer dataContainer = executionSource.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)dataContainer;
                }
                DBCEntityMetaData entityMeta = null;
                if (entity == null) {
                    Object sourceDescriptor = executionSource.getSourceDescriptor();
                    if (sourceDescriptor instanceof SQLQuery) {
                        sqlQuery = (SQLQuery)sourceDescriptor;
                        entityMeta = sqlQuery.getSingleSource();
                    }
                    if (entityMeta != null && (entity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (DBCEntityMetaData)entityMeta)) != null) {
                        entityBindingMap.put(entityMeta, entity);
                    }
                }
            }
            IdentityHashMap<DBSEntity, DBDRowIdentifier> locatorMap = new IdentityHashMap<DBSEntity, DBDRowIdentifier>();
            monitor.subTask("Discover attributes");
            DBDAttributeBindingMeta[] dBDAttributeBindingMetaArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                binding = dBDAttributeBindingMetaArray[n2];
                monitor.subTask("Discover attribute '" + binding.getName() + "'");
                DBCAttributeMetaData attrMeta = binding.getMetaAttribute();
                attrEntity = null;
                DBCEntityMetaData attrEntityMeta = attrMeta.getEntityMetaData();
                if (attrEntityMeta != null) {
                    attrEntity = (DBSEntity)entityBindingMap.get(attrEntityMeta);
                    if (attrEntity == null) {
                        attrEntity = entity != null && entity instanceof DBSTable && ((DBSTable)entity).isView() ? entity : DBUtils.getEntityFromMetaData((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (DBCEntityMetaData)attrEntityMeta);
                    }
                    if (attrEntity != null) {
                        entityBindingMap.put(attrEntityMeta, attrEntity);
                    }
                }
                if (attrEntity == null) {
                    attrEntity = entity;
                }
                if (attrEntity == null) {
                    if (attrEntityMeta != null) {
                        log.debug((Object)("Table '" + DBUtils.getSimpleQualifiedName((Object[])new Object[]{attrEntityMeta.getCatalogName(), attrEntityMeta.getSchemaName(), attrEntityMeta.getEntityName()}) + "' not found in metadata catalog"));
                    }
                } else {
                    DBDPseudoAttribute pseudoAttribute = DBUtils.getPseudoAttribute((DBSEntity)attrEntity, (String)attrMeta.getName());
                    if (pseudoAttribute != null) {
                        binding.setPseudoAttribute(pseudoAttribute);
                    }
                    DBSEntityAttribute tableColumn = binding.getPseudoAttribute() != null ? binding.getPseudoAttribute().createFakeAttribute(attrEntity, attrMeta) : attrEntity.getAttribute(monitor, attrMeta.getName());
                    if (sqlQuery != null && tableColumn != null && tableColumn.getTypeID() != attrMeta.getTypeID()) {
                        binding.setEntityAttribute(tableColumn, false);
                    } else if (tableColumn != null && binding.setEntityAttribute(tableColumn, true) && rows != null) {
                        try {
                            int pos = attrMeta.getOrdinalPosition();
                            for (Object[] row : rows) {
                                row[pos] = binding.getValueHandler().getValueFromObject(session, (DBSTypedObject)tableColumn, row[pos], false);
                            }
                        }
                        catch (DBCException e) {
                            log.warn((Object)("Error resolving attribute '" + binding.getName() + "' values"), (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
            monitor.worked(1);
            monitor.subTask("Detect unique identifiers");
            dBDAttributeBindingMetaArray = bindings;
            n = bindings.length;
            n2 = 0;
            while (n2 < n) {
                binding = dBDAttributeBindingMetaArray[n2];
                DBSEntityAttribute attr = binding.getEntityAttribute();
                if (attr != null && (attrEntity = attr.getParentObject()) != null) {
                    DBSEntityReferrer entityIdentifier;
                    DBDRowIdentifier rowIdentifier = (DBDRowIdentifier)locatorMap.get(attrEntity);
                    if (rowIdentifier == null && (entityIdentifier = ResultSetUtils.getBestIdentifier(monitor, attrEntity, bindings, readMetaData)) != null) {
                        rowIdentifier = new DBDRowIdentifier(attrEntity, entityIdentifier);
                        locatorMap.put(attrEntity, rowIdentifier);
                    }
                    binding.setRowIdentifier(rowIdentifier);
                }
                ++n2;
            }
            monitor.worked(1);
            if (readMetaData && readReferences && rows != null) {
                monitor.subTask("Read results metadata");
                dBDAttributeBindingMetaArray = bindings;
                n = bindings.length;
                n2 = 0;
                while (n2 < n) {
                    binding = dBDAttributeBindingMetaArray[n2];
                    binding.lateBinding(session, rows);
                    ++n2;
                }
            }
            monitor.subTask("Complete metadata load");
            for (DBDRowIdentifier rowIdentifier : locatorMap.values()) {
                rowIdentifier.reloadAttributes(monitor, (DBDAttributeBinding[])bindings);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DBSEntityReferrer getBestIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, DBDAttributeBindingMeta[] bindings, boolean readMetaData) throws DBException {
        ArrayList<Object> identifiers = new ArrayList<Object>(2);
        if (!(!readMetaData || table instanceof DBSTable && ((DBSTable)table).isView())) {
            Collection constraints;
            block15: {
                if (table instanceof DBSTable) {
                    try {
                        Collection indexes = ((DBSTable)table).getIndexes(monitor);
                        if (CommonUtils.isEmpty((Collection)indexes)) break block15;
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!dBSTableIndex.isPrimary() || !DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
            }
            if ((constraints = table.getConstraints(monitor)) != null) {
                for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                    if (!DBUtils.isIdentifierConstraint((DBRProgressMonitor)monitor, (DBSEntityConstraint)dBSEntityConstraint)) continue;
                    identifiers.add((DBSEntityReferrer)dBSEntityConstraint);
                }
            }
        }
        if (CommonUtils.isEmpty(identifiers)) {
            void var6_16;
            DBDAttributeBindingMeta[] dBDAttributeBindingMetaArray = bindings;
            int n = bindings.length;
            boolean bl = false;
            while (var6_16 < n) {
                DBDAttributeBindingMeta column = dBDAttributeBindingMetaArray[var6_16];
                DBDPseudoAttribute pseudoAttribute = column.getPseudoAttribute();
                if (pseudoAttribute != null && pseudoAttribute.getType() == DBDPseudoAttributeType.ROWID) {
                    identifiers.add(new DBDPseudoReferrer(table, (DBDAttributeBinding)column));
                    break;
                }
                ++var6_16;
            }
        }
        if (CommonUtils.isEmpty(identifiers)) {
            DBVEntity virtualEntity = DBVUtils.findVirtualEntity((DBSEntity)table, (boolean)true);
            identifiers.add(virtualEntity.getBestIdentifier());
        }
        if (!CommonUtils.isEmpty(identifiers)) {
            DBSEntityReferrer uniqueId = null;
            for (DBSEntityReferrer dBSEntityReferrer : identifiers) {
                if (!ResultSetUtils.isGoodReferrer(monitor, (DBDAttributeBinding[])bindings, dBSEntityReferrer)) continue;
                if (dBSEntityReferrer.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                    return dBSEntityReferrer;
                }
                if (uniqueId != null || !dBSEntityReferrer.getConstraintType().isUnique() && (!(dBSEntityReferrer instanceof DBSTableIndex) || !((DBSTableIndex)dBSEntityReferrer).isUnique())) continue;
                uniqueId = dBSEntityReferrer;
            }
            return uniqueId;
        }
        return null;
    }

    private static boolean isGoodReferrer(DBRProgressMonitor monitor, DBDAttributeBinding[] bindings, DBSEntityReferrer referrer) throws DBException {
        if (referrer instanceof DBDPseudoReferrer) {
            return true;
        }
        List references = referrer.getAttributeReferences(monitor);
        if (references == null || references.isEmpty()) {
            return referrer instanceof DBVEntityConstraint;
        }
        for (DBSEntityAttributeRef ref : references) {
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
                if (binding.matches((DBSAttributeBase)ref.getAttribute(), false)) {
                    return true;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean equalAttributes(DBCAttributeMetaData attr1, DBCAttributeMetaData attr2) {
        return SQLUtils.compareAliases((String)attr1.getLabel(), (String)attr2.getLabel()) && SQLUtils.compareAliases((String)attr1.getName(), (String)attr2.getName()) && CommonUtils.equalObjects((Object)attr1.getEntityMetaData(), (Object)attr2.getEntityMetaData()) && attr1.getOrdinalPosition() == attr2.getOrdinalPosition() && attr1.isRequired() == attr2.isRequired() && attr1.getMaxLength() == attr2.getMaxLength() && CommonUtils.equalObjects((Object)attr1.getPrecision(), (Object)attr2.getPrecision()) && CommonUtils.equalObjects((Object)attr1.getScale(), (Object)attr2.getScale()) && attr1.getTypeID() == attr2.getTypeID() && CommonUtils.equalObjects((Object)attr1.getTypeName(), (Object)attr2.getTypeName());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static Object getAttributeValueFromClipboard(DBDAttributeBinding attribute) throws DBCException {
        clipboard = new Clipboard(Display.getCurrent());
        try {
            var2_2 = null;
            var3_4 = null;
            try {
                session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)attribute, (String)"Copy from clipboard");
                try {
                    strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    var7_8 = attribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute.getAttribute(), (Object)strValue, true);
                    ** try [egrp 3[TRYBLOCK] [1 : 75->82)] { 
                }
lbl13:
                // 1 sources

                catch (Throwable var2_3) {
                    throw var2_3;
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    clipboard.dispose();
                    return var7_8;
                }
            }
            catch (Throwable var3_5) {
                if (var2_2 == null) {
                    var2_2 = var3_5;
                } else if (var2_2 != var3_5) {
                    var2_2.addSuppressed(var3_5);
                }
                throw var2_2;
            }
        }
        catch (Throwable var6_9) {
            clipboard.dispose();
            throw var6_9;
        }
    }

    public static void copyToClipboard(String string) {
        if (string != null && string.length() > 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{string}, new Transfer[]{textTransfer});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static boolean isServerSideFiltering(IResultSetController controller) {
        return controller.getPreferenceStore().getBoolean("resultset.order.serverSide") && (controller.isHasMoreData() || !CommonUtils.isEmpty((String)controller.getModel().getDataFilter().getOrder()));
    }
}

