/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInputFactory;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.SimpleCommandContext;

public abstract class DatabaseEditorInput<NODE extends DBNDatabaseNode>
implements IPersistableElement,
IDatabaseEditorInput,
IDataSourceContainerProvider {
    private static final Log log = Log.getLog(DatabaseEditorInput.class);
    private final NODE node;
    private final DBCExecutionContext executionContext;
    private final DBECommandContext commandContext;
    private String defaultPageId;
    private String defaultFolderId;
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    protected DatabaseEditorInput(@Nullable NODE node) {
        this(node, null);
    }

    protected DatabaseEditorInput(@Nullable NODE node, @Nullable DBECommandContext commandContext) {
        DBSObject object;
        this.node = node;
        DBSObject dBSObject = object = node == null ? null : node.getObject();
        if (object != null) {
            this.executionContext = DBUtils.getDefaultContext((DBSObject)object, (boolean)false);
            if (this.executionContext == null) {
                log.error((Object)"Database object is not associated with any execution context");
            }
            this.commandContext = commandContext != null ? commandContext : new SimpleCommandContext(this.executionContext, false);
        } else {
            this.executionContext = null;
            this.commandContext = null;
        }
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)this.node.getNodeIconDefault());
    }

    public String getName() {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.editor.full-name")) {
            return this.node.getNodeFullName();
        }
        return this.node.getName();
    }

    public IPersistableElement getPersistable() {
        if (this.getExecutionContext() == null || this.getDatabaseObject() == null || !this.getDatabaseObject().isPersisted() || !DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.editors.reopen-after-restart")) {
            return null;
        }
        return this;
    }

    public String getToolTipText() {
        return this.node.getNodeDescription();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbenchAdapter.class.equals(adapter)) {
            return adapter.cast(new WorkbenchAdapter(){

                public ImageDescriptor getImageDescriptor(Object object) {
                    return DBeaverIcons.getImageDescriptor((DBPImage)DatabaseEditorInput.this.node.getNodeIconDefault());
                }

                public String getLabel(Object o) {
                    return DatabaseEditorInput.this.node.getName();
                }

                public Object getParent(Object o) {
                    return DatabaseEditorInput.this.node.getParentNode();
                }
            });
        }
        if (DBSObject.class.equals(adapter)) {
            return adapter.cast(this.getDatabaseObject());
        }
        return null;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.executionContext != null) {
            return this.executionContext.getDataSource().getContainer();
        }
        if (this.node instanceof DBNDataSource) {
            return this.node.getDataSourceContainer();
        }
        return null;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public NODE getNavigatorNode() {
        return this.node;
    }

    @Override
    public DBSObject getDatabaseObject() {
        return this.node.getObject();
    }

    @Override
    public String getDefaultPageId() {
        return this.defaultPageId;
    }

    @Override
    public String getDefaultFolderId() {
        return this.defaultFolderId;
    }

    @Override
    @Nullable
    public DBECommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setDefaultPageId(String defaultPageId) {
        this.defaultPageId = defaultPageId;
    }

    public void setDefaultFolderId(String defaultFolderId) {
        this.defaultFolderId = defaultFolderId;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.attributes.remove(name);
        }
        return this.attributes.put(name, value);
    }

    @Override
    public DBPPropertySource getPropertySource() {
        PropertySourceEditable propertySource = new PropertySourceEditable(this.getCommandContext(), this.getNavigatorNode(), (Object)this.getDatabaseObject());
        propertySource.collectProperties();
        return propertySource;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DatabaseEditorInput && ((DatabaseEditorInput)obj).node.equals(this.node);
    }

    public String getFactoryId() {
        return DatabaseEditorInputFactory.ID_FACTORY;
    }

    public void saveState(IMemento memento) {
        DatabaseEditorInputFactory.saveState(memento, this);
    }
}

