/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.policy;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.jkiss.dbeaver.ext.erd.command.AssociationCreateCommand;
import org.jkiss.dbeaver.ext.erd.command.AssociationReconnectSourceCommand;
import org.jkiss.dbeaver.ext.erd.command.AssociationReconnectTargetCommand;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;

public class EntityConnectionEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        AssociationCreateCommand cmd = this.makeCreateCommand();
        EntityPart part = (EntityPart)this.getHost();
        cmd.setSourceEntity(part.getEntity());
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        AssociationCreateCommand cmd = (AssociationCreateCommand)request.getStartCommand();
        EntityPart part = (EntityPart)request.getTargetEditPart();
        cmd.setTargetEntity(part.getEntity());
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        AssociationReconnectSourceCommand cmd = this.makeReconnectSourceCommand();
        cmd.setAssociation((ERDAssociation)request.getConnectionEditPart().getModel());
        EntityPart entityPart = (EntityPart)this.getHost();
        cmd.setSourceEntity(entityPart.getEntity());
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        AssociationReconnectTargetCommand cmd = this.makeReconnectTargetCommand();
        cmd.setRelationship((ERDAssociation)request.getConnectionEditPart().getModel());
        EntityPart entityPart = (EntityPart)this.getHost();
        cmd.setTargetEntity(entityPart.getEntity());
        return cmd;
    }

    protected AssociationCreateCommand makeCreateCommand() {
        return new AssociationCreateCommand();
    }

    protected AssociationReconnectSourceCommand makeReconnectSourceCommand() {
        return new AssociationReconnectSourceCommand();
    }

    protected AssociationReconnectTargetCommand makeReconnectTargetCommand() {
        return new AssociationReconnectTargetCommand();
    }
}

