(function() {
  var DefaultDirectorySearcher, DirectorySearch, Task,
    slice = [].slice;

  Task = require('./task');

  DirectorySearch = (function() {
    function DirectorySearch(rootPaths, regex, options) {
      var scanHandlerOptions, searchOptions;
      scanHandlerOptions = {
        ignoreCase: regex.ignoreCase,
        inclusions: options.inclusions,
        includeHidden: options.includeHidden,
        excludeVcsIgnores: options.excludeVcsIgnores,
        globalExclusions: options.exclusions,
        follow: options.follow
      };
      searchOptions = {
        leadingContextLineCount: options.leadingContextLineCount,
        trailingContextLineCount: options.trailingContextLineCount
      };
      this.task = new Task(require.resolve('./scan-handler'));
      this.task.on('scan:result-found', options.didMatch);
      this.task.on('scan:file-error', options.didError);
      this.task.on('scan:paths-searched', options.didSearchPaths);
      this.promise = new Promise((function(_this) {
        return function(resolve, reject) {
          _this.task.on('task:cancelled', reject);
          return _this.task.start(rootPaths, regex.source, scanHandlerOptions, searchOptions, function() {
            _this.task.terminate();
            return resolve();
          });
        };
      })(this));
    }

    DirectorySearch.prototype.then = function() {
      var args;
      args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      return this.promise.then.apply(this.promise, args);
    };

    DirectorySearch.prototype.cancel = function() {
      this.task.cancel();
      return null;
    };

    return DirectorySearch;

  })();

  module.exports = DefaultDirectorySearcher = (function() {
    function DefaultDirectorySearcher() {}

    DefaultDirectorySearcher.prototype.canSearchDirectory = function(directory) {
      return true;
    };

    DefaultDirectorySearcher.prototype.search = function(directories, regex, options) {
      var directorySearch, isCancelled, promise, rootPaths;
      rootPaths = directories.map(function(directory) {
        return directory.getPath();
      });
      isCancelled = false;
      directorySearch = new DirectorySearch(rootPaths, regex, options);
      promise = new Promise(function(resolve, reject) {
        return directorySearch.then(resolve, function() {
          if (isCancelled) {
            return resolve();
          } else {
            return reject();
          }
        });
      });
      return {
        then: promise.then.bind(promise),
        "catch": promise["catch"].bind(promise),
        cancel: function() {
          isCancelled = true;
          return directorySearch.cancel();
        }
      };
    };

    return DefaultDirectorySearcher;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNi4wL291dC9hcHAvc3JjL2RlZmF1bHQtZGlyZWN0b3J5LXNlYXJjaGVyLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUEsK0NBQUE7SUFBQTs7RUFBQSxJQUFBLEdBQU8sT0FBQSxDQUFRLFFBQVI7O0VBSUQ7SUFDUyx5QkFBQyxTQUFELEVBQVksS0FBWixFQUFtQixPQUFuQjtBQUNYLFVBQUE7TUFBQSxrQkFBQSxHQUNFO1FBQUEsVUFBQSxFQUFZLEtBQUssQ0FBQyxVQUFsQjtRQUNBLFVBQUEsRUFBWSxPQUFPLENBQUMsVUFEcEI7UUFFQSxhQUFBLEVBQWUsT0FBTyxDQUFDLGFBRnZCO1FBR0EsaUJBQUEsRUFBbUIsT0FBTyxDQUFDLGlCQUgzQjtRQUlBLGdCQUFBLEVBQWtCLE9BQU8sQ0FBQyxVQUoxQjtRQUtBLE1BQUEsRUFBUSxPQUFPLENBQUMsTUFMaEI7O01BTUYsYUFBQSxHQUNFO1FBQUEsdUJBQUEsRUFBeUIsT0FBTyxDQUFDLHVCQUFqQztRQUNBLHdCQUFBLEVBQTBCLE9BQU8sQ0FBQyx3QkFEbEM7O01BRUYsSUFBQyxDQUFBLElBQUQsR0FBUSxJQUFJLElBQUosQ0FBUyxPQUFPLENBQUMsT0FBUixDQUFnQixnQkFBaEIsQ0FBVDtNQUNSLElBQUMsQ0FBQSxJQUFJLENBQUMsRUFBTixDQUFTLG1CQUFULEVBQThCLE9BQU8sQ0FBQyxRQUF0QztNQUNBLElBQUMsQ0FBQSxJQUFJLENBQUMsRUFBTixDQUFTLGlCQUFULEVBQTRCLE9BQU8sQ0FBQyxRQUFwQztNQUNBLElBQUMsQ0FBQSxJQUFJLENBQUMsRUFBTixDQUFTLHFCQUFULEVBQWdDLE9BQU8sQ0FBQyxjQUF4QztNQUNBLElBQUMsQ0FBQSxPQUFELEdBQVcsSUFBSSxPQUFKLENBQVksQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLE9BQUQsRUFBVSxNQUFWO1VBQ3JCLEtBQUMsQ0FBQSxJQUFJLENBQUMsRUFBTixDQUFTLGdCQUFULEVBQTJCLE1BQTNCO2lCQUNBLEtBQUMsQ0FBQSxJQUFJLENBQUMsS0FBTixDQUFZLFNBQVosRUFBdUIsS0FBSyxDQUFDLE1BQTdCLEVBQXFDLGtCQUFyQyxFQUF5RCxhQUF6RCxFQUF3RSxTQUFBO1lBQ3RFLEtBQUMsQ0FBQSxJQUFJLENBQUMsU0FBTixDQUFBO21CQUNBLE9BQUEsQ0FBQTtVQUZzRSxDQUF4RTtRQUZxQjtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBWjtJQWZBOzs4QkFxQmIsSUFBQSxHQUFNLFNBQUE7QUFDSixVQUFBO01BREs7YUFDTCxJQUFDLENBQUEsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFkLENBQW9CLElBQUMsQ0FBQSxPQUFyQixFQUE4QixJQUE5QjtJQURJOzs4QkFHTixNQUFBLEdBQVEsU0FBQTtNQUVOLElBQUMsQ0FBQSxJQUFJLENBQUMsTUFBTixDQUFBO2FBQ0E7SUFITTs7Ozs7O0VBTVYsTUFBTSxDQUFDLE9BQVAsR0FDTTs7O3VDQU1KLGtCQUFBLEdBQW9CLFNBQUMsU0FBRDthQUFlO0lBQWY7O3VDQW1DcEIsTUFBQSxHQUFRLFNBQUMsV0FBRCxFQUFjLEtBQWQsRUFBcUIsT0FBckI7QUFDTixVQUFBO01BQUEsU0FBQSxHQUFZLFdBQVcsQ0FBQyxHQUFaLENBQWdCLFNBQUMsU0FBRDtlQUFlLFNBQVMsQ0FBQyxPQUFWLENBQUE7TUFBZixDQUFoQjtNQUNaLFdBQUEsR0FBYztNQUNkLGVBQUEsR0FBa0IsSUFBSSxlQUFKLENBQW9CLFNBQXBCLEVBQStCLEtBQS9CLEVBQXNDLE9BQXRDO01BQ2xCLE9BQUEsR0FBVSxJQUFJLE9BQUosQ0FBWSxTQUFDLE9BQUQsRUFBVSxNQUFWO2VBQ3BCLGVBQWUsQ0FBQyxJQUFoQixDQUFxQixPQUFyQixFQUE4QixTQUFBO1VBQzVCLElBQUcsV0FBSDttQkFDRSxPQUFBLENBQUEsRUFERjtXQUFBLE1BQUE7bUJBR0UsTUFBQSxDQUFBLEVBSEY7O1FBRDRCLENBQTlCO01BRG9CLENBQVo7QUFNVixhQUFPO1FBQ0wsSUFBQSxFQUFNLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBYixDQUFrQixPQUFsQixDQUREO1FBRUwsQ0FBQSxLQUFBLENBQUEsRUFBTyxPQUFPLEVBQUMsS0FBRCxFQUFNLENBQUMsSUFBZCxDQUFtQixPQUFuQixDQUZGO1FBR0wsTUFBQSxFQUFRLFNBQUE7VUFDTixXQUFBLEdBQWM7aUJBQ2QsZUFBZSxDQUFDLE1BQWhCLENBQUE7UUFGTSxDQUhIOztJQVZEOzs7OztBQTdFViIsInNvdXJjZXNDb250ZW50IjpbIlRhc2sgPSByZXF1aXJlICcuL3Rhc2snXG5cbiMgU2VhcmNoZXMgbG9jYWwgZmlsZXMgZm9yIGxpbmVzIG1hdGNoaW5nIGEgc3BlY2lmaWVkIHJlZ2V4LiBJbXBsZW1lbnRzIGAudGhlbigpYFxuIyBzbyB0aGF0IGl0IGNhbiBiZSB1c2VkIHdpdGggYFByb21pc2UuYWxsKClgLlxuY2xhc3MgRGlyZWN0b3J5U2VhcmNoXG4gIGNvbnN0cnVjdG9yOiAocm9vdFBhdGhzLCByZWdleCwgb3B0aW9ucykgLT5cbiAgICBzY2FuSGFuZGxlck9wdGlvbnMgPVxuICAgICAgaWdub3JlQ2FzZTogcmVnZXguaWdub3JlQ2FzZVxuICAgICAgaW5jbHVzaW9uczogb3B0aW9ucy5pbmNsdXNpb25zXG4gICAgICBpbmNsdWRlSGlkZGVuOiBvcHRpb25zLmluY2x1ZGVIaWRkZW5cbiAgICAgIGV4Y2x1ZGVWY3NJZ25vcmVzOiBvcHRpb25zLmV4Y2x1ZGVWY3NJZ25vcmVzXG4gICAgICBnbG9iYWxFeGNsdXNpb25zOiBvcHRpb25zLmV4Y2x1c2lvbnNcbiAgICAgIGZvbGxvdzogb3B0aW9ucy5mb2xsb3dcbiAgICBzZWFyY2hPcHRpb25zID1cbiAgICAgIGxlYWRpbmdDb250ZXh0TGluZUNvdW50OiBvcHRpb25zLmxlYWRpbmdDb250ZXh0TGluZUNvdW50XG4gICAgICB0cmFpbGluZ0NvbnRleHRMaW5lQ291bnQ6IG9wdGlvbnMudHJhaWxpbmdDb250ZXh0TGluZUNvdW50XG4gICAgQHRhc2sgPSBuZXcgVGFzayhyZXF1aXJlLnJlc29sdmUoJy4vc2Nhbi1oYW5kbGVyJykpXG4gICAgQHRhc2sub24gJ3NjYW46cmVzdWx0LWZvdW5kJywgb3B0aW9ucy5kaWRNYXRjaFxuICAgIEB0YXNrLm9uICdzY2FuOmZpbGUtZXJyb3InLCBvcHRpb25zLmRpZEVycm9yXG4gICAgQHRhc2sub24gJ3NjYW46cGF0aHMtc2VhcmNoZWQnLCBvcHRpb25zLmRpZFNlYXJjaFBhdGhzXG4gICAgQHByb21pc2UgPSBuZXcgUHJvbWlzZSAocmVzb2x2ZSwgcmVqZWN0KSA9PlxuICAgICAgQHRhc2sub24oJ3Rhc2s6Y2FuY2VsbGVkJywgcmVqZWN0KVxuICAgICAgQHRhc2suc3RhcnQgcm9vdFBhdGhzLCByZWdleC5zb3VyY2UsIHNjYW5IYW5kbGVyT3B0aW9ucywgc2VhcmNoT3B0aW9ucywgPT5cbiAgICAgICAgQHRhc2sudGVybWluYXRlKClcbiAgICAgICAgcmVzb2x2ZSgpXG5cbiAgdGhlbjogKGFyZ3MuLi4pIC0+XG4gICAgQHByb21pc2UudGhlbi5hcHBseShAcHJvbWlzZSwgYXJncylcblxuICBjYW5jZWw6IC0+XG4gICAgIyBUaGlzIHdpbGwgY2F1c2UgQHByb21pc2UgdG8gcmVqZWN0LlxuICAgIEB0YXNrLmNhbmNlbCgpXG4gICAgbnVsbFxuXG4jIERlZmF1bHQgcHJvdmlkZXIgZm9yIHRoZSBgYXRvbS5kaXJlY3Rvcnktc2VhcmNoZXJgIHNlcnZpY2UuXG5tb2R1bGUuZXhwb3J0cyA9XG5jbGFzcyBEZWZhdWx0RGlyZWN0b3J5U2VhcmNoZXJcbiAgIyBEZXRlcm1pbmVzIHdoZXRoZXIgdGhpcyBvYmplY3Qgc3VwcG9ydHMgc2VhcmNoIGZvciBhIGBEaXJlY3RvcnlgLlxuICAjXG4gICMgKiBgZGlyZWN0b3J5YCB7RGlyZWN0b3J5fSB3aG9zZSBzZWFyY2ggbmVlZHMgbWlnaHQgYmUgc3VwcG9ydGVkIGJ5IHRoaXMgb2JqZWN0LlxuICAjXG4gICMgUmV0dXJucyBhIGBib29sZWFuYCBpbmRpY2F0aW5nIHdoZXRoZXIgdGhpcyBvYmplY3QgY2FuIHNlYXJjaCB0aGlzIGBEaXJlY3RvcnlgLlxuICBjYW5TZWFyY2hEaXJlY3Rvcnk6IChkaXJlY3RvcnkpIC0+IHRydWVcblxuICAjIFBlcmZvcm1zIGEgdGV4dCBzZWFyY2ggZm9yIGZpbGVzIGluIHRoZSBzcGVjaWZpZWQgYERpcmVjdG9yeWAsIHN1YmplY3QgdG8gdGhlXG4gICMgc3BlY2lmaWVkIHBhcmFtZXRlcnMuXG4gICNcbiAgIyBSZXN1bHRzIGFyZSBzdHJlYW1lZCBiYWNrIHRvIHRoZSBjYWxsZXIgYnkgaW52b2tpbmcgbWV0aG9kcyBvbiB0aGUgc3BlY2lmaWVkIGBvcHRpb25zYCxcbiAgIyBzdWNoIGFzIGBkaWRNYXRjaGAgYW5kIGBkaWRFcnJvcmAuXG4gICNcbiAgIyAqIGBkaXJlY3Rvcmllc2Age0FycmF5fSBvZiB7RGlyZWN0b3J5fSBvYmplY3RzIHRvIHNlYXJjaCwgYWxsIG9mIHdoaWNoIGhhdmUgYmVlbiBhY2NlcHRlZCBieVxuICAjIHRoaXMgc2VhcmNoZXIncyBgY2FuU2VhcmNoRGlyZWN0b3J5KClgIHByZWRpY2F0ZS5cbiAgIyAqIGByZWdleGAge1JlZ0V4cH0gdG8gc2VhcmNoIHdpdGguXG4gICMgKiBgb3B0aW9uc2Age09iamVjdH0gd2l0aCB0aGUgZm9sbG93aW5nIHByb3BlcnRpZXM6XG4gICMgICAqIGBkaWRNYXRjaGAge0Z1bmN0aW9ufSBjYWxsIHdpdGggYSBzZWFyY2ggcmVzdWx0IHN0cnVjdHVyZWQgYXMgZm9sbG93czpcbiAgIyAgICAgKiBgc2VhcmNoUmVzdWx0YCB7T2JqZWN0fSB3aXRoIHRoZSBmb2xsb3dpbmcga2V5czpcbiAgIyAgICAgICAqIGBmaWxlUGF0aGAge1N0cmluZ30gYWJzb2x1dGUgcGF0aCB0byB0aGUgbWF0Y2hpbmcgZmlsZS5cbiAgIyAgICAgICAqIGBtYXRjaGVzYCB7QXJyYXl9IHdpdGggb2JqZWN0IGVsZW1lbnRzIHdpdGggdGhlIGZvbGxvd2luZyBrZXlzOlxuICAjICAgICAgICAgKiBgbGluZVRleHRgIHtTdHJpbmd9IFRoZSBmdWxsIHRleHQgb2YgdGhlIG1hdGNoaW5nIGxpbmUgKHdpdGhvdXQgYSBsaW5lIHRlcm1pbmF0b3IgY2hhcmFjdGVyKS5cbiAgIyAgICAgICAgICogYGxpbmVUZXh0T2Zmc2V0YCB7TnVtYmVyfSAoVGhpcyBhbHdheXMgc2VlbXMgdG8gYmUgMD8pXG4gICMgICAgICAgICAqIGBtYXRjaFRleHRgIHtTdHJpbmd9IFRoZSB0ZXh0IHRoYXQgbWF0Y2hlZCB0aGUgYHJlZ2V4YCB1c2VkIGZvciB0aGUgc2VhcmNoLlxuICAjICAgICAgICAgKiBgcmFuZ2VgIHtSYW5nZX0gSWRlbnRpZmllcyB0aGUgbWF0Y2hpbmcgcmVnaW9uIGluIHRoZSBmaWxlLiAoTGlrZWx5IGFzIGFuIGFycmF5IG9mIG51bWVyaWMgYXJyYXlzLilcbiAgIyAgICogYGRpZEVycm9yYCB7RnVuY3Rpb259IGNhbGwgd2l0aCBhbiBFcnJvciBpZiB0aGVyZSBpcyBhIHByb2JsZW0gZHVyaW5nIHRoZSBzZWFyY2guXG4gICMgICAqIGBkaWRTZWFyY2hQYXRoc2Age0Z1bmN0aW9ufSBwZXJpb2RpY2FsbHkgY2FsbCB3aXRoIHRoZSBudW1iZXIgb2YgcGF0aHMgc2VhcmNoZWQgdGh1cyBmYXIuXG4gICMgICAqIGBpbmNsdXNpb25zYCB7QXJyYXl9IG9mIGdsb2IgcGF0dGVybnMgKGFzIHN0cmluZ3MpIHRvIHNlYXJjaCB3aXRoaW4uIE5vdGUgdGhhdCB0aGlzXG4gICMgICBhcnJheSBtYXkgYmUgZW1wdHksIGluZGljYXRpbmcgdGhhdCBhbGwgZmlsZXMgc2hvdWxkIGJlIHNlYXJjaGVkLlxuICAjXG4gICMgICBFYWNoIGl0ZW0gaW4gdGhlIGFycmF5IGlzIGEgZmlsZS9kaXJlY3RvcnkgcGF0dGVybiwgZS5nLiwgYHNyY2AgdG8gc2VhcmNoIGluIHRoZSBcInNyY1wiXG4gICMgICBkaXJlY3Rvcnkgb3IgYCouanNgIHRvIHNlYXJjaCBhbGwgSmF2YVNjcmlwdCBmaWxlcy4gSW4gcHJhY3RpY2UsIHRoaXMgb2Z0ZW4gY29tZXMgZnJvbSB0aGVcbiAgIyAgIGNvbW1hLWRlbGltaXRlZCBsaXN0IG9mIHBhdHRlcm5zIGluIHRoZSBib3R0b20gdGV4dCBpbnB1dCBvZiB0aGUgUHJvamVjdEZpbmRWaWV3IGRpYWxvZy5cbiAgIyAgICogYGlnbm9yZUhpZGRlbmAge2Jvb2xlYW59IHdoZXRoZXIgdG8gaWdub3JlIGhpZGRlbiBmaWxlcy5cbiAgIyAgICogYGV4Y2x1ZGVWY3NJZ25vcmVzYCB7Ym9vbGVhbn0gd2hldGhlciB0byBleGNsdWRlIFZDUyBpZ25vcmVkIHBhdGhzLlxuICAjICAgKiBgZXhjbHVzaW9uc2Age0FycmF5fSBzaW1pbGFyIHRvIGluY2x1c2lvbnNcbiAgIyAgICogYGZvbGxvd2Age2Jvb2xlYW59IHdoZXRoZXIgc3ltbGlua3Mgc2hvdWxkIGJlIGZvbGxvd2VkLlxuICAjXG4gICMgUmV0dXJucyBhICp0aGVuYWJsZSogYERpcmVjdG9yeVNlYXJjaGAgdGhhdCBpbmNsdWRlcyBhIGBjYW5jZWwoKWAgbWV0aG9kLiBJZiBgY2FuY2VsKClgIGlzXG4gICMgaW52b2tlZCBiZWZvcmUgdGhlIGBEaXJlY3RvcnlTZWFyY2hgIGlzIGRldGVybWluZWQsIGl0IHdpbGwgcmVzb2x2ZSB0aGUgYERpcmVjdG9yeVNlYXJjaGAuXG4gIHNlYXJjaDogKGRpcmVjdG9yaWVzLCByZWdleCwgb3B0aW9ucykgLT5cbiAgICByb290UGF0aHMgPSBkaXJlY3Rvcmllcy5tYXAgKGRpcmVjdG9yeSkgLT4gZGlyZWN0b3J5LmdldFBhdGgoKVxuICAgIGlzQ2FuY2VsbGVkID0gZmFsc2VcbiAgICBkaXJlY3RvcnlTZWFyY2ggPSBuZXcgRGlyZWN0b3J5U2VhcmNoKHJvb3RQYXRocywgcmVnZXgsIG9wdGlvbnMpXG4gICAgcHJvbWlzZSA9IG5ldyBQcm9taXNlIChyZXNvbHZlLCByZWplY3QpIC0+XG4gICAgICBkaXJlY3RvcnlTZWFyY2gudGhlbiByZXNvbHZlLCAtPlxuICAgICAgICBpZiBpc0NhbmNlbGxlZFxuICAgICAgICAgIHJlc29sdmUoKVxuICAgICAgICBlbHNlXG4gICAgICAgICAgcmVqZWN0KClcbiAgICByZXR1cm4ge1xuICAgICAgdGhlbjogcHJvbWlzZS50aGVuLmJpbmQocHJvbWlzZSlcbiAgICAgIGNhdGNoOiBwcm9taXNlLmNhdGNoLmJpbmQocHJvbWlzZSlcbiAgICAgIGNhbmNlbDogLT5cbiAgICAgICAgaXNDYW5jZWxsZWQgPSB0cnVlXG4gICAgICAgIGRpcmVjdG9yeVNlYXJjaC5jYW5jZWwoKVxuICAgIH1cbiJdfQ==
